// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes the access type and endpoint for a WorkSpace.
type AccessEndpoint struct {

	// Indicates the type of access endpoint.
	AccessEndpointType AccessEndpointType

	// Indicates the VPC endpoint to use for access.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// Describes the access endpoint configuration for a WorkSpace.
type AccessEndpointConfig struct {

	// Indicates a list of access endpoints associated with this directory.
	//
	// This member is required.
	AccessEndpoints []AccessEndpoint

	// Indicates a list of protocols that fallback to using the public Internet when
	// streaming over a VPC endpoint is not available.
	InternetFallbackProtocols []InternetFallbackProtocol

	noSmithyDocumentSerde
}

// Information about about the account link.
type AccountLink struct {

	// The identifier of the account link.
	AccountLinkId *string

	// The status of the account link.
	AccountLinkStatus AccountLinkStatusEnum

	// The identifier of the source account.
	SourceAccountId *string

	// The identifier of the target account.
	TargetAccountId *string

	noSmithyDocumentSerde
}

// Describes a modification to the configuration of Bring Your Own License (BYOL)
// for the specified account.
type AccountModification struct {

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface used for the account.
	DedicatedTenancyManagementCidrRange *string

	// The status of BYOL (whether BYOL is being enabled or disabled).
	DedicatedTenancySupport DedicatedTenancySupportResultEnum

	// The error code that is returned if the configuration of BYOL cannot be modified.
	ErrorCode *string

	// The text of the error message that is returned if the configuration of BYOL
	// cannot be modified.
	ErrorMessage *string

	// The state of the modification to the configuration of BYOL.
	ModificationState DedicatedTenancyModificationStateEnum

	// The timestamp when the modification of the BYOL configuration was started.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Information about the Active Directory config.
type ActiveDirectoryConfig struct {

	// The name of the domain.
	//
	// This member is required.
	DomainName *string

	// Indicates the secret ARN on the service account.
	//
	// This member is required.
	ServiceAccountSecretArn *string

	noSmithyDocumentSerde
}

// Describes the association between an application and an application resource.
type ApplicationResourceAssociation struct {

	// The identifier of the application.
	ApplicationId *string

	// The identifier of the associated resource.
	AssociatedResourceId *string

	// The resource type of the associated resource.
	AssociatedResourceType ApplicationAssociatedResourceType

	// The time the association was created.
	Created *time.Time

	// The time the association status was last updated.
	LastUpdatedTime *time.Time

	// The status of the application resource association.
	State AssociationState

	// The reason the association deployment failed.
	StateReason *AssociationStateReason

	noSmithyDocumentSerde
}

// The persistent application settings for WorkSpaces Pools users.
type ApplicationSettingsRequest struct {

	// Enables or disables persistent application settings for users during their pool
	// sessions.
	//
	// This member is required.
	Status ApplicationSettingsStatusEnum

	// The path prefix for the S3 bucket where users’ persistent application settings
	// are stored. You can allow the same persistent application settings to be used
	// across multiple pools by specifying the same settings group for each pool.
	SettingsGroup *string

	noSmithyDocumentSerde
}

// Describes the persistent application settings for WorkSpaces Pools users.
type ApplicationSettingsResponse struct {

	// Specifies whether persistent application settings are enabled for users during
	// their pool sessions.
	//
	// This member is required.
	Status ApplicationSettingsStatusEnum

	// The S3 bucket where users’ persistent application settings are stored. When
	// persistent application settings are enabled for the first time for an account in
	// an Amazon Web Services Region, an S3 bucket is created. The bucket is unique to
	// the Amazon Web Services account and the Region.
	S3BucketName *string

	// The path prefix for the S3 bucket where users’ persistent application settings
	// are stored.
	SettingsGroup *string

	noSmithyDocumentSerde
}

// Indicates the reason that the association deployment failed, including the
// error code and error message.
type AssociationStateReason struct {

	// The error code of the association deployment failure.
	ErrorCode AssociationErrorCode

	// The error message of the association deployment failure.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Describes the association between an application and a bundle resource.
type BundleResourceAssociation struct {

	// The identifier of the associated resource.
	AssociatedResourceId *string

	// The resource type of the associated resources.
	AssociatedResourceType BundleAssociatedResourceType

	// The identifier of the bundle.
	BundleId *string

	// The time the association is created.
	Created *time.Time

	// The time the association status was last updated.
	LastUpdatedTime *time.Time

	// The status of the bundle resource association.
	State AssociationState

	// The reason the association deployment failed.
	StateReason *AssociationStateReason

	noSmithyDocumentSerde
}

// Describes the user capacity for a pool of WorkSpaces.
type Capacity struct {

	// The desired number of user sessions for the WorkSpaces in the pool.
	//
	// This member is required.
	DesiredUserSessions *int32

	noSmithyDocumentSerde
}

// Describes the capacity status for a pool of WorkSpaces.
type CapacityStatus struct {

	// The number of user sessions currently being used for your pool.
	//
	// This member is required.
	ActiveUserSessions *int32

	// The total number of user sessions that are available for streaming or are
	// currently streaming in your pool.
	//
	// ActualUserSessions = AvailableUserSessions + ActiveUserSessions
	//
	// This member is required.
	ActualUserSessions *int32

	// The number of user sessions currently available for streaming from your pool.
	//
	// AvailableUserSessions = ActualUserSessions - ActiveUserSessions
	//
	// This member is required.
	AvailableUserSessions *int32

	// The total number of sessions slots that are either running or pending. This
	// represents the total number of concurrent streaming sessions your pool can
	// support in a steady state.
	//
	// This member is required.
	DesiredUserSessions *int32

	noSmithyDocumentSerde
}

// Describes the properties of the certificate-based authentication you want to
// use with your WorkSpaces.
type CertificateBasedAuthProperties struct {

	// The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager
	// Private CA resource.
	CertificateAuthorityArn *string

	// The status of the certificate-based authentication properties.
	Status CertificateBasedAuthStatusEnum

	noSmithyDocumentSerde
}

// Describes an Amazon WorkSpaces client.
type ClientProperties struct {

	// Specifies whether users can upload diagnostic log files of Amazon WorkSpaces
	// client directly to WorkSpaces to troubleshoot issues when using the WorkSpaces
	// client. When enabled, the log files will be sent to WorkSpaces automatically and
	// will be applied to all users in the specified directory.
	LogUploadEnabled LogUploadEnum

	// Specifies whether users can cache their credentials on the Amazon WorkSpaces
	// client. When enabled, users can choose to reconnect to their WorkSpaces without
	// re-entering their credentials.
	ReconnectEnabled ReconnectEnum

	noSmithyDocumentSerde
}

// Information about the Amazon WorkSpaces client.
type ClientPropertiesResult struct {

	// Information about the Amazon WorkSpaces client.
	ClientProperties *ClientProperties

	// The resource identifier, in the form of a directory ID.
	ResourceId *string

	noSmithyDocumentSerde
}

// Describes the compute type of the bundle.
type ComputeType struct {

	// The compute type.
	Name Compute

	noSmithyDocumentSerde
}

// Describes an Amazon Connect client add-in.
type ConnectClientAddIn struct {

	// The client add-in identifier.
	AddInId *string

	// The name of the client add in.
	Name *string

	// The directory identifier for which the client add-in is configured.
	ResourceId *string

	// The endpoint URL of the client add-in.
	URL *string

	noSmithyDocumentSerde
}

// Describes a connection alias. Connection aliases are used for cross-Region
// redirection. For more information, see [Cross-Region Redirection for Amazon WorkSpaces].
//
// [Cross-Region Redirection for Amazon WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html
type ConnectionAlias struct {

	// The identifier of the connection alias.
	AliasId *string

	// The association status of the connection alias.
	Associations []ConnectionAliasAssociation

	// The connection string specified for the connection alias. The connection string
	// must be in the form of a fully qualified domain name (FQDN), such as
	// www.example.com .
	ConnectionString *string

	// The identifier of the Amazon Web Services account that owns the connection
	// alias.
	OwnerAccountId *string

	// The current state of the connection alias.
	State ConnectionAliasState

	noSmithyDocumentSerde
}

// Describes a connection alias association that is used for cross-Region
// redirection. For more information, see [Cross-Region Redirection for Amazon WorkSpaces].
//
// [Cross-Region Redirection for Amazon WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html
type ConnectionAliasAssociation struct {

	// The identifier of the Amazon Web Services account that associated the
	// connection alias with a directory.
	AssociatedAccountId *string

	// The association status of the connection alias.
	AssociationStatus AssociationStatus

	// The identifier of the connection alias association. You use the connection
	// identifier in the DNS TXT record when you're configuring your DNS routing
	// policies.
	ConnectionIdentifier *string

	// The identifier of the directory associated with a connection alias.
	ResourceId *string

	noSmithyDocumentSerde
}

// Describes the permissions for a connection alias. Connection aliases are used
// for cross-Region redirection. For more information, see [Cross-Region Redirection for Amazon WorkSpaces].
//
// [Cross-Region Redirection for Amazon WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html
type ConnectionAliasPermission struct {

	// Indicates whether the specified Amazon Web Services account is allowed to
	// associate the connection alias with a directory.
	//
	// This member is required.
	AllowAssociation *bool

	// The identifier of the Amazon Web Services account that the connection alias is
	// shared with.
	//
	// This member is required.
	SharedAccountId *string

	noSmithyDocumentSerde
}

// Describes in-depth details about the error. These details include the possible
// causes of the error and troubleshooting information.
type CustomWorkspaceImageImportErrorDetails struct {

	// The error code that is returned for the image import.
	ErrorCode *string

	// The text of the error message that is returned for the image import.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Describes the data replication settings.
type DataReplicationSettings struct {

	// Indicates whether data replication is enabled, and if enabled, the type of data
	// replication.
	DataReplication DataReplication

	// The date and time at which the last successful snapshot was taken of the
	// primary WorkSpace used for replicating data.
	RecoverySnapshotTime *time.Time

	noSmithyDocumentSerde
}

// Returns default client branding attributes that were imported. These attributes
// display on the client login screen.
//
// Client branding attributes are public facing. Ensure that you don't include
// sensitive information.
type DefaultClientBrandingAttributes struct {

	// The forgotten password link. This is the web address that users can go to if
	// they forget the password for their WorkSpace.
	ForgotPasswordLink *string

	// The login message. Specified as a key value pair, in which the key is a locale
	// and the value is the localized message for that locale. The only key supported
	// is en_US . The HTML tags supported include the following: a, b, blockquote, br,
	// cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike,
	// strong, sub, sup, u, ul .
	LoginMessage map[string]string

	// The logo. The only image format accepted is a binary data object that is
	// converted from a .png file.
	LogoUrl *string

	// The support email. The company's customer support email address.
	//
	//   - In each platform type, the SupportEmail and SupportLink parameters are
	//   mutually exclusive. You can specify one parameter for each platform type, but
	//   not both.
	//
	//   - The default email is workspaces-feedback@amazon.com .
	SupportEmail *string

	// The support link. The link for the company's customer support page for their
	// WorkSpace.
	//
	//   - In each platform type, the SupportEmail and SupportLink parameters are
	//   mutually exclusive.You can specify one parameter for each platform type, but not
	//   both.
	//
	//   - The default support link is workspaces-feedback@amazon.com .
	SupportLink *string

	noSmithyDocumentSerde
}

// The default client branding attributes to be imported. These attributes display
// on the client login screen.
//
// Client branding attributes are public facing. Ensure that you do not include
// sensitive information.
type DefaultImportClientBrandingAttributes struct {

	// The forgotten password link. This is the web address that users can go to if
	// they forget the password for their WorkSpace.
	ForgotPasswordLink *string

	// The login message. Specified as a key value pair, in which the key is a locale
	// and the value is the localized message for that locale. The only key supported
	// is en_US . The HTML tags supported include the following: a, b, blockquote, br,
	// cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike,
	// strong, sub, sup, u, ul .
	LoginMessage map[string]string

	// The logo. The only image format accepted is a binary data object that is
	// converted from a .png file.
	Logo []byte

	// The support email. The company's customer support email address.
	//
	//   - In each platform type, the SupportEmail and SupportLink parameters are
	//   mutually exclusive. You can specify one parameter for each platform type, but
	//   not both.
	//
	//   - The default email is workspaces-feedback@amazon.com .
	SupportEmail *string

	// The support link. The link for the company's customer support page for their
	// WorkSpace.
	//
	//   - In each platform type, the SupportEmail and SupportLink parameters are
	//   mutually exclusive. You can specify one parameter for each platform type, but
	//   not both.
	//
	//   - The default support link is workspaces-feedback@amazon.com .
	SupportLink *string

	noSmithyDocumentSerde
}

// Describes the default values that are used to create WorkSpaces. For more
// information, see [Update Directory Details for Your WorkSpaces].
//
// [Update Directory Details for Your WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html
type DefaultWorkspaceCreationProperties struct {

	// The identifier of the default security group to apply to WorkSpaces when they
	// are created. For more information, see [Security Groups for Your WorkSpaces].
	//
	// [Security Groups for Your WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html
	CustomSecurityGroupId *string

	// The organizational unit (OU) in the directory for the WorkSpace machine
	// accounts.
	DefaultOu *string

	// Specifies whether to automatically assign an Elastic public IP address to
	// WorkSpaces in this directory by default. If enabled, the Elastic public IP
	// address allows outbound internet access from your WorkSpaces when you’re using
	// an internet gateway in the Amazon VPC in which your WorkSpaces are located. If
	// you're using a Network Address Translation (NAT) gateway for outbound internet
	// access from your VPC, or if your WorkSpaces are in public subnets and you
	// manually assign them Elastic IP addresses, you should disable this setting. This
	// setting applies to new WorkSpaces that you launch or to existing WorkSpaces that
	// you rebuild. For more information, see [Configure a VPC for Amazon WorkSpaces].
	//
	// [Configure a VPC for Amazon WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html
	EnableInternetAccess *bool

	// Specifies whether maintenance mode is enabled for WorkSpaces. For more
	// information, see [WorkSpace Maintenance].
	//
	// [WorkSpace Maintenance]: https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html
	EnableMaintenanceMode *bool

	// Indicates the IAM role ARN of the instance.
	InstanceIamRoleArn *string

	// Specifies whether WorkSpace users are local administrators on their WorkSpaces.
	UserEnabledAsLocalAdministrator *bool

	noSmithyDocumentSerde
}

// Describes the filter conditions for the WorkSpaces to return.
type DescribeWorkspaceDirectoriesFilter struct {

	// The name of the WorkSpaces to filter.
	//
	// This member is required.
	Name DescribeWorkspaceDirectoriesFilterName

	// The values for filtering WorkSpaces
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Describes the filter conditions for WorkSpaces Pools to return.
type DescribeWorkspacesPoolsFilter struct {

	// The name of the pool to filter.
	//
	// This member is required.
	Name DescribeWorkspacesPoolsFilterName

	// The operator values for filtering WorkSpaces Pools.
	//
	// This member is required.
	Operator DescribeWorkspacesPoolsFilterOperator

	// The values for filtering WorkSpaces Pools.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Describes in-depth details about the error. These details include the possible
// causes of the error and troubleshooting information.
type ErrorDetails struct {

	// Indicates the error code returned.
	ErrorCode WorkspaceImageErrorDetailCode

	// The text of the error message related the error code.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Describes the standby WorkSpace that could not be created.
type FailedCreateStandbyWorkspacesRequest struct {

	// The error code that is returned if the standby WorkSpace could not be created.
	ErrorCode *string

	// The text of the error message that is returned if the standby WorkSpace could
	// not be created.
	ErrorMessage *string

	// Information about the standby WorkSpace that could not be created.
	StandbyWorkspaceRequest *StandbyWorkspace

	noSmithyDocumentSerde
}

// Describes a WorkSpace that cannot be created.
type FailedCreateWorkspaceRequest struct {

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string

	// Information about the WorkSpace.
	WorkspaceRequest *WorkspaceRequest

	noSmithyDocumentSerde
}

// Describes a WorkSpace that could not be rebooted. (RebootWorkspaces ), rebuilt (RebuildWorkspaces ), restored (RestoreWorkspace
// ), terminated (TerminateWorkspaces ), started (StartWorkspaces ), or stopped (StopWorkspaces ).
type FailedWorkspaceChangeRequest struct {

	// The error code that is returned if the WorkSpace cannot be rebooted.
	ErrorCode *string

	// The text of the error message that is returned if the WorkSpace cannot be
	// rebooted.
	ErrorMessage *string

	// The identifier of the WorkSpace.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the Global Accelerator for directory
type GlobalAcceleratorForDirectory struct {

	// Indicates if Global Accelerator for directory is enabled or disabled.
	//
	// This member is required.
	Mode AGAModeForDirectoryEnum

	// Indicates the preferred protocol for Global Accelerator.
	PreferredProtocol AGAPreferredProtocolForDirectory

	noSmithyDocumentSerde
}

// Describes the Global Accelerator for WorkSpaces.
type GlobalAcceleratorForWorkSpace struct {

	// Indicates if Global Accelerator for WorkSpaces is enabled, disabled, or the
	// same mode as the associated directory.
	//
	// This member is required.
	Mode AGAModeForWorkSpaceEnum

	// Indicates the preferred protocol for Global Accelerator.
	PreferredProtocol AGAPreferredProtocolForWorkSpace

	noSmithyDocumentSerde
}

// Specifies the configurations of the identity center.
type IDCConfig struct {

	// The Amazon Resource Name (ARN) of the application.
	ApplicationArn *string

	// The Amazon Resource Name (ARN) of the identity center instance.
	InstanceArn *string

	noSmithyDocumentSerde
}

// Describes the Amazon Web Services accounts that have been granted permission to
// use a shared image. For more information about sharing images, see [Share or Unshare a Custom WorkSpaces Image].
//
// [Share or Unshare a Custom WorkSpaces Image]: https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html
type ImagePermission struct {

	// The identifier of the Amazon Web Services account that an image has been shared
	// with.
	SharedAccountId *string

	noSmithyDocumentSerde
}

// Describes the association between an application and an image resource.
type ImageResourceAssociation struct {

	// The identifier of the associated resource.
	AssociatedResourceId *string

	// The resource type of the associated resources.
	AssociatedResourceType ImageAssociatedResourceType

	// The time the association is created.
	Created *time.Time

	// The identifier of the image.
	ImageId *string

	// The time the association status was last updated.
	LastUpdatedTime *time.Time

	// The status of the image resource association.
	State AssociationState

	// The reason the association deployment failed.
	StateReason *AssociationStateReason

	noSmithyDocumentSerde
}

// Describes the image import source.
//
// The following types satisfy this interface:
//
//	ImageSourceIdentifierMemberEc2ImageId
//	ImageSourceIdentifierMemberEc2ImportTaskId
//	ImageSourceIdentifierMemberImageBuildVersionArn
type ImageSourceIdentifier interface {
	isImageSourceIdentifier()
}

// The identifier of the EC2 image.
type ImageSourceIdentifierMemberEc2ImageId struct {
	Value string

	noSmithyDocumentSerde
}

func (*ImageSourceIdentifierMemberEc2ImageId) isImageSourceIdentifier() {}

// The EC2 import task ID to import the image from the Amazon EC2 VM import
// process.
type ImageSourceIdentifierMemberEc2ImportTaskId struct {
	Value string

	noSmithyDocumentSerde
}

func (*ImageSourceIdentifierMemberEc2ImportTaskId) isImageSourceIdentifier() {}

// The ARN of the EC2 Image Builder image.
type ImageSourceIdentifierMemberImageBuildVersionArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*ImageSourceIdentifierMemberImageBuildVersionArn) isImageSourceIdentifier() {}

// The client branding attributes for iOS device types. These attributes are
// displayed on the iOS client login screen only.
//
// Client branding attributes are public facing. Ensure you do not include
// sensitive information.
type IosClientBrandingAttributes struct {

	// The forgotten password link. This is the web address that users can go to if
	// they forget the password for their WorkSpace.
	ForgotPasswordLink *string

	// The login message. Specified as a key value pair, in which the key is a locale
	// and the value is the localized message for that locale. The only key supported
	// is en_US . The HTML tags supported include the following: a, b, blockquote, br,
	// cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike,
	// strong, sub, sup, u, ul .
	LoginMessage map[string]string

	// The @2x version of the logo. This is the higher resolution display that offers
	// a scale factor of 2.0 (or @2x). The only image format accepted is a binary data
	// object that is converted from a .png file.
	//
	// For more information about iOS image size and resolution, see [Image Size and Resolution] in the Apple
	// Human Interface Guidelines.
	//
	// [Image Size and Resolution]: https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/
	Logo2xUrl *string

	// The @3x version of the logo. This is the higher resolution display that offers
	// a scale factor of 3.0 (or @3x).The only image format accepted is a binary data
	// object that is converted from a .png file.
	//
	// For more information about iOS image size and resolution, see [Image Size and Resolution] in the Apple
	// Human Interface Guidelines.
	//
	// [Image Size and Resolution]: https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/
	Logo3xUrl *string

	// The logo. This is the standard-resolution display that has a 1:1 pixel density
	// (or @1x), where one pixel is equal to one point. The only image format accepted
	// is a binary data object that is converted from a .png file.
	LogoUrl *string

	// The support email. The company's customer support email address.
	//
	//   - In each platform type, the SupportEmail and SupportLink parameters are
	//   mutually exclusive. You can specify one parameter for each platform type, but
	//   not both.
	//
	//   - The default email is workspaces-feedback@amazon.com .
	SupportEmail *string

	// The support link. The link for the company's customer support page for their
	// WorkSpace.
	//
	//   - In each platform type, the SupportEmail and SupportLink parameters are
	//   mutually exclusive. You can specify one parameter for each platform type, but
	//   not both.
	//
	//   - The default support link is workspaces-feedback@amazon.com .
	SupportLink *string

	noSmithyDocumentSerde
}

// The client branding attributes to import for iOS device types. These attributes
// are displayed on the iOS client login screen.
//
// Client branding attributes are public facing. Ensure you do not include
// sensitive information.
type IosImportClientBrandingAttributes struct {

	// The forgotten password link. This is the web address that users can go to if
	// they forget the password for their WorkSpace.
	ForgotPasswordLink *string

	// The login message. Specified as a key value pair, in which the key is a locale
	// and the value is the localized message for that locale. The only key supported
	// is en_US . The HTML tags supported include the following: a, b, blockquote, br,
	// cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike,
	// strong, sub, sup, u, ul .
	LoginMessage map[string]string

	// The logo. This is the standard-resolution display that has a 1:1 pixel density
	// (or @1x), where one pixel is equal to one point. The only image format accepted
	// is a binary data object that is converted from a .png file.
	Logo []byte

	// The @2x version of the logo. This is the higher resolution display that offers
	// a scale factor of 2.0 (or @2x). The only image format accepted is a binary data
	// object that is converted from a .png file.
	//
	// For more information about iOS image size and resolution, see [Image Size and Resolution] in the Apple
	// Human Interface Guidelines.
	//
	// [Image Size and Resolution]: https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/
	Logo2x []byte

	// The @3x version of the logo. This is the higher resolution display that offers
	// a scale factor of 3.0 (or @3x). The only image format accepted is a binary data
	// object that is converted from a .png file.
	//
	// For more information about iOS image size and resolution, see [Image Size and Resolution] in the Apple
	// Human Interface Guidelines.
	//
	// [Image Size and Resolution]: https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/
	Logo3x []byte

	// The support email. The company's customer support email address.
	//
	//   - In each platform type, the SupportEmail and SupportLink parameters are
	//   mutually exclusive. You can specify one parameter for each platform type, but
	//   not both.
	//
	//   - The default email is workspaces-feedback@amazon.com .
	SupportEmail *string

	// The support link. The link for the company's customer support page for their
	// WorkSpace.
	//
	//   - In each platform type, the SupportEmail and SupportLink parameters are
	//   mutually exclusive. You can specify one parameter for each platform type, but
	//   not both.
	//
	//   - The default support link is workspaces-feedback@amazon.com .
	SupportLink *string

	noSmithyDocumentSerde
}

// Describes a rule for an IP access control group.
type IpRuleItem struct {

	// The IP address range, in CIDR notation.
	IpRule *string

	// The description.
	RuleDesc *string

	noSmithyDocumentSerde
}

// Specifies the configurations of the Microsoft Entra.
type MicrosoftEntraConfig struct {

	// The Amazon Resource Name (ARN) of the application config.
	ApplicationConfigSecretArn *string

	// The identifier of the tenant.
	TenantId *string

	noSmithyDocumentSerde
}

// Describes a WorkSpace modification.
type ModificationState struct {

	// The resource.
	Resource ModificationResourceEnum

	// The modification state.
	State ModificationStateEnum

	noSmithyDocumentSerde
}

// Describes the network details of a WorkSpaces Pool.
type NetworkAccessConfiguration struct {

	// The resource identifier of the elastic network interface that is attached to
	// instances in your VPC. All network interfaces have the eni-xxxxxxxx resource
	// identifier.
	EniId *string

	// The private IP address of the elastic network interface that is attached to
	// instances in your VPC.
	EniPrivateIpAddress *string

	noSmithyDocumentSerde
}

// The operating system that the image is running.
type OperatingSystem struct {

	// The operating system.
	Type OperatingSystemType

	noSmithyDocumentSerde
}

// Information about the standby WorkSpace.
type PendingCreateStandbyWorkspacesRequest struct {

	// The identifier of the directory for the standby WorkSpace.
	DirectoryId *string

	// The operational state of the standby WorkSpace.
	State WorkspaceState

	// Describes the standby WorkSpace that was created.
	//
	// Because this operation is asynchronous, the identifier returned is not
	// immediately available for use with other operations. For example, if you call [DescribeWorkspaces]
	// before the WorkSpace is created, the information returned can be incomplete.
	//
	// [DescribeWorkspaces]: https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html
	UserName *string

	// The identifier of the standby WorkSpace.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the information used to reboot a WorkSpace.
type RebootRequest struct {

	// The identifier of the WorkSpace.
	//
	// This member is required.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the information used to rebuild a WorkSpace.
type RebuildRequest struct {

	// The identifier of the WorkSpace.
	//
	// This member is required.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the related WorkSpace. The related WorkSpace could be a standby
// WorkSpace or primary WorkSpace related to the specified WorkSpace.
type RelatedWorkspaceProperties struct {

	// The Region of the related WorkSpace.
	Region *string

	// Indicates the state of the WorkSpace.
	State WorkspaceState

	// Indicates the type of WorkSpace.
	Type StandbyWorkspaceRelationshipType

	// The identifier of the related WorkSpace.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the root volume for a WorkSpace bundle.
type RootStorage struct {

	// The size of the root volume.
	//
	// This member is required.
	Capacity *string

	noSmithyDocumentSerde
}

// Describes the enablement status, user access URL, and relay state parameter
// name that are used for configuring federation with an SAML 2.0 identity
// provider.
type SamlProperties struct {

	// The relay state parameter name supported by the SAML 2.0 identity provider
	// (IdP). When the end user is redirected to the user access URL from the
	// WorkSpaces client application, this relay state parameter name is appended as a
	// query parameter to the URL along with the relay state endpoint to return the
	// user to the client application session.
	//
	// To use SAML 2.0 authentication with WorkSpaces, the IdP must support
	// IdP-initiated deep linking for the relay state URL. Consult your IdP
	// documentation for more information.
	RelayStateParameterName *string

	// Indicates the status of SAML 2.0 authentication. These statuses include the
	// following.
	//
	//   - If the setting is DISABLED , end users will be directed to login with their
	//   directory credentials.
	//
	//   - If the setting is ENABLED , end users will be directed to login via the user
	//   access URL. Users attempting to connect to WorkSpaces from a client application
	//   that does not support SAML 2.0 authentication will not be able to connect.
	//
	//   - If the setting is ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK , end users will be
	//   directed to login via the user access URL on supported client applications, but
	//   will not prevent clients that do not support SAML 2.0 authentication from
	//   connecting as if SAML 2.0 authentication was disabled.
	Status SamlStatusEnum

	// The SAML 2.0 identity provider (IdP) user access URL is the URL a user would
	// navigate to in their web browser in order to federate from the IdP and directly
	// access the application, without any SAML 2.0 service provider (SP) bindings.
	UserAccessUrl *string

	noSmithyDocumentSerde
}

// Describes the self-service permissions for a directory. For more information,
// see [Enable Self-Service WorkSpace Management Capabilities for Your Users].
//
// [Enable Self-Service WorkSpace Management Capabilities for Your Users]: https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html
type SelfservicePermissions struct {

	// Specifies whether users can change the compute type (bundle) for their
	// WorkSpace.
	ChangeComputeType ReconnectEnum

	// Specifies whether users can increase the volume size of the drives on their
	// WorkSpace.
	IncreaseVolumeSize ReconnectEnum

	// Specifies whether users can rebuild the operating system of a WorkSpace to its
	// original state.
	RebuildWorkspace ReconnectEnum

	// Specifies whether users can restart their WorkSpace.
	RestartWorkspace ReconnectEnum

	// Specifies whether users can switch the running mode of their WorkSpace.
	SwitchRunningMode ReconnectEnum

	noSmithyDocumentSerde
}

// Describes a snapshot.
type Snapshot struct {

	// The time when the snapshot was created.
	SnapshotTime *time.Time

	noSmithyDocumentSerde
}

// Describes a standby WorkSpace.
type StandbyWorkspace struct {

	// The identifier of the directory for the standby WorkSpace.
	//
	// This member is required.
	DirectoryId *string

	// The identifier of the standby WorkSpace.
	//
	// This member is required.
	PrimaryWorkspaceId *string

	// Indicates whether data replication is enabled, and if enabled, the type of data
	// replication.
	DataReplication DataReplication

	// The tags associated with the standby WorkSpace.
	Tags []Tag

	// The volume encryption key of the standby WorkSpace.
	VolumeEncryptionKey *string

	noSmithyDocumentSerde
}

// Describes the properties of the related standby WorkSpaces.
type StandbyWorkspacesProperties struct {

	// Indicates whether data replication is enabled, and if enabled, the type of data
	// replication.
	DataReplication DataReplication

	// The date and time at which the last successful snapshot was taken of the
	// primary WorkSpace used for replicating data.
	RecoverySnapshotTime *time.Time

	// The identifier of the standby WorkSpace
	StandbyWorkspaceId *string

	noSmithyDocumentSerde
}

// Information used to start a WorkSpace.
type StartRequest struct {

	// The identifier of the WorkSpace.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the information used to stop a WorkSpace.
type StopRequest struct {

	// The identifier of the WorkSpace.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the storage connector.
type StorageConnector struct {

	// The type of connector used to save user files.
	//
	// This member is required.
	ConnectorType StorageConnectorTypeEnum

	// Indicates if the storage connetor is enabled or disabled.
	//
	// This member is required.
	Status StorageConnectorStatusEnum

	noSmithyDocumentSerde
}

// Describes the streaming properties.
type StreamingProperties struct {

	// Indicates the Global Accelerator properties.
	GlobalAccelerator *GlobalAcceleratorForDirectory

	// Indicates the storage connector used
	StorageConnectors []StorageConnector

	// Indicates the type of preferred protocol for the streaming experience.
	StreamingExperiencePreferredProtocol StreamingExperiencePreferredProtocolEnum

	// Indicates the permission settings asscoiated with the user.
	UserSettings []UserSetting

	noSmithyDocumentSerde
}

// Describes a tag.
type Tag struct {

	// The key of the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag.
	Value *string

	noSmithyDocumentSerde
}

// Describes the information used to terminate a WorkSpace.
type TerminateRequest struct {

	// The identifier of the WorkSpace.
	//
	// This member is required.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the timeout settings for a pool of WorkSpaces.
type TimeoutSettings struct {

	// Specifies the amount of time, in seconds, that a streaming session remains
	// active after users disconnect. If users try to reconnect to the streaming
	// session after a disconnection or network interruption within the time set, they
	// are connected to their previous session. Otherwise, they are connected to a new
	// session with a new streaming instance.
	DisconnectTimeoutInSeconds *int32

	// The amount of time in seconds a connection will stay active while idle.
	IdleDisconnectTimeoutInSeconds *int32

	// Specifies the maximum amount of time, in seconds, that a streaming session can
	// remain active. If users are still connected to a streaming instance five minutes
	// before this limit is reached, they are prompted to save any open documents
	// before being disconnected. After this time elapses, the instance is terminated
	// and replaced by a new instance.
	MaxUserDurationInSeconds *int32

	noSmithyDocumentSerde
}

// Describes whether a WorkSpace image needs to be updated with the latest drivers
// and other components required by Amazon WorkSpaces.
//
// Only Windows 10 WorkSpace images can be programmatically updated at this time.
type UpdateResult struct {

	// A description of whether updates for the WorkSpace image are pending or
	// available.
	Description *string

	// Indicates whether updated drivers or other components are available for the
	// specified WorkSpace image.
	UpdateAvailable *bool

	noSmithyDocumentSerde
}

// Information about the user's permission settings.
type UserSetting struct {

	// Indicates the type of action.
	//
	// This member is required.
	Action UserSettingActionEnum

	// Indicates if the setting is enabled or disabled.
	//
	// This member is required.
	Permission UserSettingPermissionEnum

	// Indicates the maximum character length for the specified user setting.
	MaximumLength *int32

	noSmithyDocumentSerde
}

// Describes the user volume for a WorkSpace bundle.
type UserStorage struct {

	// The size of the user volume.
	//
	// This member is required.
	Capacity *string

	noSmithyDocumentSerde
}

// Describes a WorkSpace.
type Workspace struct {

	// The identifier of the bundle used to create the WorkSpace.
	BundleId *string

	// The name of the WorkSpace, as seen by the operating system. The format of this
	// name varies. For more information, see [Launch a WorkSpace].
	//
	// [Launch a WorkSpace]: https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html
	ComputerName *string

	// Indicates the settings of the data replication.
	DataReplicationSettings *DataReplicationSettings

	// The identifier of the Directory Service directory for the WorkSpace.
	DirectoryId *string

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string

	// The IP address of the WorkSpace.
	IpAddress *string

	// The modification states of the WorkSpace.
	ModificationStates []ModificationState

	// The standby WorkSpace or primary WorkSpace related to the specified WorkSpace.
	RelatedWorkspaces []RelatedWorkspaceProperties

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool

	// The properties of the standby WorkSpace
	StandbyWorkspacesProperties []StandbyWorkspacesProperties

	// The operational state of the WorkSpace.
	//
	//   - PENDING – The WorkSpace is in a waiting state (for example, the WorkSpace is
	//   being created).
	//
	//   - AVAILABLE – The WorkSpace is running and has passed the health checks.
	//
	//   - IMPAIRED – Refer to UNHEALTHY state.
	//
	//   - UNHEALTHY – The WorkSpace is not responding to health checks.
	//
	//   - REBOOTING – The WorkSpace is being rebooted (restarted).
	//
	//   - STARTING – The WorkSpace is starting up and health checks are being run.
	//
	//   - REBUILDING – The WorkSpace is being rebuilt.
	//
	//   - RESTORING – The WorkSpace is being restored.
	//
	//   - MAINTENANCE – The WorkSpace is undergoing scheduled maintenance by Amazon
	//   Web Services.
	//
	//   - ADMIN_MAINTENANCE – The WorkSpace is undergoing maintenance by the
	//   WorkSpaces administrator.
	//
	//   - TERMINATING – The WorkSpace is being deleted.
	//
	//   - TERMINATED – The WorkSpace has been deleted.
	//
	//   - SUSPENDED – The WorkSpace has been suspended for image creation.
	//
	//   - UPDATING – The WorkSpace is undergoing an update.
	//
	//   - STOPPING – The WorkSpace is being stopped.
	//
	//   - STOPPED – The WorkSpace has been stopped.
	//
	//   - ERROR – The WorkSpace is an error state (for example, an error occurred
	//   during startup).
	//
	// After a WorkSpace is terminated, the TERMINATED state is returned only briefly
	// before the WorkSpace directory metadata is cleaned up, so this state is rarely
	// returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID
	// by using [DescribeWorkSpaces]. If the WorkSpace ID isn't returned, then the WorkSpace has been
	// successfully terminated.
	//
	// [DescribeWorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html
	State WorkspaceState

	// The identifier of the subnet for the WorkSpace.
	SubnetId *string

	// The user for the WorkSpace.
	UserName *string

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool

	// The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace.
	// Amazon WorkSpaces does not support asymmetric KMS keys.
	VolumeEncryptionKey *string

	// The identifier of the WorkSpace.
	WorkspaceId *string

	// The name of the user-decoupled WorkSpace.
	WorkspaceName *string

	// The properties of the WorkSpace.
	WorkspaceProperties *WorkspaceProperties

	noSmithyDocumentSerde
}

// The device types and operating systems that can be used to access a WorkSpace.
// For more information, see [Amazon WorkSpaces Client Network Requirements].
//
// [Amazon WorkSpaces Client Network Requirements]: https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-network-requirements.html
type WorkspaceAccessProperties struct {

	// Specifies the configuration for accessing the WorkSpace.
	AccessEndpointConfig *AccessEndpointConfig

	// Indicates whether users can use Android and Android-compatible Chrome OS
	// devices to access their WorkSpaces.
	DeviceTypeAndroid AccessPropertyValue

	// Indicates whether users can use Chromebooks to access their WorkSpaces.
	DeviceTypeChromeOs AccessPropertyValue

	// Indicates whether users can use iOS devices to access their WorkSpaces.
	DeviceTypeIos AccessPropertyValue

	// Indicates whether users can use Linux clients to access their WorkSpaces.
	DeviceTypeLinux AccessPropertyValue

	// Indicates whether users can use macOS clients to access their WorkSpaces.
	DeviceTypeOsx AccessPropertyValue

	// Indicates whether users can access their WorkSpaces through a web browser.
	DeviceTypeWeb AccessPropertyValue

	// Indicates whether users can use Windows clients to access their WorkSpaces.
	DeviceTypeWindows AccessPropertyValue

	// Indicates whether users can access their WorkSpaces through a WorkSpaces Thin
	// Client.
	DeviceTypeWorkSpacesThinClient AccessPropertyValue

	// Indicates whether users can use zero client devices to access their WorkSpaces.
	DeviceTypeZeroClient AccessPropertyValue

	noSmithyDocumentSerde
}

// Describes the WorkSpace application.
type WorkSpaceApplication struct {

	// The identifier of the application.
	ApplicationId *string

	// The time the application is created.
	Created *time.Time

	// The description of the WorkSpace application.
	Description *string

	// The license availability for the applications.
	LicenseType WorkSpaceApplicationLicenseType

	// The name of the WorkSpace application.
	Name *string

	// The owner of the WorkSpace application.
	Owner *string

	// The status of WorkSpace application.
	State WorkSpaceApplicationState

	// The supported compute types of the WorkSpace application.
	SupportedComputeTypeNames []Compute

	// The supported operating systems of the WorkSpace application.
	SupportedOperatingSystemNames []OperatingSystemName

	noSmithyDocumentSerde
}

// Describes the WorkSpace application deployment.
type WorkSpaceApplicationDeployment struct {

	// The associations between the applications and the associated resources.
	Associations []WorkspaceResourceAssociation

	noSmithyDocumentSerde
}

// Describes a WorkSpace bundle.
type WorkspaceBundle struct {

	// The identifier of the bundle.
	BundleId *string

	// The type of WorkSpace bundle.
	BundleType BundleType

	// The compute type of the bundle. For more information, see [Amazon WorkSpaces Bundles].
	//
	// [Amazon WorkSpaces Bundles]: http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles
	ComputeType *ComputeType

	// The time when the bundle was created.
	CreationTime *time.Time

	// The description of the bundle.
	Description *string

	// The identifier of the image that was used to create the bundle.
	ImageId *string

	// The last time that the bundle was updated.
	LastUpdatedTime *time.Time

	// The name of the bundle.
	Name *string

	// The owner of the bundle. This is the account identifier of the owner, or AMAZON
	// if the bundle is provided by Amazon Web Services.
	Owner *string

	// The size of the root volume.
	RootStorage *RootStorage

	// The state of the WorkSpace bundle.
	State WorkspaceBundleState

	// The size of the user volume.
	UserStorage *UserStorage

	noSmithyDocumentSerde
}

// Describes the connection status of a WorkSpace.
type WorkspaceConnectionStatus struct {

	// The connection state of the WorkSpace. The connection state is unknown if the
	// WorkSpace is stopped.
	ConnectionState ConnectionState

	// The timestamp of the connection status check.
	ConnectionStateCheckTimestamp *time.Time

	// The timestamp of the last known user connection.
	LastKnownUserConnectionTimestamp *time.Time

	// The identifier of the WorkSpace.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes the default properties that are used for creating WorkSpaces. For
// more information, see [Update Directory Details for Your WorkSpaces].
//
// [Update Directory Details for Your WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html
type WorkspaceCreationProperties struct {

	// The identifier of your custom security group.
	CustomSecurityGroupId *string

	// The default organizational unit (OU) for your WorkSpaces directories. This
	// string must be the full Lightweight Directory Access Protocol (LDAP)
	// distinguished name for the target domain and OU. It must be in the form
	// "OU=value,DC=value,DC=value" , where value is any string of characters, and the
	// number of domain components (DCs) is two or more. For example,
	// OU=WorkSpaces_machines,DC=machines,DC=example,DC=com .
	//
	//   - To avoid errors, certain characters in the distinguished name must be
	//   escaped. For more information, see [Distinguished Names]in the Microsoft documentation.
	//
	//   - The API doesn't validate whether the OU exists.
	//
	// [Distinguished Names]: https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names
	DefaultOu *string

	// Indicates whether internet access is enabled for your WorkSpaces.
	EnableInternetAccess *bool

	// Indicates whether maintenance mode is enabled for your WorkSpaces. For more
	// information, see [WorkSpace Maintenance].
	//
	// [WorkSpace Maintenance]: https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html
	EnableMaintenanceMode *bool

	// Indicates the IAM role ARN of the instance.
	InstanceIamRoleArn *string

	// Indicates whether users are local administrators of their WorkSpaces.
	UserEnabledAsLocalAdministrator *bool

	noSmithyDocumentSerde
}

// Describes a directory that is used with Amazon WorkSpaces.
type WorkspaceDirectory struct {

	// Information about the Active Directory config.
	ActiveDirectoryConfig *ActiveDirectoryConfig

	// The directory alias.
	Alias *string

	// The certificate-based authentication properties used to authenticate SAML 2.0
	// Identity Provider (IdP) user identities to Active Directory for WorkSpaces
	// login.
	CertificateBasedAuthProperties *CertificateBasedAuthProperties

	// The user name for the service account.
	CustomerUserName *string

	// The directory identifier.
	DirectoryId *string

	// The name of the directory.
	DirectoryName *string

	// The directory type.
	DirectoryType WorkspaceDirectoryType

	// The IP addresses of the DNS servers for the directory.
	DnsIpAddresses []string

	// Endpoint encryption mode that allows you to configure the specified directory
	// between Standard TLS and FIPS 140-2 validated mode.
	EndpointEncryptionMode EndpointEncryptionMode

	// The error message returned.
	ErrorMessage *string

	// Specifies details about identity center configurations.
	IDCConfig *IDCConfig

	// The identifier of the IAM role. This is the role that allows Amazon WorkSpaces
	// to make calls to other services, such as Amazon EC2, on your behalf.
	IamRoleId *string

	// The identifiers of the IP access control groups associated with the directory.
	IpGroupIds []string

	// Specifies details about Microsoft Entra configurations.
	MicrosoftEntraConfig *MicrosoftEntraConfig

	// The registration code for the directory. This is the code that users enter in
	// their Amazon WorkSpaces client application to connect to the directory.
	RegistrationCode *string

	// Describes the enablement status, user access URL, and relay state parameter
	// name that are used for configuring federation with an SAML 2.0 identity
	// provider.
	SamlProperties *SamlProperties

	// The default self-service permissions for WorkSpaces in the directory.
	SelfservicePermissions *SelfservicePermissions

	// The state of the directory's registration with Amazon WorkSpaces. After a
	// directory is deregistered, the DEREGISTERED state is returned very briefly
	// before the directory metadata is cleaned up, so this state is rarely returned.
	// To confirm that a directory is deregistered, check for the directory ID by using
	// [DescribeWorkspaceDirectories]. If the directory ID isn't returned, then the directory has been successfully
	// deregistered.
	//
	// [DescribeWorkspaceDirectories]: https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html
	State WorkspaceDirectoryState

	// The streaming properties to configure.
	StreamingProperties *StreamingProperties

	// The identifiers of the subnets used with the directory.
	SubnetIds []string

	// Specifies whether the directory is dedicated or shared. To use Bring Your Own
	// License (BYOL), this value must be set to DEDICATED . For more information, see [Bring Your Own Windows Desktop Images]
	// .
	//
	// [Bring Your Own Windows Desktop Images]: https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html
	Tenancy Tenancy

	// Indicates the identity type of the specifired user.
	UserIdentityType UserIdentityType

	// The devices and operating systems that users can use to access WorkSpaces.
	WorkspaceAccessProperties *WorkspaceAccessProperties

	// The default creation properties for all WorkSpaces in the directory.
	WorkspaceCreationProperties *DefaultWorkspaceCreationProperties

	// The description of the WorkSpace directory
	WorkspaceDirectoryDescription *string

	// The name fo the WorkSpace directory.
	WorkspaceDirectoryName *string

	// The identifier of the security group that is assigned to new WorkSpaces.
	WorkspaceSecurityGroupId *string

	// Indicates whether the directory's WorkSpace type is personal or pools.
	WorkspaceType WorkspaceType

	noSmithyDocumentSerde
}

// Describes a WorkSpace image.
type WorkspaceImage struct {

	// The date when the image was created. If the image has been shared, the Amazon
	// Web Services account that the image has been shared with sees the original
	// creation date of the image.
	Created *time.Time

	// The description of the image.
	Description *string

	// The error code that is returned for the image.
	ErrorCode *string

	// Additional details of the error returned for the image, including the possible
	// causes of the errors and troubleshooting information.
	ErrorDetails []ErrorDetails

	// The text of the error message that is returned for the image.
	ErrorMessage *string

	// The identifier of the image.
	ImageId *string

	// The name of the image.
	Name *string

	// The operating system that the image is running.
	OperatingSystem *OperatingSystem

	// The identifier of the Amazon Web Services account that owns the image.
	OwnerAccountId *string

	// Specifies whether the image is running on dedicated hardware. When Bring Your
	// Own License (BYOL) is enabled, this value is set to DEDICATED . For more
	// information, see [Bring Your Own Windows Desktop Images].
	//
	// [Bring Your Own Windows Desktop Images]: https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html
	RequiredTenancy WorkspaceImageRequiredTenancy

	// The status of the image.
	State WorkspaceImageState

	// The updates (if any) that are available for the specified image.
	Updates *UpdateResult

	noSmithyDocumentSerde
}

// Describes a WorkSpace.
type WorkspaceProperties struct {

	// The compute type. For more information, see [Amazon WorkSpaces Bundles].
	//
	// [Amazon WorkSpaces Bundles]: http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles
	ComputeTypeName Compute

	// Indicates the Global Accelerator properties.
	GlobalAccelerator *GlobalAcceleratorForWorkSpace

	// The name of the operating system.
	OperatingSystemName OperatingSystemName

	// The protocol. For more information, see [Protocols for Amazon WorkSpaces].
	//
	//   - Only available for WorkSpaces created with PCoIP bundles.
	//
	//   - The Protocols property is case sensitive. Ensure you use PCOIP or DCV
	//   (formerly WSP).
	//
	//   - Unavailable for Windows 7 WorkSpaces and WorkSpaces using GPU-based bundles
	//   (Graphics, GraphicsPro, Graphics.g4dn, and GraphicsPro.g4dn).
	//
	// [Protocols for Amazon WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-protocols.html
	Protocols []Protocol

	// The size of the root volume. For important information about how to modify the
	// size of the root and user volumes, see [Modify a WorkSpace].
	//
	// [Modify a WorkSpace]: https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html
	RootVolumeSizeGib *int32

	// The running mode. For more information, see [Manage the WorkSpace Running Mode].
	//
	// The MANUAL value is only supported by Amazon WorkSpaces Core. Contact your
	// account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core].
	//
	// Review your running mode to ensure you are using one that is optimal for your
	// needs and budget. For more information on switching running modes, see [Can I switch between hourly and monthly billing?]
	//
	// [Manage the WorkSpace Running Mode]: https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html
	// [Can I switch between hourly and monthly billing?]: http://aws.amazon.com/workspaces-family/workspaces/faqs/#:~:text=Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%20on%20WorkSpaces%20Personal%3F
	// [Amazon WorkSpaces Core]: http://aws.amazon.com/workspaces/core/
	RunningMode RunningMode

	// The time after a user logs off when WorkSpaces are automatically stopped.
	// Configured in 60-minute intervals.
	RunningModeAutoStopTimeoutInMinutes *int32

	// The size of the user storage. For important information about how to modify the
	// size of the root and user volumes, see [Modify a WorkSpace].
	//
	// [Modify a WorkSpace]: https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html
	UserVolumeSizeGib *int32

	noSmithyDocumentSerde
}

// Describes the information used to create a WorkSpace.
type WorkspaceRequest struct {

	// The identifier of the bundle for the WorkSpace. You can use DescribeWorkspaceBundles to list the
	// available bundles.
	//
	// This member is required.
	BundleId *string

	// The identifier of the Directory Service directory for the WorkSpace. You can
	// use DescribeWorkspaceDirectoriesto list the available directories.
	//
	// This member is required.
	DirectoryId *string

	// The user name of the user for the WorkSpace. This user name must exist in the
	// Directory Service directory for the WorkSpace.
	//
	// The username is not case-sensitive, but we recommend matching the case in the
	// Directory Service directory to avoid potential incompatibilities.
	//
	// The reserved keyword, [UNDEFINED] , is used when creating user-decoupled
	// WorkSpaces.
	//
	// This member is required.
	UserName *string

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool

	// The tags for the WorkSpace.
	Tags []Tag

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool

	// The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace.
	// Amazon WorkSpaces does not support asymmetric KMS keys.
	VolumeEncryptionKey *string

	// The name of the user-decoupled WorkSpace.
	//
	// WorkspaceName is required if UserName is [UNDEFINED] for user-decoupled
	// WorkSpaces. WorkspaceName is not applicable if UserName is specified for
	// user-assigned WorkSpaces.
	WorkspaceName *string

	// The WorkSpace properties.
	WorkspaceProperties *WorkspaceProperties

	noSmithyDocumentSerde
}

// Describes the association between an application and a WorkSpace resource.
type WorkspaceResourceAssociation struct {

	// The identifier of the associated resource.
	AssociatedResourceId *string

	// The resource types of the associated resource.
	AssociatedResourceType WorkSpaceAssociatedResourceType

	// The time the association is created.
	Created *time.Time

	// The time the association status was last updated.
	LastUpdatedTime *time.Time

	// The status of the WorkSpace resource association.
	State AssociationState

	// The reason the association deployment failed.
	StateReason *AssociationStateReason

	// The identifier of the WorkSpace.
	WorkspaceId *string

	noSmithyDocumentSerde
}

// Describes an IP access control group.
type WorkspacesIpGroup struct {

	// The description of the group.
	GroupDesc *string

	// The identifier of the group.
	GroupId *string

	// The name of the group.
	GroupName *string

	// The rules.
	UserRules []IpRuleItem

	noSmithyDocumentSerde
}

// Describes a pool of WorkSpaces.
type WorkspacesPool struct {

	// The identifier of the bundle used by the pool.
	//
	// This member is required.
	BundleId *string

	// The capacity status for the pool
	//
	// This member is required.
	CapacityStatus *CapacityStatus

	// The time the pool was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The identifier of the directory used by the pool.
	//
	// This member is required.
	DirectoryId *string

	// The Amazon Resource Name (ARN) for the pool.
	//
	// This member is required.
	PoolArn *string

	// The identifier of a pool.
	//
	// This member is required.
	PoolId *string

	// The name of the pool.
	//
	// This member is required.
	PoolName *string

	// The running mode of the pool.
	//
	// This member is required.
	RunningMode PoolsRunningMode

	// The current state of the pool.
	//
	// This member is required.
	State WorkspacesPoolState

	// The persistent application settings for users of the pool.
	ApplicationSettings *ApplicationSettingsResponse

	// The description of the pool.
	Description *string

	// The pool errors.
	Errors []WorkspacesPoolError

	// The amount of time that a pool session remains active after users disconnect.
	// If they try to reconnect to the pool session after a disconnection or network
	// interruption within this time interval, they are connected to their previous
	// session. Otherwise, they are connected to a new session with a new pool
	// instance.
	TimeoutSettings *TimeoutSettings

	noSmithyDocumentSerde
}

// Describes a pool error.
type WorkspacesPoolError struct {

	// The error code.
	ErrorCode WorkspacesPoolErrorCode

	// The error message.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Describes a pool session.
type WorkspacesPoolSession struct {

	// The identifier of the pool.
	//
	// This member is required.
	PoolId *string

	// The identifier of the session.
	//
	// This member is required.
	SessionId *string

	// The identifier of the user.
	//
	// This member is required.
	UserId *string

	// The authentication method. The user is authenticated using a WorkSpaces Pools
	// URL (API) or SAML 2.0 federation (SAML).
	AuthenticationType AuthenticationType

	// Specifies whether a user is connected to the pool session.
	ConnectionState SessionConnectionState

	// The time that the pool session ended.
	ExpirationTime *time.Time

	// The identifier for the instance hosting the session.
	InstanceId *string

	// Describes the network details of the pool.
	NetworkAccessConfiguration *NetworkAccessConfiguration

	// The time that the pool sission started.
	StartTime *time.Time

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isImageSourceIdentifier() {}
