// Code generated by smithy-go-codegen DO NOT EDIT.

package georoutes

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/georoutes/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCalculateIsolines struct {
}

func (*validateOpCalculateIsolines) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCalculateIsolines) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CalculateIsolinesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCalculateIsolinesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCalculateRouteMatrix struct {
}

func (*validateOpCalculateRouteMatrix) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCalculateRouteMatrix) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CalculateRouteMatrixInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCalculateRouteMatrixInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCalculateRoutes struct {
}

func (*validateOpCalculateRoutes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCalculateRoutes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CalculateRoutesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCalculateRoutesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpOptimizeWaypoints struct {
}

func (*validateOpOptimizeWaypoints) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpOptimizeWaypoints) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*OptimizeWaypointsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpOptimizeWaypointsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSnapToRoads struct {
}

func (*validateOpSnapToRoads) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSnapToRoads) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SnapToRoadsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSnapToRoadsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCalculateIsolinesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCalculateIsolines{}, middleware.After)
}

func addOpCalculateRouteMatrixValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCalculateRouteMatrix{}, middleware.After)
}

func addOpCalculateRoutesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCalculateRoutes{}, middleware.After)
}

func addOpOptimizeWaypointsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpOptimizeWaypoints{}, middleware.After)
}

func addOpSnapToRoadsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSnapToRoads{}, middleware.After)
}

func validateCircle(v *types.Circle) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Circle"}
	if v.Center == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Center"))
	}
	if v.Radius == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Radius"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCorridor(v *types.Corridor) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Corridor"}
	if v.LineString == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LineString"))
	}
	if v.Radius == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Radius"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsolineAvoidanceArea(v *types.IsolineAvoidanceArea) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsolineAvoidanceArea"}
	if v.Except != nil {
		if err := validateIsolineAvoidanceAreaGeometryList(v.Except); err != nil {
			invalidParams.AddNested("Except", err.(smithy.InvalidParamsError))
		}
	}
	if v.Geometry == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Geometry"))
	} else if v.Geometry != nil {
		if err := validateIsolineAvoidanceAreaGeometry(v.Geometry); err != nil {
			invalidParams.AddNested("Geometry", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsolineAvoidanceAreaGeometry(v *types.IsolineAvoidanceAreaGeometry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsolineAvoidanceAreaGeometry"}
	if v.Corridor != nil {
		if err := validateCorridor(v.Corridor); err != nil {
			invalidParams.AddNested("Corridor", err.(smithy.InvalidParamsError))
		}
	}
	if v.PolylineCorridor != nil {
		if err := validatePolylineCorridor(v.PolylineCorridor); err != nil {
			invalidParams.AddNested("PolylineCorridor", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsolineAvoidanceAreaGeometryList(v []types.IsolineAvoidanceAreaGeometry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsolineAvoidanceAreaGeometryList"}
	for i := range v {
		if err := validateIsolineAvoidanceAreaGeometry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsolineAvoidanceAreaList(v []types.IsolineAvoidanceArea) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsolineAvoidanceAreaList"}
	for i := range v {
		if err := validateIsolineAvoidanceArea(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsolineAvoidanceOptions(v *types.IsolineAvoidanceOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsolineAvoidanceOptions"}
	if v.Areas != nil {
		if err := validateIsolineAvoidanceAreaList(v.Areas); err != nil {
			invalidParams.AddNested("Areas", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsolineDestinationOptions(v *types.IsolineDestinationOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsolineDestinationOptions"}
	if v.SideOfStreet != nil {
		if err := validateIsolineSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsolineOriginOptions(v *types.IsolineOriginOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsolineOriginOptions"}
	if v.SideOfStreet != nil {
		if err := validateIsolineSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsolineSideOfStreetOptions(v *types.IsolineSideOfStreetOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsolineSideOfStreetOptions"}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePolylineCorridor(v *types.PolylineCorridor) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PolylineCorridor"}
	if v.Polyline == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Polyline"))
	}
	if v.Radius == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Radius"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRoadSnapTracePoint(v *types.RoadSnapTracePoint) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RoadSnapTracePoint"}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRoadSnapTracePointList(v []types.RoadSnapTracePoint) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RoadSnapTracePointList"}
	for i := range v {
		if err := validateRoadSnapTracePoint(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteAvoidanceArea(v *types.RouteAvoidanceArea) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteAvoidanceArea"}
	if v.Except != nil {
		if err := validateRouteAvoidanceAreaGeometryList(v.Except); err != nil {
			invalidParams.AddNested("Except", err.(smithy.InvalidParamsError))
		}
	}
	if v.Geometry == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Geometry"))
	} else if v.Geometry != nil {
		if err := validateRouteAvoidanceAreaGeometry(v.Geometry); err != nil {
			invalidParams.AddNested("Geometry", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteAvoidanceAreaGeometry(v *types.RouteAvoidanceAreaGeometry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteAvoidanceAreaGeometry"}
	if v.Corridor != nil {
		if err := validateCorridor(v.Corridor); err != nil {
			invalidParams.AddNested("Corridor", err.(smithy.InvalidParamsError))
		}
	}
	if v.PolylineCorridor != nil {
		if err := validatePolylineCorridor(v.PolylineCorridor); err != nil {
			invalidParams.AddNested("PolylineCorridor", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteAvoidanceAreaGeometryList(v []types.RouteAvoidanceAreaGeometry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteAvoidanceAreaGeometryList"}
	for i := range v {
		if err := validateRouteAvoidanceAreaGeometry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteAvoidanceAreaList(v []types.RouteAvoidanceArea) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteAvoidanceAreaList"}
	for i := range v {
		if err := validateRouteAvoidanceArea(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteAvoidanceOptions(v *types.RouteAvoidanceOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteAvoidanceOptions"}
	if v.Areas != nil {
		if err := validateRouteAvoidanceAreaList(v.Areas); err != nil {
			invalidParams.AddNested("Areas", err.(smithy.InvalidParamsError))
		}
	}
	if v.ZoneCategories != nil {
		if err := validateRouteAvoidanceZoneCategoryList(v.ZoneCategories); err != nil {
			invalidParams.AddNested("ZoneCategories", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteAvoidanceZoneCategory(v *types.RouteAvoidanceZoneCategory) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteAvoidanceZoneCategory"}
	if len(v.Category) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Category"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteAvoidanceZoneCategoryList(v []types.RouteAvoidanceZoneCategory) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteAvoidanceZoneCategoryList"}
	for i := range v {
		if err := validateRouteAvoidanceZoneCategory(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteDestinationOptions(v *types.RouteDestinationOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteDestinationOptions"}
	if v.SideOfStreet != nil {
		if err := validateRouteSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteDriverOptions(v *types.RouteDriverOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteDriverOptions"}
	if v.Schedule != nil {
		if err := validateRouteDriverScheduleIntervalList(v.Schedule); err != nil {
			invalidParams.AddNested("Schedule", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteDriverScheduleInterval(v *types.RouteDriverScheduleInterval) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteDriverScheduleInterval"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteDriverScheduleIntervalList(v []types.RouteDriverScheduleInterval) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteDriverScheduleIntervalList"}
	for i := range v {
		if err := validateRouteDriverScheduleInterval(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteEmissionType(v *types.RouteEmissionType) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteEmissionType"}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteExclusionOptions(v *types.RouteExclusionOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteExclusionOptions"}
	if v.Countries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Countries"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixAvoidanceArea(v *types.RouteMatrixAvoidanceArea) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixAvoidanceArea"}
	if v.Geometry == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Geometry"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixAvoidanceAreaList(v []types.RouteMatrixAvoidanceArea) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixAvoidanceAreaList"}
	for i := range v {
		if err := validateRouteMatrixAvoidanceArea(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixAvoidanceOptions(v *types.RouteMatrixAvoidanceOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixAvoidanceOptions"}
	if v.Areas != nil {
		if err := validateRouteMatrixAvoidanceAreaList(v.Areas); err != nil {
			invalidParams.AddNested("Areas", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixBoundary(v *types.RouteMatrixBoundary) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixBoundary"}
	if v.Geometry != nil {
		if err := validateRouteMatrixBoundaryGeometry(v.Geometry); err != nil {
			invalidParams.AddNested("Geometry", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixBoundaryGeometry(v *types.RouteMatrixBoundaryGeometry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixBoundaryGeometry"}
	if v.Circle != nil {
		if err := validateCircle(v.Circle); err != nil {
			invalidParams.AddNested("Circle", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixDestination(v *types.RouteMatrixDestination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixDestination"}
	if v.Options != nil {
		if err := validateRouteMatrixDestinationOptions(v.Options); err != nil {
			invalidParams.AddNested("Options", err.(smithy.InvalidParamsError))
		}
	}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixDestinationList(v []types.RouteMatrixDestination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixDestinationList"}
	for i := range v {
		if err := validateRouteMatrixDestination(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixDestinationOptions(v *types.RouteMatrixDestinationOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixDestinationOptions"}
	if v.SideOfStreet != nil {
		if err := validateRouteMatrixSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixExclusionOptions(v *types.RouteMatrixExclusionOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixExclusionOptions"}
	if v.Countries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Countries"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixOrigin(v *types.RouteMatrixOrigin) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixOrigin"}
	if v.Options != nil {
		if err := validateRouteMatrixOriginOptions(v.Options); err != nil {
			invalidParams.AddNested("Options", err.(smithy.InvalidParamsError))
		}
	}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixOriginList(v []types.RouteMatrixOrigin) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixOriginList"}
	for i := range v {
		if err := validateRouteMatrixOrigin(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixOriginOptions(v *types.RouteMatrixOriginOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixOriginOptions"}
	if v.SideOfStreet != nil {
		if err := validateRouteMatrixSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteMatrixSideOfStreetOptions(v *types.RouteMatrixSideOfStreetOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteMatrixSideOfStreetOptions"}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteOriginOptions(v *types.RouteOriginOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteOriginOptions"}
	if v.SideOfStreet != nil {
		if err := validateRouteSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteSideOfStreetOptions(v *types.RouteSideOfStreetOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteSideOfStreetOptions"}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteTollOptions(v *types.RouteTollOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteTollOptions"}
	if v.EmissionType != nil {
		if err := validateRouteEmissionType(v.EmissionType); err != nil {
			invalidParams.AddNested("EmissionType", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteWaypoint(v *types.RouteWaypoint) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteWaypoint"}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if v.SideOfStreet != nil {
		if err := validateRouteSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteWaypointList(v []types.RouteWaypoint) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteWaypointList"}
	for i := range v {
		if err := validateRouteWaypoint(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationAccessHours(v *types.WaypointOptimizationAccessHours) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationAccessHours"}
	if v.From == nil {
		invalidParams.Add(smithy.NewErrParamRequired("From"))
	} else if v.From != nil {
		if err := validateWaypointOptimizationAccessHoursEntry(v.From); err != nil {
			invalidParams.AddNested("From", err.(smithy.InvalidParamsError))
		}
	}
	if v.To == nil {
		invalidParams.Add(smithy.NewErrParamRequired("To"))
	} else if v.To != nil {
		if err := validateWaypointOptimizationAccessHoursEntry(v.To); err != nil {
			invalidParams.AddNested("To", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationAccessHoursEntry(v *types.WaypointOptimizationAccessHoursEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationAccessHoursEntry"}
	if len(v.DayOfWeek) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DayOfWeek"))
	}
	if v.TimeOfDay == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeOfDay"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationAvoidanceArea(v *types.WaypointOptimizationAvoidanceArea) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationAvoidanceArea"}
	if v.Geometry == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Geometry"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationAvoidanceAreaList(v []types.WaypointOptimizationAvoidanceArea) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationAvoidanceAreaList"}
	for i := range v {
		if err := validateWaypointOptimizationAvoidanceArea(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationAvoidanceOptions(v *types.WaypointOptimizationAvoidanceOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationAvoidanceOptions"}
	if v.Areas != nil {
		if err := validateWaypointOptimizationAvoidanceAreaList(v.Areas); err != nil {
			invalidParams.AddNested("Areas", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationClusteringOptions(v *types.WaypointOptimizationClusteringOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationClusteringOptions"}
	if len(v.Algorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Algorithm"))
	}
	if v.DrivingDistanceOptions != nil {
		if err := validateWaypointOptimizationDrivingDistanceOptions(v.DrivingDistanceOptions); err != nil {
			invalidParams.AddNested("DrivingDistanceOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationDestinationOptions(v *types.WaypointOptimizationDestinationOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationDestinationOptions"}
	if v.AccessHours != nil {
		if err := validateWaypointOptimizationAccessHours(v.AccessHours); err != nil {
			invalidParams.AddNested("AccessHours", err.(smithy.InvalidParamsError))
		}
	}
	if v.SideOfStreet != nil {
		if err := validateWaypointOptimizationSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationDriverOptions(v *types.WaypointOptimizationDriverOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationDriverOptions"}
	if v.RestCycles != nil {
		if err := validateWaypointOptimizationRestCycles(v.RestCycles); err != nil {
			invalidParams.AddNested("RestCycles", err.(smithy.InvalidParamsError))
		}
	}
	if v.RestProfile != nil {
		if err := validateWaypointOptimizationRestProfile(v.RestProfile); err != nil {
			invalidParams.AddNested("RestProfile", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationDrivingDistanceOptions(v *types.WaypointOptimizationDrivingDistanceOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationDrivingDistanceOptions"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationExclusionOptions(v *types.WaypointOptimizationExclusionOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationExclusionOptions"}
	if v.Countries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Countries"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationRestCycleDurations(v *types.WaypointOptimizationRestCycleDurations) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationRestCycleDurations"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationRestCycles(v *types.WaypointOptimizationRestCycles) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationRestCycles"}
	if v.LongCycle == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LongCycle"))
	} else if v.LongCycle != nil {
		if err := validateWaypointOptimizationRestCycleDurations(v.LongCycle); err != nil {
			invalidParams.AddNested("LongCycle", err.(smithy.InvalidParamsError))
		}
	}
	if v.ShortCycle == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ShortCycle"))
	} else if v.ShortCycle != nil {
		if err := validateWaypointOptimizationRestCycleDurations(v.ShortCycle); err != nil {
			invalidParams.AddNested("ShortCycle", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationRestProfile(v *types.WaypointOptimizationRestProfile) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationRestProfile"}
	if v.Profile == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Profile"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationSideOfStreetOptions(v *types.WaypointOptimizationSideOfStreetOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationSideOfStreetOptions"}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationWaypoint(v *types.WaypointOptimizationWaypoint) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationWaypoint"}
	if v.AccessHours != nil {
		if err := validateWaypointOptimizationAccessHours(v.AccessHours); err != nil {
			invalidParams.AddNested("AccessHours", err.(smithy.InvalidParamsError))
		}
	}
	if v.Position == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Position"))
	}
	if v.SideOfStreet != nil {
		if err := validateWaypointOptimizationSideOfStreetOptions(v.SideOfStreet); err != nil {
			invalidParams.AddNested("SideOfStreet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWaypointOptimizationWaypointList(v []types.WaypointOptimizationWaypoint) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WaypointOptimizationWaypointList"}
	for i := range v {
		if err := validateWaypointOptimizationWaypoint(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCalculateIsolinesInput(v *CalculateIsolinesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CalculateIsolinesInput"}
	if v.Avoid != nil {
		if err := validateIsolineAvoidanceOptions(v.Avoid); err != nil {
			invalidParams.AddNested("Avoid", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationOptions != nil {
		if err := validateIsolineDestinationOptions(v.DestinationOptions); err != nil {
			invalidParams.AddNested("DestinationOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.OriginOptions != nil {
		if err := validateIsolineOriginOptions(v.OriginOptions); err != nil {
			invalidParams.AddNested("OriginOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.Thresholds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Thresholds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCalculateRouteMatrixInput(v *CalculateRouteMatrixInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CalculateRouteMatrixInput"}
	if v.Avoid != nil {
		if err := validateRouteMatrixAvoidanceOptions(v.Avoid); err != nil {
			invalidParams.AddNested("Avoid", err.(smithy.InvalidParamsError))
		}
	}
	if v.Destinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destinations"))
	} else if v.Destinations != nil {
		if err := validateRouteMatrixDestinationList(v.Destinations); err != nil {
			invalidParams.AddNested("Destinations", err.(smithy.InvalidParamsError))
		}
	}
	if v.Exclude != nil {
		if err := validateRouteMatrixExclusionOptions(v.Exclude); err != nil {
			invalidParams.AddNested("Exclude", err.(smithy.InvalidParamsError))
		}
	}
	if v.Origins == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Origins"))
	} else if v.Origins != nil {
		if err := validateRouteMatrixOriginList(v.Origins); err != nil {
			invalidParams.AddNested("Origins", err.(smithy.InvalidParamsError))
		}
	}
	if v.RoutingBoundary == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoutingBoundary"))
	} else if v.RoutingBoundary != nil {
		if err := validateRouteMatrixBoundary(v.RoutingBoundary); err != nil {
			invalidParams.AddNested("RoutingBoundary", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCalculateRoutesInput(v *CalculateRoutesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CalculateRoutesInput"}
	if v.Avoid != nil {
		if err := validateRouteAvoidanceOptions(v.Avoid); err != nil {
			invalidParams.AddNested("Avoid", err.(smithy.InvalidParamsError))
		}
	}
	if v.Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destination"))
	}
	if v.DestinationOptions != nil {
		if err := validateRouteDestinationOptions(v.DestinationOptions); err != nil {
			invalidParams.AddNested("DestinationOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.Driver != nil {
		if err := validateRouteDriverOptions(v.Driver); err != nil {
			invalidParams.AddNested("Driver", err.(smithy.InvalidParamsError))
		}
	}
	if v.Exclude != nil {
		if err := validateRouteExclusionOptions(v.Exclude); err != nil {
			invalidParams.AddNested("Exclude", err.(smithy.InvalidParamsError))
		}
	}
	if v.Origin == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Origin"))
	}
	if v.OriginOptions != nil {
		if err := validateRouteOriginOptions(v.OriginOptions); err != nil {
			invalidParams.AddNested("OriginOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tolls != nil {
		if err := validateRouteTollOptions(v.Tolls); err != nil {
			invalidParams.AddNested("Tolls", err.(smithy.InvalidParamsError))
		}
	}
	if v.Waypoints != nil {
		if err := validateRouteWaypointList(v.Waypoints); err != nil {
			invalidParams.AddNested("Waypoints", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpOptimizeWaypointsInput(v *OptimizeWaypointsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OptimizeWaypointsInput"}
	if v.Avoid != nil {
		if err := validateWaypointOptimizationAvoidanceOptions(v.Avoid); err != nil {
			invalidParams.AddNested("Avoid", err.(smithy.InvalidParamsError))
		}
	}
	if v.Clustering != nil {
		if err := validateWaypointOptimizationClusteringOptions(v.Clustering); err != nil {
			invalidParams.AddNested("Clustering", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationOptions != nil {
		if err := validateWaypointOptimizationDestinationOptions(v.DestinationOptions); err != nil {
			invalidParams.AddNested("DestinationOptions", err.(smithy.InvalidParamsError))
		}
	}
	if v.Driver != nil {
		if err := validateWaypointOptimizationDriverOptions(v.Driver); err != nil {
			invalidParams.AddNested("Driver", err.(smithy.InvalidParamsError))
		}
	}
	if v.Exclude != nil {
		if err := validateWaypointOptimizationExclusionOptions(v.Exclude); err != nil {
			invalidParams.AddNested("Exclude", err.(smithy.InvalidParamsError))
		}
	}
	if v.Origin == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Origin"))
	}
	if v.Waypoints != nil {
		if err := validateWaypointOptimizationWaypointList(v.Waypoints); err != nil {
			invalidParams.AddNested("Waypoints", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSnapToRoadsInput(v *SnapToRoadsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SnapToRoadsInput"}
	if v.TracePoints == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TracePoints"))
	} else if v.TracePoints != nil {
		if err := validateRoadSnapTracePointList(v.TracePoints); err != nil {
			invalidParams.AddNested("TracePoints", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
