// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An object with the permanent IAM role identity and the temporary session name.
type AssumedRoleUser struct {

	// The ARN of the IAM role that the temporary credentials authenticate to.
	//
	// This member is required.
	Arn *string

	// The session name of the temporary session requested to STS. The value is a
	// unique identifier that contains the role ID, a colon ( : ), and the role session
	// name of the role that is being assumed. The role ID is generated by IAM when the
	// role is created. The role session name part of the value follows this format:
	// eks-clustername-podname-random UUID
	//
	// This member is required.
	AssumeRoleId *string

	noSmithyDocumentSerde
}

// The Amazon Web Services Signature Version 4 type of temporary credentials.
type Credentials struct {

	// The access key ID that identifies the temporary security credentials.
	//
	// This member is required.
	AccessKeyId *string

	// The Unix epoch timestamp in seconds when the current credentials expire.
	//
	// This member is required.
	Expiration *time.Time

	// The secret access key that applications inside the pods use to sign requests.
	//
	// This member is required.
	SecretAccessKey *string

	// The token that applications inside the pods must pass to any service API to use
	// the temporary credentials.
	//
	// This member is required.
	SessionToken *string

	noSmithyDocumentSerde
}

// Amazon EKS Pod Identity associations provide the ability to manage credentials
// for your applications, similar to the way that Amazon EC2 instance profiles
// provide credentials to Amazon EC2 instances.
type PodIdentityAssociation struct {

	// The Amazon Resource Name (ARN) of the EKS Pod Identity association.
	//
	// This member is required.
	AssociationArn *string

	// The ID of the association.
	//
	// This member is required.
	AssociationId *string

	noSmithyDocumentSerde
}

// An object containing the name of the Kubernetes service account inside the
// cluster to associate the IAM credentials with.
type Subject struct {

	// The name of the Kubernetes namespace inside the cluster to create the
	// association in. The service account and the pods that use the service account
	// must be in this namespace.
	//
	// This member is required.
	Namespace *string

	// The name of the Kubernetes service account inside the cluster to associate the
	// IAM credentials with.
	//
	// This member is required.
	ServiceAccount *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
