# gir2pas

The [gir2pas][] utility is a program to convert the
GIR metadata format (= XML files) used by [GObject introspection][] into usable
Pascal source code, suitable for generating corresponding language bindings.

It was originaly named [gir2pascal] maintained as part of the Lazarus Code and Component Repository ([lazarus-ccr][],
[wiki article][wiki-ccr]), see `applications/gobject-introspection/`. Later it has
received some maintenance by [n1tehawk][] and finally was imported from his
repository into Lazarus source tree.

# License

This project builds upon the original Lazarus CCR version and is thus intended
to follow the same licensing principles. For the `gobject-introspection` folder
this seems to be [GPL v2](LICENSE.md), as referenced in a number of file headers.

# Usage
## Compilation
In order to compile `gir2pas` one needs to install FPC and make:
```
aptitude install fpc make
```
Then run default make target:
```
make
```

## Generation of bindings
First, the GIR files need to be installed:
```
aptitude install \
	libatk1.0-dev \
	libgtk-3-dev \
	libgdk-pixbuf-2.0-dev \
	gir1.2-glib-2.0-dev \
	libgirepository1.0-dev \
	libgtk-3-dev \
	libharfbuzz-dev \
	libpango1.0-dev \
	gir1.2-freedesktop-dev
```
Then run the program:
```
./gir2pas -P Laz -e Set -w \
          -M atk-2.52 \
          -M cairo-1.0 \
          -M gdk-3.22 \
          -M glib-2.66 \
          -M gio-2.66 \
          -M gmodule-2.66 \
          -M gobject-2.66 \
          -M gtk-3.24 \
          -M pango-1.16 \
          -M pangocairo-1.46 \
          -i Gtk-3.0 \
          -o ../lazarus/lcl/interfaces/gtk3/gtk3bindings/
```

[gir2pas]: https://gitlab.com/gtk4pas/tools/gir2pas
[gir2pascal]: https://wiki.freepascal.org/gir2pascal
[GObject introspection]: https://gi.readthedocs.io/
[lazarus-ccr]: https://sourceforge.net/projects/lazarus-ccr/
[wiki-ccr]: https://wiki.lazarus.freepascal.org/Lazarus-ccr_SourceForge_repository
[n1tehawk]: https://github.com/n1tehawk/gir2pascal
