/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#ifndef FORWORDS_H
#define FORWORDS_H

#include <QMainWindow>
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonArray>
#include <QJsonValue>
#include <QMenu>
#include <QActionGroup>
#include <QWebEngineView>
#include "dlgedit.h"
#include "dlgsettings.h"
#include "dlgtest1.h"
#include "dlgtest3.h"

namespace Ui {
class Forwords;
}

class Forwords : public QMainWindow
{
    Q_OBJECT

public:
    explicit Forwords(QWidget *parent = nullptr);
    ~Forwords();

private slots:
    void on_pbAddLanguage_clicked();
    void on_pbAddTopic_clicked();
    void on_pbEdit_clicked();
    void on_pbTest1_clicked();
    void on_pbTest2_clicked();
    void on_pbTest3_clicked();
    void on_pbSettings_clicked();
    void on_configChanged(QJsonObject obj);
    void on_saveFileClicked();
    void on_cbLanguage_currentTextChanged(const QString &arg1);
    void on_cbTopic_currentTextChanged(const QString &arg1);
    void on_TextToSpeech(QString text);
    void on_SpeechTest(QString text, QString engine, QString voice);
    void on_menuActionTriggered();
    void on_TtsEngineChanged(QString engine);
    void on_actionExitClicked();
    void on_actionHelpClicked();
    void on_actionAboutClicked();
    void on_tSpeakTimer_timeOut();

private:
    Ui::Forwords *ui;
    void            menuInit();
    bool            fOpenTopicFile(QString filename);
    bool            fSaveTopicFile(QString filename);
    void            fCheckTopicData();
    bool            fAddLanguageFolder();
    bool            fAddTopic();
    void            fSpeechInit();
    void            fStartSpeechTimer(QString str);
    void            fConfigInit();
    bool            fLoadConfig();
    void            fSetLanguages();
    void            fSetTopics(QString s);
    void            fSetConfig();
    void            fSaveConfig();
    void            fCheckOldVFiles();
    void            fConvertOld(QString filename, QString ext);
    void            fGetUiText();
    void            fSetUiLanguage(QString lang);

    QList<QStringList>  aTopicData; //Contain list of couples (0-foreign word, 1- native word)

    QString     vWorkingDir;
    QString     vHome;
    QString     vConfigDir;
    QFile*      vFileConfig;
    QJsonObject vConfig;
    dlgSettings *dSettings;
    dlgTest1    *dTest1;
    dlgTest3    *dTest3;
    dlgEdit     *dEdit;

    //tts
    tts         *oTTS;
    QTimer      tSpeakTimer;

    //window look&feel
    const QIcon *vIcon;

    //Menu variables
    QMenu       menuLanguages;
    QActionGroup    *menuActGrLang;
    QList<QAction*> menuActionlList;
    QWebEngineView vHtmlView;

    //internationalisation
    QStringList vLanguageFiles;
    QStringList lTranslationDirs;

    //Strings for translation
    QString     sSpeechEng;
    QString     sSpeechEngNotSet;
};

#endif // FORWORDS_H
