/*
 * AIDE (Advanced Intrusion Detection Environment)
 *
 * Copyright (C) 1999-2002, 2004-2005, 2013, 2016, 2020, 2022-2025 Rami Lehti,
 *               Pablo Virolainen, Richard van den Berg, Hannes von Haugwitz
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _DB_H_INCLUDED
#define _DB_H_INCLUDED

#include <stdbool.h>
#include <stdio.h>
#include "db_config.h"
#include "util.h"

typedef enum {
    DB_TYPE_IN,
    DB_TYPE_OUT,
    DB_TYPE_NEW,
} DB_TYPE;

typedef struct {
    db_line* line;
    bool limit;
} db_entry_t;

byte* base64tobyte(char*, int, size_t *);

db_line* db_char2line(char**, database*);

int db_init(database*, bool, bool);

db_entry_t db_readline(database*, bool);

int db_writespec(db_config*);

int db_writeline(db_line*,db_config*);

void db_close(void);

void free_db_line(db_line* dl);

#define DB_OLD            (1<<0)
#define DB_DISK           (1<<1)
#define DB_NEW            (1<<2)
#define NODE_ADDED        (1<<4)
#define NODE_REMOVED      (1<<5)
#define NODE_CHANGED      (1<<6)
#define NODE_FREE         (1<<7)

#define NODE_MOVED_OUT    (1<<11)
#define NODE_MOVED_IN     (1<<12)
#define NODE_ALLOW_NEW    (1<<13)
#define NODE_ALLOW_RM	  (1<<14)
#define NODE_CHECK_INODE           (1<<15)
#define NODE_HAS_SUB_RULES         (1<<16)

#define LOG_DB_FORMAT_LINE(log_level, format, ...) \
    log_msg(log_level, "%s:%li: " format , (db->url)->raw, db->lineno, __VA_ARGS__);

#endif
