// -*-c++-*-
/* $Id: agent.h,v 1.8 2001/01/13 19:46:09 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "arpc.h"
#include "sfsmisc.h"
#include "sfsagent.h"
#include "crypt.h"
#include "rxx.h"
#include "qhash.h"

class rxfilter {
  rrxx filter;
  rrxx exclude;
public:
  rxfilter () {}
  rxfilter (const str &f, const str &e);
  bool check (const str &n);
};

extern vec<sfsagent_certprog> certprogs;
extern vec<rxfilter> certfilters;
extern vec<sfsagent_revokeprog> revokeprogs;
extern vec<rxfilter> revokefilters;
extern bhash<sfs_hash> norevoke;

void runprog (const sfsagent_cmd &av, str target, cbs cb);
void sfslookup (str name, cbs cb, u_int certno = 0, str res = NULL);
void revcheck (str name, callback<void, const sfsagent_revoked_res *>::ref cb);

struct key {
  ptr<rabin_priv> k;
  sfs_time expire;
  str comment;
  list_entry<key> link;
};

struct sfsagent {
  str name;
  ref<axprt> x;
  ptr<aclnt> ac;
  ptr<asrv> as;
  ptr<asrv> cs;
  list_entry<sfsagent> link;

  sfsagent (int fd);
  sfsagent (ref<axprt> x);
  ~sfsagent ();

  void authinit (svccb *sbp);
  void agentdisp (svccb *sbp);
  void ctldisp (svccb *sbp);
  void dispatch (svccb *sbp);

  void setname (str name);
};

extern list<sfsagent, &sfsagent::link> agents;
extern list<key, &key::link> keys;
extern key *keynum (u_int n);

void agentmsg (u_int32_t proc, const void *arg = NULL);

/* agentrex.C */
typedef callback<void, ptr<sfsagent_rex_res> >::ref cb_rex;
void rex_connect (str path, cb_rex::ptr cb);
