/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * DnsNull.h
 *   Empty DNS driver. For use when debugging or when using a DNS that reads
 *   directly from the backend database.
 *
 * $Id: DnsNull.h,v 1.6 2001/01/01 20:14:20 rex Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre <remi@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef DNSNULL_H
#define DNSNULL_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "Dns.h"

/**
 * @class DnsNull
 * @brief Dns driver that does nothing (for debug and dns servers that use
 *        a backend db common with ddtd)
 */
class DnsNull : public Dns
{
  public:
    /// constructor
    DnsNull(Logger *log) { }

    /// destructor
    ~DnsNull() {}

    /// add a specific dns record
    void addDnsRecord(int id, const char *dname,  DnsRecordType type,
                      const char *data) { }

    /// remove every dns records
    void delDnsRecords(char *dname) { }

    /// remove a specific dns record
    void delDnsRecord(int id, const char *dname, DnsRecordType type,
                      const char *data) { }

    void updateDnsRecord(int id, const char *dname, DnsRecordType type,
                         const char *data) { }

  private:
    /// hidden default constructor
    DnsNull() { };


};

#endif // DNSNULL_H
