#include <string>
#include <vector>

// Interface for the configuration management. Every configuration reader and holder should implement this.

class DBHostConfig;
class DBBalancerConfig {

public:

  DBBalancerConfig() {}
  virtual ~DBBalancerConfig() {}

  // Definition of virtual methods from the interface.

  // Data about the daemon supporting the service.
  virtual unsigned int getDaemonReaderPort() = 0;
  virtual unsigned int getDaemonWriterPort() = 0;
  virtual string getDaemonHost() = 0;
  virtual bool getWriterTransactionPerRequest() = 0;

  virtual unsigned int getDaemonInitThreads() = 0;
  virtual unsigned int getDaemonMinThreads() = 0;
  virtual unsigned int getDaemonMaxThreads() = 0;

  virtual unsigned int getInitDbConnections() = 0;
  virtual unsigned int getMinDbConnections() = 0;
  virtual unsigned int getMaxDbConnections() = 0;

  virtual unsigned int getDaemonReaperDelay() = 0;
  virtual string getDaemonUser() = 0;
  virtual string getDaemonPassword() = 0;
  virtual string getDaemonDbName() = 0;
  virtual string getDaemonAuthMethod() = 0;
  virtual string getDaemonLogFile() = 0;

  virtual string getUnixSocketBasePath() = 0;
  virtual void setUnixSocketBasePath(string path) = 0;

  virtual string getPidFileBasePath() = 0;
  virtual void setPidFileBasePath(string path) = 0;
 
  // Host data. This gets info from each host in the pool.
  virtual vector<DBHostConfig* > getHosts() = 0;

};

