#include <string>
#include <iostream>
#include <vector>

class DBPoolContainer;
class DBThreadPool;
class DBBalancerConfig;

class DBBalancer {

private:

  // Config container instance.
  DBBalancerConfig* _config;
  // Pools container instance.
  DBPoolContainer* _dbpc;
  // The thread pool
  DBThreadPool* _threadPool;

  const static int MAJ_VERSION = 0 ;
  const static int MIN_VERSION = 4 ;
  const static int PATCH_LEVEL = 2 ;

public:

  DBBalancer(DBBalancerConfig *config, unsigned int mode);
  ~DBBalancer();

  int getMajVersion() {return MAJ_VERSION ;};
  int getMinVersion() {return MIN_VERSION ;};
  int getPatchLevel() {return PATCH_LEVEL ;};
  string getStatus() {return "ALPHA";};

  void processConnection(int socket);

  // Esto rompe un poco la encapsulacin
  // Posteriormente estara bien definir mtodos que protejan los accesos.
  DBBalancerConfig* getConfig() { return _config; };
  DBPoolContainer* getPoolContainer() { return _dbpc; };
  DBThreadPool* getThreadPool() { return _threadPool; };

  // Operation modes
  const static unsigned int READER_PROCESS = 0;
  const static unsigned int WRITER_PROCESS = 1;
  
};
