/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <netdb.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <ctype.h>
#include <time.h>

#include "config.h"
#include "url.h"
#include "http.h"
#include "net.h"
#include "base64.h"
#include "tools.h"
#include "cookie.h"
#include "html.h"
#include "mime.h"
#include "errcode.h"
#include "abstract.h"
#include "myssl.h"

#ifdef USE_SSL

#define _MD5_CTX 	MD5_CTX
#define _MD5Init 	MD5_Init
#define _MD5Update	MD5_Update
#define _MD5Final	MD5_Final

#else

#include "md5c.h"

#endif

/* this function is stolen from apache md5_util.c by Jeff Hostetler */
char *_md5(data)
unsigned char *data;
{
        _MD5_CTX md5ctx;
	unsigned char md5s[16];
        unsigned char result[33];
	unsigned char pom[3];
        int i;

        _MD5Init(&md5ctx);
        _MD5Update(&md5ctx , data , strlen(data));
        _MD5Final(md5s , &md5ctx);

	result[0] = '\0';
        for (i = 0 ; i < 16 ; i++)
	{
                sprintf(pom , "%02x" , md5s[i]);
		strcat(result , pom);
	}

	return new_string(result);
}

httphdr *httphdr_parse(str)
char *str;
{
	char *p;
	httphdr *rv = _malloc(sizeof(httphdr));

	rv->all = FALSE;
	if (*str == '+')
	{
		rv->all = TRUE;
		str++;
	}

	p = strchr(str , ':');

	if (!p)
	{
		free(rv);
		return NULL;
	}

	rv->name = new_n_string(str , p - str + 1);

	p++;
	rv->val = (*p == ' ') ? new_string(p+1) : new_string(p);
	return rv;
}

void httphdr_free(hdr)
httphdr *hdr;
{
	_free(hdr->val);
	_free(hdr->name);
	_free(hdr);
}

void http_digest_deep_free(digest)
http_digest_info *digest;
{
	_free(digest->nonce);
	_free(digest->opaque);
	_free(digest->realm);
	_free(digest->site);
	_free(digest);
}

http_digest_info *http_digest_parse(mime_header , urlp , proxy_auth)
char *mime_header;
url *urlp;
int *proxy_auth;
{
	char *authtag = NULL;
	http_digest_info *retv = NULL;

	*proxy_auth = FALSE;

	if ((authtag = get_mime_param_val_str("Proxy-Authenticate:" , mime_header)))
		*proxy_auth = TRUE;	
	else authtag = get_mime_param_val_str("WWW-Authenticate:" , mime_header);

	if (authtag)
	{
		if (!strncmp(authtag , "Digest " , 7))
		{
			retv = _malloc(sizeof(http_digest_info));
			retv->nonce = html_get_attrib_from_tag(authtag , "nonce");
			retv->opaque = html_get_attrib_from_tag(authtag , "opague");
			retv->realm = html_get_attrib_from_tag(authtag , "realm");
			if (*proxy_auth)
			{
				retv->site = NULL;
				retv->port = 0;
			}
			else
			{
				retv->site = new_string(url_get_site(urlp));
				retv->port = url_get_port(urlp);
			}
		}
		_free(authtag);
	}

	return retv;
}

int http_dumy_proxy_connect(docp, host , port)
doc *docp;
char *host;
int port;
{
	http_response *mresp=NULL;
	char *p,*p2;
	int len,res;
	char auth[1024];
	char pom[1024];

	auth[0] = '\0';
        if (cfg.http_proxy_user)
        {
                if (cfg.http_proxy_pass)
                {
                        if (cfg.proxy_auth_scheme == 1)
                        {
                                sprintf(auth , "user %s:%s" ,
                                        cfg.http_proxy_user , cfg.http_proxy_pass);
                        }
                        else if (cfg.proxy_auth_scheme == 2)
                        {
                                sprintf(pom , "%s:%s" ,
                                        cfg.http_proxy_user , cfg.http_proxy_pass);
                                p2 = base64_encode(pom);
                                sprintf(auth , "Basic %s", p2);
                                free(p2);
                        }
			if (auth[0])
			{
                        	sprintf(pom , "Proxy-Authorization: %s\r\n" , auth);
                        	strcpy(auth , pom);
			}
		}
                else
                {
                        sprintf(pom , "Proxy-Authorization: user %s\r\n" , cfg.http_proxy_user);
			strcpy(auth , pom);
                }
	}

	sprintf(pom, "CONNECT %s:%d HTTP/1.0\r\n%s\r\n", host, port, auth);

	DEBUG_PROTOC(gettext("****************** Proxy connect request *****************\n"));
	DEBUG_PROTOC("%s" , pom);
	DEBUG_PROTOC("**********************************************************\n");

	if (abs_write(docp, docp->datasock , pom , strlen(pom)) != strlen(pom))
	{
		xperror("proxy req");
		return -1;
	}

	p = NULL;
	if ((res = http_read_mime_header(docp, &p , &len)) > 0)
	{
		DEBUG_PROTOS(gettext("***************** Proxy connect response *****************\n"));
		DEBUG_PROTOS("%s" , p);
		DEBUG_PROTOS("**********************************************************\n");

		mresp = http_get_response_info(p);
		_free(mresp->text);
		if (mresp->ret_code < 400)
		{
			_free(mresp);
		}
		else
		{
			_free(mresp);	
			_free(p);
			return -1;
		}
	}
	else 
	{
		_free(mresp);
		_free(p);
		return -1;
	}
	_free(p);

	return 0;
}

/************************************************/
/* na dany soket posle HTTP request		*/
/************************************************/
static int http_request(docp, method, pos , modtime, data, datalen, conttype)
doc *docp;
char *method;
int pos;
time_t modtime;
char *data;
int datalen;
char *conttype;
{
	char *req = NULL;
	char pom[2048];
	char *p,*p2;
	char **al;
	char auth[2048];
	char *user;
	char *pass;
	int auth_scheme,len;
	url *urlp = docp->doc_url;
	http_digest_info *auth_digest =
			(http_digest_info *)docp->auth_digest;
	http_digest_info *auth_proxy_digest =
			(http_digest_info *)docp->auth_proxy_digest;

	if ((!cfg.http_proxy && urlp->type == URLT_HTTP) || urlp->type == URLT_HTTPS)
	{
		p = url_encode_str(urlp->p.http.document, URL_PATH_UNSAFE);
		if (urlp->p.http.searchstr)
		{
			p = tl_str_append(p, "?");
			p2 = url_encode_str(urlp->p.http.searchstr, URL_QUERY_UNSAFE);
			p = tl_str_append(p, p2);
			_free(p2);
		}
	}
	else
	{
		if (urlp->type == URLT_FTP)
		{
			user = url_get_user(urlp , NULL);
			pass = url_get_pass(urlp , NULL);
			if (user && !urlp->p.ftp.user)
			{
				urlp->p.ftp.user = user;
			}
			else
				user = NULL;
			if (pass && !urlp->p.ftp.password)
			{
				urlp->p.ftp.password = pass;
			}
			else
				pass = NULL;
			p = url_to_urlstr_woauth(urlp, TRUE);
			if (user)
				urlp->p.ftp.user = NULL;
			if (pass)
				urlp->p.ftp.password = NULL;
		}
		else
			p = url_to_urlstr_woauth(urlp, FALSE);
	}

	if (cfg.use_http11)
		req = tl_str_concat(req, method , " " , p ,
			" HTTP/1.1\r\nAccept: */*\r\n" , NULL); 
	else
		req = tl_str_concat(req, method , " " , p ,
			" HTTP/1.0\r\nAccept: */*\r\n" , NULL); 

	_free(p);

	if (url_get_port(urlp) != prottable[urlp->type].default_port)
		sprintf(pom , "Host: %s:%d\r\n", url_get_site(urlp), url_get_port(urlp));
	else
		sprintf(pom , "Host: %s\r\n", url_get_site(urlp));
	req = tl_str_append(req , pom);

	if (cfg.identity)
	{
		sprintf(pom , "User-Agent: %s\r\n" , cfg.identity);
	}
	else
	{
		sprintf(pom , "User-Agent: pavuk/%s\r\n" , VERSION);
	}
	req = tl_str_append(req , pom);

	if (cfg.send_from && cfg.from)
	{
		sprintf(pom , "From: %s\r\n" , cfg.from);
		req = tl_str_append(req , pom);
	}

	if (cfg.send_cookies && (p = cookie_get_field(urlp)))
	{
		req = tl_str_append(req , p);
		_free(p);
	}

	auth[0] = '\0';
	user = url_get_user(urlp , auth_digest ? auth_digest->realm : NULL);
	pass = url_get_pass(urlp , auth_digest ? auth_digest->realm : NULL);
	auth_scheme = url_get_auth_scheme(urlp , auth_digest ?
		auth_digest->realm : NULL);

	/*** informacie pre autorizaciu ****/
	if (user && urlp->type != URLT_FTP)
	{
		if (pass)
		{
			if (auth_digest)
			{
				char *a1,*a2;
				char *d = url_encode_str(urlp->p.http.document, URL_PATH_UNSAFE);

				sprintf(pom , "%s:%s:%s" , user , 
					auth_digest->realm , pass);
				a1 = _md5(pom);
				sprintf(pom , "GET:%s" , d);
				a2 = _md5(pom);
				sprintf(pom , "%s:%s:%s" , a1 , 
					auth_digest->nonce , a2);
				p = _md5(pom);

				sprintf(auth , "Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", response=\"%s\"" , 
					user , auth_digest->realm , 
					auth_digest->nonce , d , p);

				if (auth_digest->opaque)
				{
					strcat(auth , ", opaque=\"");
					strcat(auth , auth_digest->opaque);
					strcat(auth , "\"");
				}
				_free(d);
			}
			else if (auth_scheme == 1)
			{
				sprintf(auth , "user %s:%s" , 
					user , pass);
			}
			else if (auth_scheme == 2)
			{
				sprintf(pom , "%s:%s" , 
					user , pass);
				p2 = base64_encode(pom);
				sprintf(auth , "Basic %s", p2);
				free(p2);
			}
			if (auth[0])
			{
				sprintf(pom , "Authorization: %s\r\n" , auth);
				req = tl_str_append(req , pom);
			}
		}
		else
		{
			sprintf(pom , "Authorization: user %s\r\n" , user);
			req = tl_str_append(req , pom);
		}
	}

        /**** informatins for HTTP proxy autorization ****/
	auth[0] = '\0';
        if (cfg.http_proxy_user)
        {
                if (cfg.http_proxy_pass)
                {
			if (auth_proxy_digest)
			{
				char *a1,*a2;
				char *d = url_to_urlstr_woauth(urlp, FALSE);

				sprintf(pom , "%s:%s:%s" , user , 
					auth_proxy_digest->realm , pass);
				a1 = _md5(pom);
				sprintf(pom , "GET:%s" , d);
				a2 = _md5(pom);
				sprintf(pom , "%s:%s:%s" , a1 , 
					auth_proxy_digest->nonce , a2);
				p = _md5(pom);

				sprintf(auth , "Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", response=\"%s\"" , 
					user , auth_proxy_digest->realm , 
					auth_proxy_digest->nonce , d , p);

				if (auth_proxy_digest->opaque)
				{
					strcat(auth , ", opaque=\"");
					strcat(auth , auth_proxy_digest->opaque);
					strcat(auth , "\"");
				}
				_free(d);
			}
                        if (cfg.proxy_auth_scheme == 1)
                        {
                                sprintf(auth , "user %s:%s" ,
                                        cfg.http_proxy_user , cfg.http_proxy_pass);
                        }
                        else if (cfg.proxy_auth_scheme == 2)
                        {
                                sprintf(pom , "%s:%s" ,
                                        cfg.http_proxy_user , cfg.http_proxy_pass);
                                p2 = base64_encode(pom);
                                sprintf(auth , "Basic %s", p2);
                                free(p2);
                        }
			if (auth[0])
			{
                        	sprintf(pom , "Proxy-Authorization: %s\r\n" , auth);
				req = tl_str_append(req , pom);
			}
                }
                else
                {
                        sprintf(pom , "Proxy-Authorization: user %s\r\n" , cfg.http_proxy_user);
			req = tl_str_append(req , pom);
                }
        }

	/**** preferovane jazyky ****/
	if (cfg.accept_lang)
	{
		bool f=FALSE;
		al = cfg.accept_lang;
		
		if (*al)
		{
			sprintf(pom , "Accept-Language: %s" , *al);
			al++;
			f = TRUE;
		}
		while(*al)
		{
			strcat(pom , ",");
			strcat(pom , *al);
			al++;
		}
		if (f)
		{
			strcat(pom , "\r\n");
			req = tl_str_append(req , pom);
		}
	}

	/*** preffered character sets ***/
	if (cfg.accept_chars)
	{
		bool f=FALSE;
		al = cfg.accept_chars;
		
		if (*al)
		{
			sprintf(pom , "Accept-Charset: %s" , *al);
			al++;
			f = TRUE;
		}
		while(*al)
		{
			strcat(pom , ",");
			strcat(pom , *al);
			al++;
		}
		if (f)
		{
			strcat(pom , "\r\n");
			req = tl_str_append(req , pom);
		}
	}
	/**** referencne URL ****/
	if (urlp->parent_url && urlp->parent_url[0])
	{
		if (urlp->parent_url[0]->type != URLT_FILE)
		{
			p = url_to_urlstr_woauth(urlp->parent_url[0], FALSE);
			req = tl_str_concat(req , "Referer: " , p , "\r\n", NULL);
			_free(p);
		}
	}
	else if (cfg.auto_referer)
	{
		p = url_to_urlstr_woauth(urlp, FALSE);
		req = tl_str_concat(req , "Referer: " , p , "\r\n", NULL);
		_free(p);
	}

	/**** povolenie kodovanie gzipom, compressom ****/
	if (cfg.use_enc)
	{
#ifdef HAVE_ZLIB
		req = tl_str_append(req , "Accept-Encoding: x-gzip, gzip, x-compress, compress, deflate\r\n");
#else
		req = tl_str_append(req , "Accept-Encoding: x-gzip, gzip, x-compress, compress\r\n");
#endif
	}

	/**** reget (iba niektore servery podporuju) ****/
	if (pos)
	{
		sprintf(pom , "Range: bytes=%d-\r\n" , pos); 
		req = tl_str_append(req , pom);
		if (cfg.send_if_range && docp->etag)
		{
			sprintf(pom , "If-Range: %s\r\n" , docp->etag);
			req = tl_str_append(req , pom);
		}
	}

	/**** synchronizacia ****/
	if (modtime && !pos)
	{
		LOCK_TIME
		strftime(pom , sizeof(pom) ,
			"If-Modified-Since: %a, %d %b %Y %H:%M:%S GMT\r\n" , gmtime(&modtime));
		UNLOCK_TIME
		req = tl_str_append(req , pom);
	}

	/**** no caching ****/
	if (!cfg.cache)
	{
		req = tl_str_append(req , "Pragma: no-cache\r\nCache-Control: no-cache\r\n");
	}

	if (cfg.http_headers)
	{
		dllist *ptr;
		ptr = cfg.http_headers;

		while (ptr)
		{
			httphdr *hdr = (httphdr *)ptr->data;

			if (!urlp->parent_url[0] || (urlp->parent_url[0] && hdr->all))
			{
				sprintf(pom, "%s %s\r\n" , hdr->name, hdr->val);
				req = tl_str_append(req , pom);
			}
			ptr = ptr->next;
		}
	}

	if (datalen)
	{
		sprintf(pom , "Content-Length: %d\r\n" , datalen);
		req = tl_str_append(req , pom);
	}

	if (conttype)
	{
		sprintf(pom , "Content-Type: %s\r\n" , conttype);
		req = tl_str_append(req , pom);
	}

	req = tl_str_append(req , "\r\n");

	DEBUG_PROTOC(gettext("************ Client HTTP MIME header ***************\n"));
	DEBUG_PROTOC("%s" , req);
	DEBUG_PROTOC("****************************************************\n");

	/**** zaslanie requestu ****/
	if (abs_write(docp, docp->datasock , req , strlen(req)) == -1)
	{
		_free(req);
		docp->errcode = ERR_HTTP_SNDREQ;
		return -1;
	}
	_free(req);

	if (data)
	{
		if (abs_write(docp, docp->datasock, data, datalen) == -1)
		{
			docp->errcode = ERR_HTTP_SNDREQDATA;
			return -1;
		}
	}

	/*** handling of 1xx response codes ***/
	while((len = abs_readln(docp , docp->datasock, pom , sizeof(pom)-1)) > 0)
	{
		http_response *resp;

		resp = http_get_response_info(pom);
		_free(resp->text);

		bufio_unread(docp->datasock, pom, len);
		if (resp && (resp->ret_code < 200))
		{
			_free(resp);
			if (http_read_mime_header(docp, &p , &len) <= 0)
			{
				xprintf(1 , gettext("Error reading HTTP 1xx class response\n"));
				abs_close_socket(docp, FALSE);
				break;
			}
			else
			{
				DEBUG_PROTOS(gettext("***************** class 1xx HTTP response ****************\n"));
				DEBUG_PROTOS("%s" , p);
				DEBUG_PROTOS("***********************************************************\n");
			}
		}
		else
		{
			_free(resp);
			break;
		}
	}

	return 0;
}

int http_get_request(docp , pos , modtime)
doc *docp;
int pos;
time_t modtime;
{
	return http_request(docp, "GET" , pos , modtime, NULL, 0, NULL);
}

int http_head_request(docp , pos , modtime)
doc *docp;
int pos;
time_t modtime;
{
	return http_request(docp, "HEAD" , pos , modtime, NULL, 0, NULL);
}

int http_post_request(docp , pos , modtime)
doc *docp;
int pos;
time_t modtime;
{
	form_info *fi = (form_info *)docp->doc_url->extension;
	char *data = NULL;
	int datalen = 0;
	char *type = NULL;
	int rv;

	if (fi->encoding == FORM_E_URLENCODED)
		type = new_string("application/x-www-form-urlencoded");
	else if (fi->encoding == FORM_E_MULTIPART)
	{
		fi->text = form_encode_multipart_boundary();
		type = tl_str_concat(type, "multipart/form-data; boundary=" , fi->text, NULL);
	}

	data = form_encode_query(fi, &datalen);

	if (!data && fi->infos)
	{
		_free(data);
		_free(type);
		_free(fi->text);

		docp->errcode = ERR_HTTP_BADRQ;

		return -1;
	}

	rv = http_request(docp, "POST" , pos , modtime, data, datalen, type);

	_free(data);
	_free(type);
	_free(fi->text);

	return rv;
}

bufio *http_open_socket(docp)
doc *docp;
{
	char *host=NULL;
	int port=0;
	url *urld = docp->doc_url;

	docp->errcode = ERR_NOERROR;

	switch (urld->type)
	{
	    case URLT_HTTP:
		if (!cfg.http_proxy)
		{
			host = urld->p.http.host;
			port = urld->p.http.port;
		}
		else
		{
			host = cfg.http_proxy;
			port = cfg.http_proxy_port;
		}
		break;
	    case URLT_HTTPS:
		if (!cfg.ssl_proxy)
		{
                	host = urld->p.http.host;
               	 	port = urld->p.http.port;
		}
		else
		{
			host = cfg.ssl_proxy;
			port = cfg.ssl_proxy_port;
		}
		break;
	    case URLT_FTP:
		if (cfg.ftp_proxy)
		{
			host = cfg.ftp_proxy;
			port = cfg.ftp_proxy_port;
		}
		else
			xprintf(1 , gettext("HUH: don't know how to gateway FTP when proxy not specified\n"));
		break;
	    case URLT_GOPHER:
		if (cfg.gopher_proxy)
		{
			host = cfg.gopher_proxy;
			port = cfg.gopher_proxy_port;
		}
		else
			xprintf(1 , gettext("HUH: don't know how to gateway Gopher when proxy not specified\n"));
		break;
	     default:
		xprintf(1 , gettext("HUH: this protocol is not supported for gatewaying\n"));
		
	}

	if (!docp->datasock)
	{
		docp->datasock = bufio_fdopen(net_connect(host , port));

#ifdef USE_SSL	
		if (docp->datasock && urld->type == URLT_HTTPS)
		{
			if (!ssl_do_connect(docp, docp->datasock, &docp->ssl_con,
				&docp->ssl_ctx, &docp->ssl_method, &docp->ssl_bio, NULL))
			{
				if (!docp->errcode) docp->errcode = ERR_HTTPS_CONNECT;
				shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = NULL;
				return NULL;
			}
		}
#endif
	}

	if (!docp->datasock)
	{
		if (h_errno != 0)
			xherror(host);
		else
			xperror("net_connect");

		docp->errcode = ERR_HTTP_CONNECT;
		return NULL;
	}

	return docp->datasock;
}

bufio *http_get_data_socket(docp , pos , modtime , ishead)
doc *docp;
int pos;
time_t modtime;
int ishead;
{
	int rv;

	if (!(docp->datasock = http_open_socket(docp)))
		return NULL;
	
	if (ishead)
	{
		rv = http_head_request(docp , pos , modtime);
		if (rv) xperror("http_head_request");
	}
	else
	{
		if ((docp->doc_url->status &  URL_FORM_ACTION))
		{
			form_info *fi = (form_info *)docp->doc_url->extension;

			if (fi->method == FORM_M_POST)
			{
				rv = http_post_request(docp , pos , modtime);
				if (rv) xperror("http_get_request");
			}
			else if (fi->method == FORM_M_GET)
			{
				int l;
				docp->doc_url->p.http.searchstr = form_encode_query((form_info *) docp->doc_url->extension, &l);
				rv = http_get_request(docp , pos , modtime);
				if (rv) xperror("http_get_request");
				_free(docp->doc_url->p.http.searchstr);
			}
		}
		else
		{
			rv = http_get_request(docp , pos , modtime);
			if (rv) xperror("http_get_request");
		}
	}

	if (rv)
	{
#ifdef USE_SSL	
		if (docp->doc_url->type == URLT_HTTPS)
		{
#ifdef DEBUG
			ERR_print_errors_fp(stdout);
#endif
			SSL_free(docp->ssl_con);
			SSL_CTX_free(docp->ssl_ctx);
			docp->ssl_con = NULL;
			docp->ssl_ctx = NULL;

		}
#endif
		shutdown(bufio_getfd(docp->datasock) , 2);
		bufio_close(docp->datasock);
		return NULL;
	}
	return docp->datasock;
}

/**********************************************/
/* parsovanie navratoveho kodu z HTTP servera */
/**********************************************/

http_response * http_get_response_info(doc_txt)
char *doc_txt;
{
	char *ptr,*p;
	char pom[1024];

	if (!doc_txt) return NULL;

	ptr = strchr(doc_txt , '\n');

	if (ptr)
	{
		strncpy(pom , doc_txt , ptr - doc_txt);

		*(pom + (ptr - doc_txt)) = '\0';

		if (!strncmp(pom,"HTTP/",5))
		{
			http_response *ret_val = (http_response *)
				_malloc(sizeof(http_response));

			p = pom + 5;
			ret_val->ver_maj = atoi(p);

			p += strspn(p , "0123456789");
			ret_val->ver_min = 0;
			if (*p == '.');
			{
				p ++;
				ret_val->ver_min = atoi(p);
			}

			p += strspn(p , "0123456789");
			p += strspn(p , " ");
			ret_val->ret_code = atoi(p);

			p += strspn(p , "0123456789");
			p += strspn(p , " ");

			ret_val->text = new_string(p);

			return ret_val;
		}
	}
	return NULL;
}

int http_read_mime_header(docp, buf , len)
doc *docp;
char **buf;
int *len;
{
	char pom[4096];
	char *rb;
	int alen,tlen=0;
	rb = NULL;

	*buf = NULL;

	if ((alen = abs_readln(docp, docp->datasock , pom , sizeof(pom)))>0)
	{
		if (!strncmp(pom , "HTTP/" , 5))
		{
			rb = _malloc(alen + 1);
			tlen += alen;
			memmove(rb , pom , alen + 1);
			while((alen = abs_readln(docp, docp->datasock , pom , sizeof(pom))) > 0)
			{
				tlen += alen;
				rb = _realloc(rb , tlen + 1);
				memmove(rb + tlen - alen , pom , alen + 1);
				*(rb + tlen) = '\0';
				if (pom[0] == '\r' || pom[0] == '\n') break;
			}
			if (alen < 0)
			{
				docp->errcode = ERR_READ;
				xperror("http_response");
				_free(rb);
				*len = 0;
				*buf = NULL;
				return -1;
			}
			else
			{
				*len = tlen;
				*buf = rb;
				return 1;
			}
		}
		else
		{
			*len = tlen;
			*buf = rb;
			return 0;
		}
	}
	else
	{
		*buf = NULL;
		*len = 0;
		if (alen < 0)
		{
			docp->errcode = ERR_READ;
			xperror("http_response");
			return -1;
		}
		return 0;
	}
}

