/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkMultiCol Copyright (C) 1998 Stefan Ondrejicka <ondrej@idata.sk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_MULTICOL_H__
#define __GTK_MULTICOL_H__


#include <gdk/gdk.h>
#include <gtk/gtkbox.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_MULTICOL(obj)          GTK_CHECK_CAST (obj, gtk_multicol_get_type (), GtkMultiCol)
#define GTK_MULTICOL_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_multicol_get_type (), GtkMultiColClass)
#define GTK_IS_MULTICOL(obj)       GTK_CHECK_TYPE (obj, gtk_multicol_get_type ())


typedef struct _GtkMultiCol       GtkMultiCol;
typedef struct _GtkMultiColClass  GtkMultiColClass;

struct _GtkMultiCol
{
	GtkBox		box;

	gint		nrows;

	gint		vspacing;
	gint		hspacing;
};

struct _GtkMultiColClass
{
	GtkBoxClass parent_class;
};

guint		gtk_multicol_get_type		(void);
GtkWidget*	gtk_multicol_new		(gint 		nrows);
void		gtk_multicol_set_number_of_rows	(GtkMultiCol	*multicol ,
						 gint		nrows);
void		gtk_multicol_set_spacing	(GtkMultiCol	*multicol ,
						 gint		hspacing ,
						 gint		vspacing);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_MULTICOL_H__ */
