/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _ginterface_h_
#define _ginterface_h_

#ifdef GTK_FACE
#include <gtk/gtk.h>

#if defined GTK_CHECK_VERSION
#if GTK_CHECK_VERSION(1 , 2 , 0)
#define _GTK_FEATURES_1_2
#endif
#else
#if defined GTK_MAJOR_VERSION && defined GTK_MINOR_VERSION
#if GTK_MAJOR_VERSION == 1 && GTK_MINOR_VERSION == 2
#define _GTK_FEATURES_1_2
#endif
#else
#undef _GTK_FEATURES_1_2
#endif
#endif /* GTK_CHECK_VERSION */

#include "tools.h"
#include "mode.h"

typedef struct {
	GdkPixmap *pixmap;
	GdkBitmap *shape;
} Icon;

extern Icon * load_pmap(char **);

#define iface_load_xpm_icon(xpm_name) load_pmap(xpm_name)


/**** makro na obsluhu udalosti z rozhrania X-windows ****/
#ifndef _Xt_Serve
#define _Xt_Serve \
	if (cfg.xi_face)\
	{\
		cfg.gtk.endloop = FALSE;\
		while (!cfg.gtk.endloop && gdk_events_pending() && !gtk_main_iteration ());\
	}
#endif

#ifndef _Xt_ServeLoop
#define _Xt_ServeLoop \
	if (cfg.xi_face)\
	{\
		cfg.gtk.endloop = FALSE;\
		while(!cfg.gtk.endloop && !cfg.rbreak)\
		{\
			gtk_main_iteration ();\
		}\
	}
#endif

#ifndef _X_EscLoop
#define _X_EscLoop()\
	if (cfg.xi_face)\
		cfg.gtk.endloop = TRUE;
#endif

#ifdef _GTK_FEATURES_1_2
#define GUI_TREE_RTYPE GtkCTreeNode*
#else
#define GUI_TREE_RTYPE GtkWidget*
#endif
 
typedef struct {
	GtkWidget		*watch_download;
	GtkWidget		*hash_size;
	GtkWidget		*local_ip;
	GtkWidget		*max_time;
	GtkWidget		*use_http11;
	GtkWidget		*site_level;
	GtkWidget		*debug_level_mi;
	GtkWidget		*debug_level_m;
	GtkWidget		*http_headers;
/* for fnrules */
	GtkWidget		*rules_list;
	GtkWidget		*mpt_entry;
	GtkWidget		*rule_entry;
	GtkWidget		*ptrn_fnmatch;
	GtkWidget		*ptrn_regex;
/* end for fnrules */
#ifdef HAVE_REGEX
	GtkWidget		*aip;
	GtkWidget		*skipip;
	GtkWidget		*rpattern;
	GtkWidget		*skip_rpattern;
	GtkWidget		*url_rpattern;
	GtkWidget		*url_skip_rpattern;
#endif
#ifdef HAVE_DBOPEN
	GtkWidget		*ns_cache_dir;
#endif
	GtkWidget		*show_time;
	GtkWidget		*post_cmd;
	GtkWidget		*gen_logname;
	GtkWidget		*sched_cmd;
	GtkWidget		*send_if_range;
	GtkWidget		*remove_adv;
	GtkWidget		*advert_res;
	GtkWidget		*scheduling_strategie;
	GtkWidget		*auto_referer;
	GtkWidget		*cookie_check_domain;
	GtkWidget		*remind_cmd;
	GtkWidget		*sel_to_local;
	GtkWidget		*all_to_local;
	GtkWidget		*url_to_local;
	GtkWidget		*all_to_remote;
	GtkWidget		*enable_info;
	GtkWidget		*enable_js;
	GtkWidget		*fs_quota;
	GtkWidget		*file_quota;
	GtkWidget		*trans_quota;
	GtkWidget		*s_etime;
	GtkWidget		*s_rtime;
	GtkWidget		*s_rate;
	GtkWidget		*minrate;
	GtkWidget		*maxrate;
	GtkWidget		*bufsize;
	GtkWidget		*use_prefs;
	GtkWidget		*charset_list;
	GtkWidget		*acharset_list;
	GtkWidget		*acharset_entry;
	GtkWidget		*identity;
	GtkWidget		*store_index;
	GtkWidget		*send_from;
	GtkWidget		*check_size;
	GtkWidget		*min_size;
	GtkWidget		*skip_pattern;
	GtkWidget		*skip_url_pattern;
	GtkWidget		*ftp_html;
	GtkWidget		*preserve_links;
	GtkWidget		*preserve_perm;
	GtkWidget		*ftp_list;
	GtkWidget		*index_name;
	GtkWidget		*store_name;
#ifdef _GTK_FEATURES_1_2
	GtkAccelGroup 		*accel_group;
	GtkAccelGroup 		*tv_accel_group;
	GSList			*menu_gaccels;
#endif
	GtkWidget		*tr_del_chr;
	GtkWidget		*tr_str_s1;
	GtkWidget		*tr_str_s2;
	GtkWidget		*tr_chr_s1;
	GtkWidget		*tr_chr_s2;
	GtkWidget		*en_uexit;
	GtkWidget		*html_tags;
	GtkWidget		*cookie_domain_list;
	GtkWidget		*cookie_domain_entry;
	GtkWidget		*en_cookie_max;
	GtkWidget		*sw_cookie_update;
	GtkWidget		*sw_cookie_recv;
	GtkWidget		*sw_cookie_send;
	GtkWidget		*en_cookie_file;
	GtkWidget		*cb_comcfg;
	GtkWidget		*leave_level;
	GtkWidget		*cfg_menu;
	GtkWidget		*ptime;
	GtkWidget		*leaves_sw;
	GtkWidget		*leaved_sw;
	GtkWidget		*resched;
	GtkWidget		*btime_h_entry;
	GtkWidget		*etime_h_entry;
	GtkWidget		*btime_min_entry;
	GtkWidget		*etime_min_entry;
	GtkWidget		*btime_yentry;
	GtkWidget		*etime_yentry;
	GtkWidget		*btime_mon;
	GtkWidget		*etime_mon;
	GtkWidget		*btime_cal;
	GtkWidget		*etime_cal;
	GtkWidget		*btime_sw;
	GtkWidget		*etime_sw;
	GtkWidget		*selected_node;  /*** selected tree node ***/
	GUI_TREE_RTYPE		root;		/*** tree root item ***/
	bool			endloop;	/*** end procesing _Xt_Serve ***/
	GtkWidget		*modegr[NUM_MODES];	/*** radio group for mode selection ***/
	GtkWidget		*ftpmodegr[2];
	GtkWidget		*http_schgr[3];
	GtkWidget		*httpp_schgr[3];
	GtkWidget		*toplevel;	/*** jednotlive widgety ktore potrebujeme adresovat ***/
	GtkWidget		*logw;
	GtkAdjustment		*logvadj;
	GtkWidget		*scn_load_shell;
	GtkWidget		*scn_save_shell;
	GtkWidget		*log_label;
	GtkWidget		*slog_label;
	GtkWidget		*base_level_label;
	GtkWidget		*xloglen_label;
	GtkWidget		*maxdoc_label;
	GtkWidget		*maxlev_label;
	GtkWidget		*maxsize_label;
	GtkWidget		*browser_label;
	GtkWidget		*ddays_label;
	GtkWidget		*rollback_label;
	GtkWidget		*oldrm_sw;
	GtkWidget		*mime_sw;
	GtkWidget		*freget_sw;
	GtkWidget		*noreloc_sw;
	GtkWidget		*gopher_sw;
	GtkWidget		*ftp_sw;
	GtkWidget		*ftpd_sw;
	GtkWidget		*ftp_data_sw;
	GtkWidget		*http_sw;
	GtkWidget		*cache_sw;
	GtkWidget		*cgi_sw;
	GtkWidget		*robots_sw;
	GtkWidget		*enc_sw;
	GtkWidget		*auth_sw;
	GtkWidget		*url_entry;
	GtkWidget		*url_list;
	GtkWidget		*cdir_label;
	GtkWidget		*http_proxyh_label;
	GtkWidget		*http_proxyp_label;
#ifdef USE_SSL
	GtkWidget		*ftps_sw;
	GtkWidget		*https_sw;
	GtkWidget		*ssl_proxyh_label;
	GtkWidget		*ssl_proxyp_label;
	GtkWidget		*ssl_key_file_en;
	GtkWidget		*ssl_cert_file_en;
	GtkWidget		*ssl_cert_passwd_en;
	GtkWidget		*ssl_cipher_list;
	GtkWidget		*unique_sslid;
#endif
	GtkWidget		*ssl_version[3];
	GtkWidget		*ftp_proxyh_label;
	GtkWidget		*ftp_proxyp_label;
	GtkWidget		*ftp_httpgw;
	GtkWidget		*ftp_dirtyp;
	GtkWidget		*gopher_proxyh_label;
	GtkWidget		*gopher_proxyp_label;
	GtkWidget		*gopher_httpgw;
	GtkWidget		*retry_label;
	GtkWidget		*redir_label;
	GtkWidget		*reget_label;
	GtkWidget		*hour_label;
	GtkWidget		*min_label;
	GtkWidget		*year_label;
	GtkWidget		*month_combo;
	GtkWidget		*auth_label;
	GtkWidget		*pass_label;
	GtkWidget		*auth_reuse_nonce;
	GtkWidget		*proxy_auth_label;
	GtkWidget		*proxy_pass_label;
	GtkWidget		*auth_reuse_proxy_nonce;
	GtkWidget		*proxy_auth_sw;
	GtkWidget		*from_label;
	GtkWidget		*subdir_label;
	GtkWidget		*timeout_label;
	GtkWidget		*config_shell;
	GtkWidget		*about_shell;
	GtkWidget		*calendar;
	GtkWidget		*what_widget;	
	GtkWidget		*cnt_widget;
	GtkWidget		*size_widget;
	GtkWidget		*langlist;
	GtkWidget		*alanglist;
	GtkWidget		*alang_entry;
	GtkWidget		*mimelist;
	GtkWidget		*amimelist;
	GtkWidget		*mimet_entry;
	GtkWidget		*prefixlist;
	GtkWidget		*prefix_label;
	GtkWidget		*prefix_sw;
	GtkWidget		*sufixlist;
	GtkWidget		*sufix_label;
	GtkWidget		*sufix_sw;
	GtkWidget		*domain_sw;
	GtkWidget		*domain_list;
	GtkWidget		*domain_entry;
	GtkWidget		*hosts_sw;
	GtkWidget		*hosts_list;
	GtkWidget		*hosts_entry;
	GtkWidget		*pattern_label;
	GtkWidget		*url_pattern_label;
	GtkWidget		*sleep_label;
	GtkWidget		*cfg_sch;
	GtkWidget		*cfg_limits;
	GtkWidget		*mbb_cfg;
	GtkWidget		*mbb_mode;
	GtkWidget		*bt_cfg;
	GtkWidget		*bt_lim;
	GtkWidget		*bt_bg;
	GtkWidget		*bt_rest;
	GtkWidget		*bt_start;
	GtkWidget		*bt_stop;
	GtkWidget		*bt_break;
	GtkWidget		*bt_exit;
	GtkWidget		*mea_rest;
	GtkWidget		*mea_start;
	GtkWidget		*mea_stop;
	GtkWidget		*mea_break;
	GtkWidget		*mtb_rest;
	GtkWidget		*mtb_start;
	GtkWidget		*mtb_stop;
	GtkWidget		*mtb_break;
	GtkWidget		*toolbar;
	GtkWidget		*minitb_label;
	char			*bt_icon_cfg;
	char			*bt_icon_cfg_s;
	char			*bt_icon_lim;
	char			*bt_icon_lim_s;
	char			*bt_icon_gobg;
	char			*bt_icon_gobg_s;
	char			*bt_icon_rest;
	char			*bt_icon_rest_s;
	char			*bt_icon_cont;
	char			*bt_icon_cont_s;
	char			*bt_icon_stop;
	char			*bt_icon_stop_s;
	char			*bt_icon_brk;
	char			*bt_icon_brk_s;
	char			*bt_icon_exit;
	char			*bt_icon_exit_s;
	char			*bt_icon_mtb;
	char			*bt_icon_mtb_s;
#ifdef WITH_TREE
	GtkWidget		*tree_widget;
	GtkWidget		*tree_shell;
	GtkWidget		*tree_help;
	GtkWidget		*tmenu;
	GtkWidget		*me_disable_url;
	GtkWidget		*me_enable_url;
	GtkWidget		*me_download_url;
	GtkWidget		*me_browse_url;
	GtkWidget		*me_prop_url;
	GtkWidget		*me_debug;
	GtkWidget		*me_quiet;
#endif
} Gtk_nfo;

extern void SelectTreeNode();
extern void iface_loop();
extern void build_interface();
extern void iface_set_counter();
extern void iface_set_what();
extern void iface_set_size();
extern void iface_url_set_icon();
extern GUI_TREE_RTYPE iface_make_tree_entry();
extern void iface_set_url();


#endif
#endif
