/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/Xlib.h>
#include <stdlib.h>
#include <X11/ShellP.h>

#include <Nws/utils.h>
#include <Nws/BaseMEP.h>

static char stiple_bitmap[] = {0x01, 0x02};

void 
X_DrawSimple3DFrame(dpy,win,x,y,width,height,thickness,top_left_color,bottom_right_color)
Display *dpy;
Drawable win;
int  x;
int  y;
int  width;
int  height;
int  thickness;
Pixel  top_left_color;
Pixel bottom_right_color;
{

	if (thickness == 0) return;
	else {
		XPoint top_leftPoints[6];

		XPoint bottom_rightPoints[6];

		GC gc;
		XGCValues gc_res;
		XtGCMask gc_mask;

		top_leftPoints[0].x = x;
		top_leftPoints[0].y = y;
		top_leftPoints[1].x = x + width;
		top_leftPoints[1].y = y;
		top_leftPoints[2].x = x + width - thickness;
		top_leftPoints[2].y = y + thickness;
		top_leftPoints[3].x = x + thickness;
		top_leftPoints[3].y = y + thickness;
		top_leftPoints[4].x = x + thickness;
		top_leftPoints[4].y = y + height - thickness;
		top_leftPoints[5].x = x;
		top_leftPoints[5].y = y + height;

		bottom_rightPoints[0].x = x + width;
		bottom_rightPoints[0].y = y + height;
		bottom_rightPoints[1].x = x;
		bottom_rightPoints[1].y = y + height;
		bottom_rightPoints[2].x = x + thickness;
		bottom_rightPoints[2].y = y + height - thickness;
		bottom_rightPoints[3].x = x + width - thickness;
		bottom_rightPoints[3].y = y + height - thickness;
		bottom_rightPoints[4].x = x + width - thickness;
		bottom_rightPoints[4].y = y + thickness;
		bottom_rightPoints[5].x = x + width;
		bottom_rightPoints[5].y = y;


		gc_res.foreground =  top_left_color;
		gc_mask = GCForeground ;
		gc = XCreateGC(dpy , win , gc_mask , &gc_res);
		
		XFillPolygon(dpy , win , gc , top_leftPoints , 
			XtNumber(top_leftPoints) , Nonconvex , CoordModeOrigin);

		XSetForeground(dpy , gc , bottom_right_color);

		XFillPolygon(dpy, win , gc , bottom_rightPoints , 
			XtNumber(bottom_rightPoints), Nonconvex, CoordModeOrigin);

		XFreeGC(dpy , gc);
	}
}


void X_DrawSimpleRawFrame(dpy,win,x,y,width,height,thickness,color)
Display *dpy;
Drawable win;
int  x;
int  y;
int  width;
int  height;
int  thickness;
Pixel  color;
{
	if (thickness == 0) return;
	else
	{
		XPoint points[10];
		
		GC gc;
		XGCValues gc_res;
		XtGCMask gc_mask;

		points[0].x = x;
		points[0].y = y;
		points[1].x = x + width;
		points[1].y = y;
		points[2].x = x + width;
		points[2].y = y  + height;
		points[3].x = x;
		points[3].y = y + height;
		points[4].x = x;
		points[4].y = y + thickness;
		points[5].x = x + thickness;
		points[5].y = y + thickness;
		points[6].x = x + thickness;
		points[6].y = y + height - thickness;
		points[7].x = x + width - thickness;
		points[7].y = y + height - thickness;
		points[8].x = x + width - thickness;
		points[8].y = y + thickness;
		points[9].x = x;
		points[9].y = y + thickness;

		gc_res.foreground =  color;
		gc_mask = GCForeground ;
		gc = XCreateGC(dpy , win , gc_mask , &gc_res);
		
		XFillPolygon(dpy , win , gc , points , 
			XtNumber(points) , Nonconvex , CoordModeOrigin);

		XFreeGC(dpy , gc);
	}
}

void X_DrawIcon(dpy,win,icon,x,y)
Display *dpy;
Drawable win;
Icon *icon;
int  x;
int  y;
{
	GC	gc;
	XGCValues gc_res;
	XtGCMask  gc_mask;
	
	if (icon == NULL) return;
	
	gc_res.fill_style = FillTiled;
	gc_res.fill_style = FillTiled;
	gc_res.tile = icon->pixmap;
	gc_res.clip_mask = icon->shape;
	gc_res.ts_x_origin = x;
	gc_res.ts_y_origin = y;
	gc_res.clip_x_origin = x;
	gc_res.clip_y_origin = y;

	gc_mask = GCTile | GCClipMask | GCFillStyle | GCTileStipXOrigin | 
		  GCTileStipYOrigin | GCClipXOrigin | GCClipYOrigin;

	gc = XCreateGC(dpy,DefaultRootWindow(dpy),gc_mask, &gc_res);

	XFillRectangle(dpy , win , gc , x , y , icon->width , icon->height);

	XFreeGC(dpy , gc);
}

void X_Draw3DArrow(dpy , win , x , y , width , height , type , top , bottom , normal)
Display * dpy;
Window win;
int  x;
int  y;
int  width;
int  height;
int  type;
Pixel top;
Pixel bottom;
Pixel normal;
{
	GC	gc;
	XGCValues gc_res;
	
	gc_res.foreground = normal;

	gc = XCreateGC(dpy , win , GCForeground, &gc_res );

	switch (type)
	{
	    case XtCtop:
		{
			XPoint poly[3];

			poly[0].x = x;
			poly[0].y = y + height;
			poly[1].x = x + width / 2;
			poly[1].y = y;
			poly[2].x = x + width;
			poly[2].y = y + height;

			XFillPolygon(dpy , win , gc , poly , XtNumber(poly) ,
				 Nonconvex , CoordModeOrigin);

			XSetForeground(dpy , gc , top);
			XDrawLine(dpy , win , gc , x , y + height , x + width / 2 , y);
			XSetForeground(dpy , gc , bottom);
			XDrawLine(dpy , win , gc , x , y + height , x + width ,
				 y + height);
			XDrawLine(dpy , win , gc , x + width , y + height ,
				x+ width / 2 , y);
		}
		break;
	    case XtCbottom:
		{
			XPoint poly[3];

			poly[0].x = x;
			poly[0].y = y;
			poly[1].x = x + width / 2;
			poly[1].y = y + height;
			poly[2].x = x + width;
			poly[2].y = y;

			XFillPolygon(dpy , win , gc , poly , XtNumber(poly) ,
				 Nonconvex , CoordModeOrigin);

			XSetForeground(dpy , gc , top);
			XDrawLine(dpy , win , gc , x , y  , x + width , y);
			XDrawLine(dpy , win , gc , x , y , x + width / 2 ,
				 y + height);
			XSetForeground(dpy , gc , bottom);
			XDrawLine(dpy , win , gc , x + width , y ,
				x + width / 2 , y + height);

		}
		break;
	    case XtCright:
		{
			XPoint poly[3];

			poly[0].x = x;
			poly[0].y = y;
			poly[1].x = x + width;
			poly[1].y = y + height / 2;
			poly[2].x = x;
			poly[2].y = y + height;

			XFillPolygon(dpy , win , gc , poly , XtNumber(poly) ,
				 Nonconvex , CoordModeOrigin);

			XSetForeground(dpy , gc , top);
			XDrawLine(dpy , win , gc , x , y , x , y + height);
			XDrawLine(dpy , win , gc , x , y , x + width ,
				 y + height / 2);
			XSetForeground(dpy , gc , bottom);
			XDrawLine(dpy , win , gc , x + width , y + height / 2 ,
				x , y + height);

		}
		break;
	    case XtCleft:
	    default:
		{

			XPoint poly[3];

			poly[0].x = x + width;
			poly[0].y = y;
			poly[1].x = x;
			poly[1].y = y + height / 2;
			poly[2].x = x + width;
			poly[2].y = y + height;

			XFillPolygon(dpy , win , gc , poly , XtNumber(poly) ,
				 Nonconvex , CoordModeOrigin);

			XSetForeground(dpy , gc , bottom);
			XDrawLine(dpy , win , gc , x , y + height / 2 ,
				x + width , y + height);
			XDrawLine(dpy , win , gc , x + width  , y , x + width ,
				 y + height );
			XSetForeground(dpy , gc , top);
			XDrawLine(dpy , win , gc , x , y + height / 2 ,
				x + width , y );
		}
	}
	XFreeGC(dpy , gc);
}

void X_Draw3DRectangle(dpy,win,x,y,width,height,thickness,top,bottom,normal)
Display *dpy;
Drawable win;
int  x;
int  y;
int  width;
int  height;
int  thickness;
Pixel  top;
Pixel bottom;
Pixel normal;
{
	GC	gc;
	XGCValues gc_res;
	
	gc_res.foreground = normal;

	gc = XCreateGC(dpy , win , GCForeground, &gc_res );

	XFillRectangle(dpy , win , gc , x + thickness , y + thickness ,
		width - 2 * thickness , height - 2 * thickness);

	XFreeGC(dpy , gc);
	
	X_DrawSimple3DFrame(dpy , win , x , y , width , height , thickness ,
		top , bottom);
		
}

void X_Draw3DString(dpy,win,font,x,y,offset,text,length,normal,shadow)
Display *dpy;
Drawable win;
XFontStruct *font;
int  x;
int  y;
int offset;
String text;
int length;
Pixel normal;
Pixel shadow;
{
	GC	gc;
	XGCValues gc_res;
	
	gc_res.foreground = shadow;
	gc_res.font = font->fid;
	gc = XCreateGC(dpy , win , GCForeground | GCFont , &gc_res );

	XDrawString(dpy , win , gc , x + offset , y + offset , text , length);

	XSetForeground(dpy , gc , normal);

	XDrawString(dpy , win , gc , x , y , text , length);

	XFreeGC(dpy , gc);
}

void X_DrawTextCursor(dpy , win , x , y , height , color)
Display *dpy;
Window win;
int x;
int y;
int height;
Pixel color;
{
	GC	gc;
	XGCValues gc_res;

	gc_res.foreground = color;

	gc = XCreateGC(dpy , win , GCForeground , &gc_res );

	XDrawLine(dpy , win , gc , x , y , x , y + height);
	XDrawLine(dpy, win , gc , x - 2 , y , x + 2 , y);
	XDrawLine(dpy , win , gc, x - 2 , y + height , x + 2 ,y + height);

	XFreeGC(dpy , gc);

}

Icon *X_XpmDataToIcon(dpy , data)
Display *dpy;
char **data;
{
        int status;
        Icon *icon = (Icon *) malloc(sizeof(Icon));
        unsigned int b_width,depth;
        int x,y;

        status = XpmCreatePixmapFromData(dpy , DefaultRootWindow(dpy) , data ,
                        &icon->pixmap , &icon->shape , NULL);

        switch (status) {
                case XpmOpenFailed:
                case XpmFileInvalid:
                case XpmNoMemory:
			XtWarning("Unable to create icon from data");
                        break;

                case XpmColorError:
                case XpmColorFailed:
                        XtWarning("Could not get (all) colors for icon");
                case XpmSuccess:
                	if (icon->pixmap)
	                        status=XGetGeometry(dpy , icon->pixmap , &DefaultRootWindow(dpy) ,
                                        &x , &y , &icon->width , &icon->height ,
					&b_width , &depth);
        		else
        		{
        			free(icon);
        			icon = NULL;
				XtWarning("Unable to create icon from data");
        		}
	}

	return icon;
}

Region X_ClipWindowByParent(dpy , win)
Display *dpy;
Window win;
{
	XPoint clipb[4];
	unsigned int pw,ph,bw,dpt,ww,wh;
	int wx,wy,px,py;
        Window root , parent , *childs ;
        unsigned int nchilds;

	XQueryTree(dpy , win , &root , &parent , &childs , &nchilds);
	if (childs) XFree(childs);

	XGetGeometry(dpy , parent , &root , &px , &py , &pw , &ph , &bw , &dpt); 
	XGetGeometry(dpy , win , &root , &wx , &wy , &ww , &wh , &bw , &dpt); 

	clipb[0].x = 0;
	clipb[0].y = (wy < 0) ? -wy : 0;
	clipb[1].x = ww;
	clipb[1].y = (wy < 0) ? -wy : 0;
	clipb[2].x = 0;
	clipb[2].y = (wy + wh > ph) ? ph - wy : wh;
	clipb[1].x = ww;
	clipb[2].y = (wy + wh > ph) ? ph - wy : wh;
		
	return XPolygonRegion(clipb , 4 , EvenOddRule);
}

void X_GetWindowRootPosition(dpy , win , x , y)
Display *dpy;
Window win;
int *x;
int *y;
{
        Window root , parent , *childs ;
        unsigned int nchilds;
	unsigned int bw,dpt,ww,wh;
	int wx,wy;
	int rx = 0 , ry = 0;
	
	XQueryTree(dpy , win , &root , &parent , &childs , &nchilds);
	XFree(childs);

	while(win != root)
	{
		XGetGeometry(dpy , win , &root , &wx , &wy , &ww , &wh , &bw , &dpt); 
		rx += wx;
		ry +=wy;
		XQueryTree(dpy , win , &root , &parent , &childs , &nchilds);
		XFree(childs);
		win = parent;
	}

	*x = rx;
	*y = ry;
}

void Xt_SetInsensitive(w)
Widget w;
{
	Pixmap p;
	GC gc;
	XGCValues gc_res;
	Display *dpy;
	Window win;


	if (!XtIsRealized(w)) return;

	if (XtIsSubclass(w , coreWidgetClass))
	{
		dpy = XtDisplay(w);
		win = XtWindow(w);
	}
	else
	{
		dpy = XtDisplayOfObject(w);
		win = XtWindowOfObject(w);
	}

	p = XCreateBitmapFromData(dpy,win,stiple_bitmap,2,2);
		
	if (XtIsSubclass(w , coreWidgetClass))
	{
		gc_res.foreground = w->core.background_pixel;
	}
	else
	{
		gc_res.foreground = ((BaseMEObject) w)->baseME.background;
	}
	
	gc_res.fill_style = FillStippled;
	gc_res.stipple = p;

	gc = XCreateGC(dpy , win , 
		GCForeground | GCStipple | GCFillStyle , &gc_res );

	if (XtIsSubclass(w , coreWidgetClass))
	{
		XFillRectangle(dpy , win , gc , 0 , 0 , 
			w->core.width , w->core.height);
	}
	else
	{
		XFillRectangle(dpy , win , gc , w->core.x , w->core.y ,
			w->core.width , w->core.height);
	}

	XFreeGC(dpy , gc);
	XFreePixmap(dpy , p);
}

Widget Xt_GetShell(w)
Widget w;
{
	Widget pw;

	pw = w;

	while(pw && !XtIsShell(pw)) pw = XtParent(pw);

	return pw;
}

Boolean Xt_IsUp(w)
Widget w;
{
	ShellWidget sw = (ShellWidget) Xt_GetShell(w);

	return sw ?  sw->shell.popped_up : False;
}
