/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _TreeListP_H_
#define _TreeListP_H_

#include <Nws/BaseP.h>
#include <Nws/TreeList.h>

typedef struct {
	char	empty;
} TreeListClassPart;

typedef struct _TreeListClassRec {
        CoreClassPart           core_class;
        BaseClassPart		base_class;
        TreeListClassPart     	treeList_class;
} TreeListClassRec;

extern TreeListClassRec treeListClassRec;

typedef struct {
	/* resources */
	Pixel		tree_line_color;
	int		spacing;
        XtCallbackList  select_cb;
        XtCallbackList  select_changed_cb;
        Pixel           selected_fg;
        Pixel           selected_bg;
        Boolean		do_layout;
        Boolean		delete_subtree_on_close;
        Boolean		restore_state_on_open;
        int		section_distance;
        XFontStruct	*font;
        Boolean		direct_draw;
	/* private */
	int		topx;
	int		topy;
	Boolean		internal_mode;
	TreeList	*root;
	XtIntervalId	double_click_timer;
	TreeList	*last_selected;
	GC		lineGC;
	GC		gc;
	int		pos;
	int		width;
	Dimension	node_height;
	TreeList	*found;
	void		*condition_struct;
	Boolean		scrolled;
} TreeListPart;

typedef struct _TreeListRec {
        CorePart        core;
        BasePart	base;
        TreeListPart	treeList;
} TreeListRec;

#endif
