/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include	"RadioGroupP.h"
#include	"CheckButton.h"
#include	"Init.h"
#include	"cvt.h"

#define offset(field) XtOffsetOf(RadioGroupRec , radioGroup.field)

static XtResource resources[] = {
	{
	 XtNswitch ,
	 XtCSwitch ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(switch_it) ,
	 XtRCallback ,
	 (XtPointer) NULL
	},
};

static XtResource radioGroupConstraintsResources [] = {
        {
         XtNid ,
         XtCId ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(RadioGroupConstraintsRec , multiCol.id) ,
         XtRImmediate ,
         (XtPointer) 0
        },
};

static void ClassInitialize();
static void ResolveInheritance();
static void InsertChild ();

static void Switch();

RadioGroupClassRec radioGroupClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &multiColClassRec,
    /* class_name            */ "RadioGroup",
    /* widget_size           */ sizeof(RadioGroupRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ ResolveInheritance,
    /* class_inited          */ FALSE,
    /* initialize            */ NULL,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ False,
    /* compress_enterleave   */ False,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ XtInheritResize,
    /* expose                */ XtInheritExpose,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ 0,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* composite */
   {
    /* geometry_manager      */ XtInheritGeometryManager,
    /* change_managed        */ XtInheritChangeManaged,
    /* insert_child          */ InsertChild,
    /* delete_child          */ XtInheritDeleteChild,
    /* extension             */ NULL
   },
/* constraint */
   {
    /* subresourses       */   radioGroupConstraintsResources,
    /* subresource_count  */   XtNumber(radioGroupConstraintsResources),
    /* constraint_size    */   sizeof(RadioGroupConstraintsRec) ,
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL,
    /* extension          */   NULL,
   },
/* baseConst */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse		       */ XtInheritTraverse,
    /* traverseTo              */ XtInheritTraverseTo,
    /* traverseOut	       */ XtInheritTraverseOut,
    /* traverseInside          */ XtInheritTraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* MultiCol */
   {
    /* empty                   */ 0,
   },
/* RadioGroup */
   {
    /* empty                   */ 0 ,
   }
};

WidgetClass radioGroupWidgetClass = (WidgetClass) &radioGroupClassRec;

#define ForAllChildren(cw, child) \
        for ( (child) = (cw)->composite.children ; \
                (child) < ((cw)->composite.children + \
                (cw)->composite.num_children ) ; \
                (child)++ )


static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void ResolveInheritance(class)
WidgetClass class;
{
	RadioGroupWidgetClass c = (RadioGroupWidgetClass) class;
	RadioGroupWidgetClass super;
	static CompositeClassExtensionRec extension_rec = {
		NULL, NULLQUARK, XtCompositeExtensionVersion,
		sizeof(CompositeClassExtensionRec), True};
	CompositeClassExtensionRec *ext;

	ext = (XtPointer)XtMalloc(sizeof(*ext));
	*ext = extension_rec;
	ext->next_extension = c->composite_class.extension;
	c->composite_class.extension = ext;
}

static void InsertChild(child)
Widget child;
{
	if (XtIsSubclass(child , checkButtonWidgetClass))
	{
		constraintClassRec.composite_class.insert_child(child);
		XtAddCallback(child , XtNswitch , Switch , (XtPointer) XtParent(child));
	}
	else
	{
		XtWarning("Only CheckButtonWidget is allowed to insert to RadioGroupWidget");
	}
}

static void Switch(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	RadioGroupWidget cw = (RadioGroupWidget) client_data;
	Widget *child;
	Boolean _stat;

	XtVaGetValues(w , XtNon , &_stat , NULL);

	if (_stat)
	{
		ForAllChildren(cw, child)
		{
			if (w != *child)
			{
					CheckButtonReset(*child , False);
			}
		}
		XtCallCallbackList(w , cw->radioGroup.switch_it , w);
	}
}

Widget RadioGroupGetSelected(w)
Widget w;
{
	RadioGroupWidget cw = (RadioGroupWidget)w;
	Widget *child;
	Boolean _stat;

	ForAllChildren(cw, child)
	{
		XtVaGetValues(*child , XtNon , &_stat , NULL);
		if (_stat) return *child;
	}

	return NULL;
}

void RadioGroupSetSelected(w , id)
Widget w;
int id;
{
	RadioGroupWidget cw = (RadioGroupWidget)w;
	Widget *child;
	int _id;

	ForAllChildren(cw, child)
	{
		XtVaGetValues(*child , XtNid , &_id , NULL);
		if (_id == id) 
			XtVaSetValues(*child , XtNon , True , NULL);
		else
			XtVaSetValues(*child , XtNon , False , NULL);		
	}
}
