/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _PopTextP_H_
#define _PopTextP_H_

#include <X11/ShellP.h>
#include <Nws/PopText.h>

typedef struct {
	int	dummy;
} PopTextClassPart;

typedef struct _PopTextClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ShellClassPart		shell_class;
	OverrideShellClassPart	override_shell_class;
	PopTextClassPart	popText_class;
} PopTextClassRec;

extern PopTextClassRec popTextClassRec;

typedef struct _PopTextPart {
	/* public resources */
	char		* text;
	Pixel		foreground;
	XFontStruct	* font;
	int		spacing;
	/* private */
	GC		gc;
} PopTextPart;

typedef struct _PopTextRec {
	CorePart		core;
	CompositePart		composite;
	ShellPart		shell;
	OverrideShellPart	override;
	PopTextPart		popText;
} PopTextRec;

#endif
