/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xlib.h>

#include	<Nws/ComboP.h>
#include	<Nws/PulldownShellP.h>
#include	<Nws/ScrollListP.h>
#include	<Nws/Init.h>
#include	<Nws/misc.h>
#include	<Nws/utils.h>

#define offset(field) XtOffsetOf(ComboRec,combo.field)

static XtResource resources [] = {
	{
	 XtNhistory_length ,
         XtCHistory_length ,
         XtRInt ,
         sizeof(int) ,
         offset(history_length) ,
         XtRImmediate ,
         (XtPointer) 0
        },
        {
         XtNsave_history ,
         XtCSave_history ,
         XtRBoolean ,
         sizeof(Boolean) ,
         offset(save_history) ,
         XtRImmediate ,
         (XtPointer) False
        },
        {
         XtNspacing ,
         XtCSpacing ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(EntryLineRec , entryLine.spacing) ,
         XtRImmediate ,
         (XtPointer) 2
        }
};

static void PulldownList();
static void SetEntry();
static void PopdownShell();

static XtActionsRec shellaction [] = {
	{"closeshell" , PopdownShell}
};

static char shelltrtab [] = "\
	<Key>Escape: closeshell()\n";


static XtActionsRec action [] = {
	{"pulldown" , PulldownList},
	{"setentry" , SetEntry},
};

static char trans_tab [] = "\
	<FocusIn>: focusIn() draw_cursor()\n\
	<FocusOut>: focusOut() clear_cursor()\n\
	~Shift<Key>Tab: traverseForward()\n\
	Shift<Key>Tab: traverseBackward()\n\
	<Key>Up: setentry(previous)\n\
	~Shift<Key>Down: setentry(next)\n\
	Shift<Key>Down: pulldown()\n\
        <Key>Return: activate()\n\
       	<Key>Home: bol()\n\
	Ctrl<Key>E: eol()\n\
	<Key>End: eol()\n\
	Ctrl<Key>A: bol()\n\
	Ctrl<Key>Y: kill_line()\n\
	Ctrl<Key>K: kill_end()\n\
	<Key>Right: move_right()\n\
	<Key>Left: move_left()\n\
	<Key>BackSpace: delete_previous()\n\
	<Key>Delete: delete_next()\n\
	<Key>: insert_char() \n\
	<Btn1Down>: focusCurrent() selection_start() pulldown()\n\
	<Btn1Motion>: do_selection() \n\
	<Btn1Up>: selection_end()\n\
	<Btn2Down>: focusCurrent() insert_selection(CUT_BUFFER0) \n\
	<Btn3Down>: focusCurrent() \n\
	<Enter>: highlight() show_help() \n\
        <Leave>: unhighlight() hide_help() \n\
        ~Shift<Key>Tab: traverseForward()\n\
        Shift<Key>Tab: traverseBackward()\n\
        <FocusIn>: focusIn()\n\
        <FocusOut>: focusOut()\n\
        <BtnDown>: hide_help() \n\
        <KeyDown>: hide_help() \n\
        ";

static void ClassInitialize();
static void Initialize ();
static void Destroy ();
static void Redisplay ();
static Boolean SetValues ();
static void GetTextDimension ();

static void ChangeEntry();
static void PopdownCB();

ComboClassRec comboClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &entryLineClassRec,
    /* class_name            */ "Combo",
    /* widget_size           */ sizeof(ComboRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ False,
    /* compress_enterleave   */ False,
    /* visible_interest      */ FALSE,
    /* destroy               */ Destroy,
    /* resize                */ XtInheritResize,
    /* expose                */ Redisplay,
    /* set_values            */ (XtSetValuesFunc) SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ XtInheritHighlight,
    /* unhighlight	       */ XtInheritUnhighlight,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* entryLine */
   {
    /* get_text_dimension      */ GetTextDimension,
   },
/* combo */
   {
    /* empty		       */ 0
   }
};

WidgetClass comboWidgetClass = (WidgetClass) &comboClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ComboWidget cw = (ComboWidget) new_widget;

	cw->combo.pulldown = XtVaCreatePopupShell("_pulldownshell" , 
		pulldownShellWidgetClass , new_widget , NULL);

	XtAppAddActions(XtWidgetToApplicationContext(new_widget) , 
		shellaction , XtNumber(shellaction));

	XtAugmentTranslations(cw->combo.pulldown , XtParseTranslationTable(shelltrtab));

	XtAddCallback(cw->combo.pulldown , XtNpopdownCallback , 
		PopdownCB , (XtPointer) cw);	

	cw->combo.list = GetListWidget(XtVaCreateManagedWidget("slist" , 
		scrollListWidgetClass , cw->combo.pulldown , NULL));

	XtAddCallback(cw->combo.list , XtNselect_cb , 
		ChangeEntry , (XtPointer) cw);	

	cw->combo.active_arrow = False;
}

static void Destroy(w)
Widget w;
{
}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	ComboWidget cw = (ComboWidget) w;
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);
	Dimension width,height;
	Position x,y;

	((ComboWidgetClass)XtClass(w))->base_class.get_internal_dimension(w ,
		&x , &y , &width , &height);

	entryLineClassRec.core_class.expose(w,event,region);

	if (cw->combo.active_arrow)
		X_DrawSimple3DFrame(dpy , win , x + width - height , y ,
			height , height  , 1 , 
			cw->base.dark , cw->base.light);
	else
		X_DrawSimple3DFrame(dpy , win , x + width - height , y ,
			height , height , 1 , 
			cw->base.light , cw->base.dark);

	{
		XPoint triangel[3];

		triangel[0].x = x + width - height + 3;
		triangel[0].y = y + 3;
		triangel[1].x = x + width - 3;
		triangel[1].y = y + 3;
		triangel[2].x = x + width - height / 2;
		triangel[2].y = y + height - 3;

		XFillPolygon(dpy , win , cw->entryLine.normalGC , triangel ,
                        XtNumber(triangel),Convex,CoordModeOrigin);
	}

	if (!XtIsSensitive(w)) Xt_SetInsensitive(w);
}

#define WidgetValuesDiffer(w1,w2,component) (w1->combo.component != \
					     w2->combo.component)

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	Boolean redraw = False;

	return redraw;
}

static void GetTextDimension(w , x , y , width , height)
Widget w;
Position *x;
Position *y;
Dimension *width;
Dimension *height;
{
	entryLineClassRec.entryLine_class.get_text_dimension(w , x , y , width , height);

	*width -= *height + 1;
}

static void PulldownList(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ComboWidget cw = (ComboWidget) w;
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);
	Dimension width,height ,cwidth,
		dwidth = DisplayWidth(dpy,DefaultScreen(dpy)) ,
		dheight = DisplayHeight(dpy,DefaultScreen(dpy)) ;
	Position x,y;

	if (event->type == ButtonPress || event->type == ButtonRelease)
	{
		((ComboWidgetClass)XtClass(w))->base_class.get_internal_dimension(w ,
			&x , &y , &width , &height);
		cwidth = width;

		if (BETWEEN(event->xbutton.x , x + width - height , x + width) &&
		    BETWEEN(event->xbutton.y , y , y + height))
		{

			X_DrawSimple3DFrame(dpy , win , x + width - height ,
				y , height , height , 1 , 
				cw->base.dark , cw->base.light);
			cw->combo.active_arrow = True;

		} else return;
	}

	if (!XtIsRealized(cw->combo.pulldown))  XtRealizeWidget(cw->combo.pulldown);

	XtVaGetValues(cw->combo.pulldown , XtNwidth , &width , XtNheight , &height , NULL);

	XtTranslateCoords((Widget) cw , 0 , cw->core.height , &x ,&y);

	if ( (x + width) > dwidth ) x = dwidth - width;

	if ( (y + height ) > dheight ) y = y - cw->core.height - height;

	if ( y < 0 ) y = 0;

	XtVaSetValues(cw->combo.pulldown , XtNx , x , XtNy , y , 
		XtNwidth , cw->core.width , NULL);

	XtPopupSpringLoaded(cw->combo.pulldown);
}

static void SetEntry(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ComboWidget cw = (ComboWidget) w;

	if (*num_params != 1)
	{
		XtWarning("Action 'select' called with wrong parameters count");
		return;
	}

	XtCallActionProc(cw->combo.list , "select" , event , 
			params , 1);

}

static void ChangeEntry(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ListStruct *info = (ListStruct*) call_data;
	ComboWidget cw = (ComboWidget) client_data;

	EntryLineSetText((Widget)cw , info->label);

	XtPopdown(cw->combo.pulldown);
}

static void PopdownCB(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ComboWidget cw = (ComboWidget) client_data;
	Dimension width,height;
	Position x,y;


	((ComboWidgetClass)XtClass((Widget)cw))->base_class.get_internal_dimension(
		(Widget)cw , &x , &y , &width , &height);

	X_DrawSimple3DFrame(XtDisplay((Widget)cw) , XtWindow((Widget)cw) , 
		x + width - height , y , height , height , 1 , 
		cw->base.light , cw->base.dark);

	cw->combo.active_arrow = False;	
}

Widget ComboGetListWidget(w)
Widget w;
{
	return ((ComboWidget)w)->combo.list;
}

void ComboSetIndex(w , idx)
Widget w;
int idx;
{
	ListStruct *s;

	s = SetSelected(((ComboWidget)w)->combo.list , idx);
	if (s)
		EntryLineSetText(w , s->label);
}

int ComboGetIndex(w)
Widget w;
{
	ListStruct *s;
	
	s = ListGetSelected(((ComboWidget)w)->combo.list);

	if (s) return s->index;
	else return -1;
}

static void PopdownShell(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	XtPopdown(w);
}
