/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

#include <includes.h>
#include "password_dialog.h"

#ifdef USE_GTK
#include <gtk/gtk.h>
#include "xstuff.h"
#include "error_dialog.h"
#include "prefs_dialog/prefs_dialog.h"
#include "prefs_dialog/prefs_dialog_plugins_prefs.h"
#include "prefs_dialog/prefs_dialog_scan_opt.h"
#endif

#include "read_target_file.h"
#include "comm.h"
#include "auth.h"
#include "nessus.h"
#include "attack.h"
#include "report.h"
#include "parser.h"
#include "nsr_output.h"
#include "sighand.h"
#include "preferences.h"
#include "globals.h"
#include "corevers.h"
#include "nessus/getopt.h"

struct arglist * Plugins = NULL;
struct arglist * Scanners = NULL;
int PluginsNum;
int ScannersNum;
struct arglist * Hosts = NULL;
struct arglist * Prefs;
struct arglist * MainDialog;
struct arglist * ArgSock;
struct arglist * MonitorDialog;
char * Alt_rcfile = NULL;
int GlobalSocket;
char * stored_pwd = NULL;
int F_show_pixmaps;
int F_quiet_mode;
int F_nessusd_running;
int First_time = 0;

#ifndef USE_AF_INET      
#undef ENABLE_CRYPTO_LAYER
#endif

#ifdef ENABLE_CRYPTO_LAYER
#include "peks/peks.h"
#include <errno.h>
static unsigned keylen = NESSUS_SIGKEYLEN ;
static char        *kf = NESSUS_KEYFILE ;
static peks_key   *key = 0;

/* key file processing options ... */
static int chng_pph = 0, list_kdb = 0, first_login = 0 ;
static char *kill_key = 0 ;

#ifdef USE_GTK
/* choose gui authentication dialogue by default */
static char* (*auth_pwd) (int) = pass_dialog ;
#else
static char* (*auth_pwd) (int) = cmdline_pass;
#endif
/* for debugging */
extern int dump_send, dump_recv ;

#if _WIN32
static void
action_header
  (char *text)
{
  fprintf (stderr, "\
%s\n--------------------------------------------------------------------\n",
	   text);
}
#else
#define action_header(s) /* nothing */
#endif

static void
key_initialization_stuff 
  (void)
{
  int did_something = 0 ;

  if (chng_pph) { /* change pass phrase and exit */
    if ((key = peks_private_key (0, kf, get_pwd, keylen)) == 0) goto error ;
    ntconsole (10, 80, 0, 0);
    action_header ("Change pass phrase");
    if (!created_private_key () &&
	peks_save_private_key (0, key, kf, get_pwd) < 0) goto error ;
    did_something ++ ;
  }

  if (kill_key != 0) { /* delete entry */
    if (strchr (kill_key, '@') != 0) { /* syntax is: usr@host */
      if (peks_delete_userkey (kill_key, kf, get_pwd) < 0) goto error ;
    } else
      if (peks_delete_hostkey (kill_key, kf, get_pwd) < 0) goto error ;
    did_something ++ ;
  }

  if (list_kdb) { /* list key data base */
    if (key == 0 &&
        (key = peks_private_key (0, kf, get_pwd, keylen)) == 0) goto error ;
    ntconsole (40, 80, 10, 70);
    action_header ("Key data base");
    if (peks_list_keyfile (0, kf) < 0) goto error ;
    did_something ++ ;
  }
	
  if (did_something)
    exit (0);

  /* get your private key */
  if (key != 0 || (key = peks_private_key (0, kf, get_pwd, keylen)) != 0)
    return ;

  error:
# ifdef USE_GTK
  if(F_quiet_mode)
# endif    
    fprintf (stderr, "%s - aborting.\n", peks_strerr (errno));
# ifdef USE_GTK
  else {
    char * error = emalloc(40 + strlen(peks_strerr(errno)));
    sprintf(error, "%s - aborting.", peks_strerr(errno));
    show_error_and_wait(error);
    free(error);
  } 
# endif    
  exit (1);
}
#endif

void init_globals();

/* FIXME: patch for the latest log_write () update -- jordan */
void log_write (f, n) char *f; int n; {fprintf (stderr, f, n); }

/*
 * connect_to_nessusd
 *
 * This function establishes the connection between
 * nessus and nessusd, logs in and reads the plugin
 * list from the server.
 *
 */
char *
connect_to_nessusd(hostname, port, login, pass)
	char * hostname;
	int port;
	char * login;
	char * pass; /* is a cipher in case of the crypto layer */
{
  int soc;
  int sz = 4096;
#ifndef USE_AF_INET
  struct sockaddr_un address;
  char * name = AF_UNIX_PATH;
#endif
  init_globals();
  if(arg_get_type(Prefs, "nessusd_host")>=0)
   arg_set_value(Prefs, "nessusd_host", strlen(hostname), strdup(hostname));
  else
   arg_add_value(Prefs, "nessusd_host", ARG_STRING, strlen(hostname),
   		strdup(hostname));
   
#ifdef USE_AF_INET
  soc = open_sock_tcp_hn(hostname, port);
  if(soc<0)
  	{
  	struct in_addr a = nn_resolve(hostname);
  	if(!a.s_addr)return("Host not found !");
  	else
  	return("Could not open a connection to the remote host");
  	}
 
#else
  if((soc = socket(AF_UNIX, SOCK_STREAM,0))==-1){
  	perror("socket ");
  	exit(1);
  	}
  bzero(&address, sizeof(struct sockaddr_un));
  address.sun_family = AF_UNIX;
  bcopy(name, address.sun_path, strlen(name));
  if(connect(soc, &address, sizeof(address))==-1){
  	return("Could not open a connection to the remote host");
  	}
#endif  
  GlobalSocket = soc;
  ArgSock = emalloc(sizeof(struct arglist));
  arg_add_value(ArgSock, "global_socket", ARG_INT, -1, (void *)GlobalSocket);

#ifdef ENABLE_CRYPTO_LAYER
  if(pass != 0 && strcasecmp (pass, "none") != 0) { /* pass ::= cipher type */
    int n;

    /* we explicitely require the cipher protocol */
    if(comm_init (soc, CIPHER_PROTO_NAME))
      return "Remote host is not using " /* string concat */ CIPHER_PROTO_NAME;

    if (client_negotiate_session_key (pass, soc, hostname, NESSUS_KEYFILE) < 0)
      return peks_strerr(errno); /* < 0: error, or just a new server key */

    io_ctrl (soc, IO_RESIZE_BUF, (n=4096, &n), 0) ;   /* limit read buffer */
    io_ctrl (soc, IO_RESIZE_BUF, (n=4096, &n), 1) ;   /* set write buffer */
    io_ctrl (soc, IO_MAX_THREADS, (n=200, &n), 0) ;   /* num of channels */
    
    if (peks_client_authenticate 
	(NESSUS_AUTH_METH,	/* the signature method, 1 or 3 */
	 soc,			/* socket id */
	 login,			/* login name */
	 key,			/* signe with the private key */
	 auth_pwd) != 0) {	/* fall back passwd fn (if signature fails) */
      if (errno == EINTR)	/* did we get a (pseudo) alarm call ? */
	return "Timeout while waiting for the server to respond";
      if (errno)
	return peks_strerr (errno) ;
      return "Authentication failed";
    }
  } else

    /* so we are asked to try the insecure way */
    if(comm_init(soc,"< NTP/1.1 >\n") == 0) {
      if (pass == 0 || strcasecmp (pass, "none") == 0) {
	if (auth_login(login, 0) != 0)
	  goto wrong_protocol ;
      } else 
	/* still using public key authentication */
	if (peks_client_authenticate 
	    (NESSUS_AUTH_METH, soc, login, key, auth_pwd) != 0)
	  goto wrong_protocol ;
    } else
#else
      if(comm_init(soc,"< NTP/1.1 >\n") || (auth_login(login, pass)))
#endif /* ENABLE_CRYPTO_LAYER */
  	{
	wrong_protocol:
        shutdown(soc, 2);
  	return("Remote host is not using the good version of the Nessus communication protocol (1.1)");
        }
  if(comm_get_pluginlist())return("Login failed");
  if(!First_time){
  	comm_get_preferences(Prefs);
  	comm_get_rules(Prefs);
	}
  else
  	{
	/*
	 * Ignore the server preferences if we already logged in
	 */
	struct arglist * devnull = emalloc(sizeof(*devnull));
	comm_get_preferences(devnull);
	comm_get_rules(devnull);
	arg_free(devnull);
	}
  prefs_check_defaults(Prefs);
#ifdef USE_GTK
  prefs_plugins_reset(arg_get_value(MainDialog, "PLUGINS_PREFS"), Plugins,
   			Scanners);
#endif
#ifdef ENABLE_CRYPTO_LAYER
  {
    /* check whether the server enforces io channel tracking/debugging */
    struct arglist *spref = arg_get_value (Prefs, "SERVER_PREFS");
    if (arg_get_value (spref, "track_iothreads")) {
      int n = io_ctrl (soc, IO_MAX_THREADS, 0, 0) ;
      /* high water mark below top (which is the max number of threads) */
      io_ctrl (soc, IO_HWMBL_THREADS, (n /= 3, &n), 0); 
      /* enable dead channels negotiation trap */
      io_thtrp (soc,(int(*)(void*,unsigned long))-1,0,1); 
    }
  }
#endif /* ENABLE_CRYPTO_LAYER */ 	
#ifdef USE_GTK
  if(!F_quiet_mode)fill_scanner_list(arg_get_value(MainDialog, "SCAN_OPTIONS"));
#endif	
  
  return(NULL);
}

/*
 * init_globals
 *
 * initializes two main global variables : plugins and
 * hosts
 *
 */
void 
init_globals()
{
  if(!Plugins)Plugins = emalloc(sizeof(struct arglist));
  if(!Scanners)Scanners = emalloc(sizeof(struct arglist));
  Hosts = emalloc(sizeof(struct arglist));
}


void 
display_help 
  (char *pname)
{
  
#ifdef ENABLE_CRYPTO_LAYER /* => USE_AF_INET */
  ntconsole (40, 100, 30, 80);
 printf ("\n\
Usage: %s [options] "
#ifdef USE_GTK
	 "["
#endif
	 "SERVER PORT LOGIN TRG RESULT"
#ifdef USE_GTK
	 "]"
#endif
	 "\n", pname);  printf ("\n\
Options:\n\
  -v, --version                       display version number and exit\n");
#ifdef USE_GTK
printf ("\
  -n, --no-pixmaps                    does not display any pixmaps\n\
  -r, --open-report                   open-report file in the gui\n\
  -c, --config-file                   use another configuration file\n");
#endif
printf ("\
  -h, --help                          show this help text\n\
  -k LENGTH, --set-key-length=LENGTH  set the min key length (default %u)\n",
	NESSUS_SIGKEYLEN); printf ("\
  -C, --change-pass-phrase            interactively change the pass phrase\n\
                                      for the private key\n\
  -L, --list-keys                     list all keys in the data base\n\
  -K KEY, --delete-key=KEY            delete a particular key from the\n\
                                      key data base\n\
  -q, --batch-mode                    "
#ifdef USE_GTK
                                     "force an error if there is no\n\
                                      argument list, given"
#else
                                     "ignored (compatibiltity mode, only)"
#endif
"\n\
Argument list:\n\
  SERVER PORT LOGIN TRG RESULT\n\
    |     |    |     |   |\n\
    |     |    |     |   +-- file name where nessus stores the results, in\n\
    |     |    |     +------ file name containing the target host adresses\n\
    |     |    +------------ the nessusd login name\n\
    |     +----------------- the port, nessusd listens on\n\
    +----------------------- the host address, nessusd runs on\n\
\n"
#ifdef USE_GTK
"\
  If an argument list is given, all tests are run silently without gui\n\
  support.  "
#endif
  "Results are printed when the tests are done.\n");

#else /* standard version */
 printf("%s, version %s\n", pname, NESSUS_VERSION);
#ifdef USE_AF_INET
 printf("\nusage : %s [-vnh] [-c .rcfile] [-q <args>]\n\n",pname);
#endif
 printf("\nusage : %s [-vnh] [-q <args>]\n\n",pname);
 printf("\tv : shows version number\n");
 printf("\th : shows this help\n"); 
 printf("\tn : No pixmaps\n");
 printf("\tq : quiet mode : nessus performs the test without displaying anything\n");
 printf("\t    to the screen.\n\n");
 printf("\tThe quiet mode arguments are :\n");
#ifdef USE_AF_INET
 printf("\t\thost     : nessusd host\n");
 printf("\t\tport     : nessusd host port\n");
#endif
 printf("\t\tuser     : user name\n");
 printf("\t\ttargets  : file containing the list of targets\n");
 printf("\t\tresult   : name of the file where \n\t\t\t   nessus will store the results\n");
#endif /* standard version */
}
 
 
int main(int argc, char * argv[])
{
  int i, xac;
  char *myself, **xav;
  int gui = 1;
  if ((myself = strrchr (*argv, '/')) == 0
#ifdef _WIN32
      && (myself = strrchr (*argv, '\\')) == 0
#endif
      ) myself = *argv ;
  else
    myself ++ ;

#ifndef DEBUG
  signal(SIGSEGV , sighand_sigsegv);
#endif

  PluginsNum = 0;
  ScannersNum = 0;
  Scanners = Plugins = MainDialog = NULL;
  ArgSock = NULL;
  GlobalSocket = -1;
#ifdef USE_GTK
  F_quiet_mode = 0;
  F_show_pixmaps = 1;
#endif

  /* provide a extra acrgc/argv vector for later use */
  xac = 1;
  xav = append_argv (0, myself);
  pty_logger ((void(*)(const char*, ...))printf);

  for (;;) {
    int this_option_optind = optind ? optind : 1;
    int option_index = 0;
    static struct option long_options[] =
    {
      {"help",                 no_argument, 0, 'h'},
      {"version",              no_argument, 0, 'v'},
      {"delete-key",     required_argument, 0, 'K'},
      {"list-keys",            no_argument, 0, 'L'},
      {"change-pass-phrase",   no_argument, 0, 'C'},
      {"set-key-length", required_argument, 0, 'k'},   
#ifdef USE_GTK
      {"open-report",    required_argument, 0, 'r'},   
      {"no-pixmap",            no_argument, 0, 'n'},
#endif
      {"batch-mode",           no_argument, 0, 'q'},
      {"config-file",		required_argument, 0, 'c'},
      {0, 0, 0, 0}
    };

    if ((i = getopt_long 
	 (argc, argv, "c:vhqnk:?CLK:r:01", long_options, &option_index)) == EOF)
      break;
     else
      
    switch(i) {
     case 'c' :
       Alt_rcfile = estrdup(optarg);
       break;
#ifdef USE_GTK
    case 'n' : 
      F_show_pixmaps = 0;
      break;

    case 'r' : 
      xac ++ ;
      xav = append_argv (xav, optarg) ;
      break;
#endif    	

    case 'v' :
    	printf("nessus (%s) %s for %s\n\n(C) 1998-1999 Renaud Deraison <deraison@nessus.org>\n", 
    			PROGNAME,NESSUS_VERSION, NESS_OS_NAME);
#ifdef ENABLE_CRYPTO_LAYER
	printf("\tsupports crypto layer version %s\n", peks_version ());
#endif
	printf ("\n");
    	exit(0);
    	break;

#ifdef ENABLE_CRYPTO_LAYER
#ifdef DEBUG
   case '1' :
     dump_send = 1;
     break;
   case '0' :
     dump_recv = 1;
     break;
#endif

   case 'K' :
     gui = 0;
     kill_key = estrdup (optarg) ;
     break;

   case 'L' :
     gui = 0;
     list_kdb++;
     break;

   case 'C' :
     gui = 0;
     chng_pph++;
     break;

   case 'k' :
     gui = 0; 
     if ((keylen = atoi (optarg)) >= NESSUS_MINKEYLEN)
       break;
     fprintf (stderr, "%s : Key lengths smaller than %u are unsupported!\n", 
	      myself, NESSUS_MINKEYLEN);
     exit (1) ;
#endif /* ENABLE_CRYPTO_LAYER */

    case 'q' :
      gui = 0; 
      F_quiet_mode ++ ;
      break;

    default:
      display_help (myself);
      exit (0);
    }
  }

 if(!gui)F_quiet_mode = 1;
#ifdef ENABLE_CRYPTO_LAYER
 if(argc>optind || F_quiet_mode)
     {
      auth_pwd = cmdline_pass;
      F_quiet_mode = 1;
     }
#ifdef USE_GTK     
  else
      init_display (NULL, 0);
#endif      
      
  key_initialization_stuff ();
#endif

  
  /* system environment set up */
  preferences_init(&Prefs);

  /* do we run in batchmode ? */
  if (argc > optind || F_quiet_mode) {
    char *username, *target, *fname, *err, *cipher = "";
#ifdef USE_AF_INET      
    char *nessusd_host, *port;
#endif
    F_quiet_mode = 1;

#ifdef ENABLE_CRYPTO_LAYER
    cipher = "twofish/ripemd160:3";
    auth_pwd = cmdline_pass ; /* no gui, available */
    /* implies ENABLE_CRYPTO_LAYER */
#   define NUM_ARGS 5       
#else
    /* with, or without ENABLE_CRYPTO_LAYER */
#   define NUM_ARGS 6
#endif
#ifndef USE_AF_INET
#   undef  NUM_ARGS
#   define NUM_ARGS 3
#endif

    if (argc - optind != NUM_ARGS) {
      display_help(myself);
      exit(0);
    }

    /* next arguments: SERVER PORT */
#ifdef USE_AF_INET
    nessusd_host = argv[inc_optind()];
    port = argv[inc_optind()];
#else
    nessusd_host = "localhost";
    port = 1;
#endif

    /* next argument: LOGIN */
    username = argv[inc_optind()];

    /* next argument: PASSWORD */
#ifndef ENABLE_CRYPTO_LAYER
    cipher = argv[inc_optind()];
#endif	

    /* next argument: TARGET_FILE */
    if ((target = target_file_to_list(argv[inc_optind()])) == 0)
      exit(1);

    /* next argument: RESULTS_FILE */
    fname = argv[inc_optind()];

    /* login now */
    if((err = connect_to_nessusd
	(nessusd_host, atoi(port), username, cipher))) {
      fprintf(stderr, "%s : %s\n", myself, err);
      exit(0);
    }
	
    /* start attack */
    {
      int type, finished = 0;
      char buf [4096], msg [4096];

      attack_host(target, Prefs);
      Hosts = emalloc(sizeof(struct arglist));   
      
      while(!finished){
	network_gets(buf, 4095);
	buf[strlen(buf)-1]=0;
	if((type = parse_server_message(buf, Hosts, msg))==MSG_BYE)
	  finished = 1;
	bzero(msg, 4095);
      }

    }

    /* store results */
    arglist_to_file(Hosts, fname);

    /* end, exit */
    exit(0);
  }
 
  F_nessusd_running = 0;
  
  /*
   * Set up the main window
   */

#ifdef USE_GTK
  
  prefs_dialog_setup (NULL, Prefs);
 
  /*
   * all the options have been taken in account... Now, the user
   * may want us to open a previously saved file
   */
  
  for (i = 1; i < xac; i ++) {
    struct arglist * h = emalloc(sizeof(struct arglist));
    file_to_arglist (h, xav [i]);
    if(!Hosts) 
      Hosts = h;
    report_tests (h);
   } 

  gtk_main();
  shutdown(GlobalSocket,2);
  close_display();
  return(0);

#else
  printf("\nOoops ...\n\
  This nessus version has no gui support.  You need to give nessus the
  arguments SERVER PORT LOGIN TRG RESULT as explained in more detail
  using the --help option.\n");
  exit (1);
#endif
}

#ifdef NESSUSNT
int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst,
    		   LPSTR lpszArgs, int nWinMode)
{
/*
 * Initialize WinSock and jump into the regular 'main'
 */
  WSADATA winSockData;
  WSAStartup(0x0101, &winSockData);
  main(__argc, __argv);
  WSACleanup();
  return 0;
}
 
#endif
