/*
	flush.c - animate flush

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

extern void myevent();

void FlushColors()
{
int i,j,k;
dword r,g,b;

	k = gim.subImageList->mapsize;

	/* 383 is adequately number */
	for(j = 383; j > 0; j -= app_data.flushSteps){

		for(i=0;i<k;i++){
			r =(dword)((int)xcolors[i].red   * j / 255); if(r >= 0x10000) r=0xffff;
			g =(dword)((int)xcolors[i].green * j / 255); if(g >= 0x10000) g=0xffff;
			b =(dword)((int)xcolors[i].blue  * j / 255); if(b >= 0x10000) b=0xffff;
			fcolors[i].red	=(word)r;
			fcolors[i].green=(word)g;
			fcolors[i].blue =(word)b;
			fcolors[i].flags=xcolors[i].flags;
			fcolors[i].pixel=xcolors[i].pixel;
		}
		StoreColors(fcolors,gim.subImageList->mapsize);
		myusleep(app_data.flushTicks);
		if(gotSomeAction == True)
			return;
	}

}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xflushshow(char *fname)	/* Flush in,Flush out */
#else
ActionStatus xflushshow(fname)
char *fname;
#endif
{
int i;

	PreDisplay();

	if(app_data.showFileName)
		createFileNameWindow(fname);

	ShowImage(	(windowWidth - gim.subImageList->width) / 2,
				(windowHeight - gim.subImageList->height) / 2,
				gim.subImageList->width, gim.subImageList->height);

	if(app_data.showFileName)
		raiseFileNameWindow();

	for(i = 0; i < app_data.flushCount; i++)
		FlushColors(False);

	if(app_data.showFileName)
		removeFileNameWindow();

	return(mynowait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxflushshow(char *fname) 
#else
void postxflushshow(fname) 
char *fname;
#endif
{
	/* No post action */ ;
}

