/*
	comm.c - communication with xslideshow-control

	Author:	 Susumu Shiohara (shiohara@tpp.epson.co.jp)

			Copyright 1993-1997 by Susumu Shiohara

					All Rights Reserved

*/

#include "xslideshow.h"
#include "comm.h"
#include "comm-control.h"

extern char **file_listp;
extern int   *file_list_idxp;
extern int    file_list_count;
extern int    file_list_cur_count;

char setFileName[MAX_TEXT_LEN*4];
char setFilePath[MAX_TEXT_LEN*4];
char tmpStringBuf[MAX_TEXT_LEN*4];
char animMode[64];
static int text_len;

/* Find a window which has XA_XSLIDESHOWCONTROL property */
#if defined(__STDC__) || defined(__cplusplus)
static Window find_xslideshowcontrol_window(Display *display, Window top_window)
#else
static Window find_xslideshowcontrol_window(display, top_window)
Display *display;
Window	top_window;
#endif
{
int i;
Atom actual_type_return;
int actual_format_return;
dword nitems_return, bytes_after_return;
byte *prop_return;
unsigned int nchildren_return;
Window found_window = 0, dummy_window, *children_return;

	XA_XSLIDESHOWCONTROL = XInternAtom(display, AtomXslideshowControl, False);

	if ((XGetWindowProperty(
			display,
			top_window, 
			XA_XSLIDESHOWCONTROL,	/* property */
			0,		/* long_offset */
			1,		/* long_length */
			False,		/* remove */
			XA_WINDOW,	/* req_type */
			&actual_type_return,
			&actual_format_return,
			&nitems_return,
			&bytes_after_return,
			&prop_return))
		 == Success && actual_type_return == XA_WINDOW)
		return(top_window);

	if (! XQueryTree(display, top_window,
		&dummy_window, &dummy_window,
		&children_return, &nchildren_return))
		return (0);

	for (i = 0; i < (int)nchildren_return; i++)
		if ((found_window = find_xslideshowcontrol_window(display, children_return[i])))
			break;

	if (children_return)
		XFree((char *)children_return);

	return(found_window);
}


/* Send client_message to the xslideshowcontrol */
#if defined(__STDC__) || defined(__cplusplus)
void sendFileList(char *DisplayName)
#else
void sendFileList(DisplayName)
char *DisplayName;
#endif
{
Display *display;
Window found_window = 0;
Window dummy_window, *children_return;
unsigned int nchildren_return;
XClientMessageEvent event;
int i, sendlen;
char *sendBufp, sendBuf[MAX_TEXT_LEN];

	if(file_list_count == 0)
		return;

	/* Open remote display */
	display = XOpenDisplay(DisplayName);
	if(display == NULL) {
		fprintf(stderr,"Connection Failed %s",DisplayName);
		return;
	}

	/* Find xslideshow-control window */
	if( !XQueryTree(display,
		RootWindowOfScreen(DefaultScreenOfDisplay(display)),
		&dummy_window, &dummy_window,
		&children_return, &nchildren_return) )
		return;

	for (i = 0; i < (int)nchildren_return; i++)
		if((found_window = find_xslideshowcontrol_window( display, children_return[i] )))
			break;

	if ( ! found_window ) {
		fprintf(stderr, "No xslideshow-control is running on display %s\n",
			DisplayString(display));
		return;
	}


	/* Send file list srtings */
	event.display = display;
	event.window = found_window;
	event.type = ClientMessage;
	event.format = 32;
	event.message_type = XInternAtom(display, AtomXslideshowControlNfiles, False);
	event.data.l[0] = (long)file_list_count;
	if ( !XSendEvent ( display, found_window, True, 0L, (XEvent *)&event) ) {
		fprintf (stderr,
			"xslideshow: XSendEvent(display, 0x%x ...) failed.\n",
			(int) found_window);
		exit(1);
	}

	event.display = display;
	event.window = found_window;
	event.type = ClientMessage;
	event.format = 8;
	event.message_type = XInternAtom(display, AtomXslideshowControlFlist, False);

	for(i=0; i<file_list_count; i++) {
		if(file_listp[file_list_idxp[i]] != NULL)
			sprintf(sendBuf ,"%s\n", file_listp[file_list_idxp[i]]);
		else
			strcpy(sendBuf,"(removed)\n");

		sendBufp = sendBuf;
		sendlen = strlen(sendBuf);

		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"%s",sendBufp);

		while(sendlen > 0){
			strncpy(event.data.b, sendBufp, 19);
			event.data.b[19] = '\0';
			if ( !XSendEvent ( display, found_window, True, 0L, (XEvent *)&event) ) {
				fprintf (stderr,
					"xslideshow: XSendEvent(display, 0x%x ...) failed.\n",
					(int) found_window);
				exit(1);
			}
			sendlen -= 19;
			sendBufp += 19;
		}
	}
	
	event.display = display;
	event.window = found_window;
	event.type = ClientMessage;
	event.format = 32;
	event.message_type = XInternAtom(display, AtomXslideshowControlFlistEnd, False);
	event.data.l[0] = (long)file_list_cur_count;
	if ( !XSendEvent ( display, found_window, True, 0L, (XEvent *)&event) ) {
		fprintf (stderr,
			"xslideshow: XSendEvent(display, 0x%x ...) failed.\n",
			(int) found_window);
		exit(1);
	}

	if(DisplayName[0] != 0)
		XCloseDisplay(display);
}

#if defined(__STDC__) || defined(__cplusplus)
void MessageHandler(Widget w, caddr_t client_data, XEvent *event)
#else
void MessageHandler(w, client_data, event)
Widget w;
caddr_t client_data;
XEvent *event;
#endif
{
	if(event->type == ClientMessage){
		/* xclient.message_type is Atom, so do not use
			switch(xclient.message_type) */

		if(event->xclient.message_type == XA_XSLIDESHOWCOMMCONTROL){

			switch((int)event->xclient.data.l[0]){

			case CB_PAUSE:
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: action = pause\n");
				if(pauseToggle == 0){
					pauseToggle = 1;
					ACT_PAUSE_ON(click);
				}
				else {
					pauseToggle = 0;
					ACT_PAUSE_OFF(click);
				}
				break;

			case CB_HEAD:
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: action = head\n");
				ACT_SLEEP_OFF(click);
				ACT_PAUSE_OFF(click);
				ACT_TAIL_OFF(click);
				ACT_HEAD_ON(click);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_PREV:
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: action = prev\n");
				ACT_SLEEP_OFF(click);
				ACT_PAUSE_OFF(click);
				ACT_NEXT_OFF(click);
				ACT_PREV_ON(click);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_STOP:
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: action = stop\n");
				exit(0);
				break;

			case CB_NEXT:
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: action = next\n");
				ACT_SLEEP_OFF(click);
				ACT_PAUSE_OFF(click);
				ACT_PREV_OFF(click);
				ACT_NEXT_ON(click);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_TAIL:
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: action = tail\n");
				ACT_SLEEP_OFF(click);
				ACT_PAUSE_OFF(click);
				ACT_HEAD_OFF(click);
				ACT_TAIL_ON(click);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_SLIDE:
				strcpy(animMode, "slide");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_FADE:
				strcpy(animMode, "fade");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_REVERSE:
				strcpy(animMode, "reverse");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_MONOTONE:
				strcpy(animMode, "monotone");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_FLUSH:
				strcpy(animMode, "flush");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_WIPE:
				strcpy(animMode, "wipe");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_WIPE24:
				strcpy(animMode, "wipe24");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_BLOCK:
				strcpy(animMode, "block");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_BLOCK24:
				strcpy(animMode, "block24");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_MOSAIC:
				strcpy(animMode, "mosaic");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_COLORANIM:
				strcpy(animMode, "coloranim");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_COLORANIM2:
				strcpy(animMode, "coloranim2");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_SHUFFLE:
				strcpy(animMode, "shuffle");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_PUZZLE:
				strcpy(animMode, "puzzle");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_SLIT:
				strcpy(animMode, "slit");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_TRANSPARENT:
				strcpy(animMode, "transparent");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_MOVE:
				strcpy(animMode, "move");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_FLOAT24:
				strcpy(animMode, "float24");
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			case CB_DEFAULT:
				animMode[0] = 0;
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: animate = %s\n",animMode);
				if(app_data.forceChange)
					gotSomeAction = True;
				break;

			default:
				break;
			}


		}else if(event->xclient.message_type == XA_XSLIDESHOW_INT){

			app_data.intervalTime = event->xclient.data.l[0];
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"xslideshow: intervalTime = %d\n",(int)app_data.intervalTime);

		}else if(event->xclient.message_type == XA_XSLIDESHOW_TEXT_START){

			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"xslideshow: start of text data\n");
			text_len = 0;

		}else if(event->xclient.message_type == XA_XSLIDESHOW_TEXT_END){

			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"xslideshow: end of text data\n");
			tmpStringBuf[text_len] = '\0';
			text_len = 0;

			if(event->xclient.data.l[0] == MSG_SETPATHDIR){
				strcpy(setFilePath, tmpStringBuf);
				if(app_data.verbose)
					fprintf(stderr,"xslideshow: New File Path = %s\n",setFilePath);
				if(app_data.forceChange)
					gotSomeAction = True;
			}
			else if(event->xclient.data.l[0] == MSG_SETCURFILE){
				strcpy(setFileName, tmpStringBuf);
				if(app_data.verbose)
					fprintf(stderr,"xslideshow: Selected File Name = %s\n",setFileName);
				ACT_SLEEP_OFF(click);
				ACT_PAUSE_OFF(click);
				if(app_data.forceChange)
					gotSomeAction = True;
			}
			else if(event->xclient.data.l[0] == MSG_REQFLIST){
				if(app_data.verbose)
					fprintf(stderr,"xslideshow: Request File List form %s\n",tmpStringBuf);
				sendFileList(tmpStringBuf);
			}

		}else if(event->xclient.message_type == XA_XSLIDESHOW_TEXT){

			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"xslideshow: text data\n");

			{
			int i;
				for(i=0; i<20; i++){
					if(event->xclient.data.b[i] == '\0') break;
					if(text_len >= (int)sizeof(tmpStringBuf)){
						tmpStringBuf[text_len-1] = 0;
						break;
					}
					tmpStringBuf[text_len++] = event->xclient.data.b[i];
				}
			}
		}
	}
}

#if defined(__STDC__) || defined(__cplusplus)
void initComm(Widget toplevel, Display *theDisp, Window theWindow)
#else
void initComm(toplevel, theDisp, theWindow)
Widget toplevel;
Display *theDisp;
Window theWindow;
#endif
{
	XtAddEventHandler(toplevel, NoEventMask, TRUE,
				(XtEventHandler)MessageHandler, (XtPointer)NULL);


	/* Create XSLIDESHOW Atoms */
	XA_XSLIDESHOW            = XInternAtom( theDisp, AtomXslideshow, False);
	XA_XSLIDESHOW_INT        = XInternAtom( theDisp, AtomXslideshowInt, False);
	XA_XSLIDESHOW_TEXT       = XInternAtom( theDisp, AtomXslideshowText, False);
	XA_XSLIDESHOW_TEXT_START = XInternAtom( theDisp, AtomXslideshowTextStart, False);
	XA_XSLIDESHOW_TEXT_END   = XInternAtom( theDisp, AtomXslideshowTextEnd, False);
	XA_XSLIDESHOWCOMMCONTROL = XInternAtom( theDisp, AtomXslideshowCommControl, False);

	text_len = 0;
	setFilePath[text_len] = 0;
	setFileName[text_len] = 0;

	XChangeProperty( theDisp, theWindow,
			XA_XSLIDESHOW, XA_WINDOW, 32,
			PropModeReplace, NULL, 0);

}

