/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
*/
package gov.nasa.worldwind.servers.wms;

import java.util.Iterator;

/**
 *
 * @author brownrigg
 * @version $Id: MapRegistry.java 4675 2008-03-12 19:36:36Z rick $
 */
public interface MapRegistry {
    
    public MapSource getNamedMapSource(String name);
    
    public boolean doesNamedMapSourceExist(String name);
    
    public void addMapSource(MapSource mapSource);

    public void addNamedMapSource(MapSource mapSource);
    
    public Iterator<MapSource> getAllMapSources();
    
    public Iterator<String> getMapNames();
  
}
