/*
 * SampleCanvas - OpenGL/GE3D sample canvas
 *
 * created: mpichler, 19960923
 *
 * changed: mpichler, 19970124
 *
 * $Id: SampleCanvas.java,v 1.4 1997/03/10 14:22:35 mpichler Exp $
 */


package iicm.ge3dsample;

import iicm.ge3d.*;

import java.awt.*;


/**
 * SampleCanvas - Canvas for GE3DSample
 * Copyright (c) 1996, 1997 IICM
 *
 * @author Michael Pichler
 * @version 0.3, changed: 24 Jan 97
 */


public class SampleCanvas extends OGLCanvas
{
  private boolean firstdraw = true;
  private long otherdata;


  public SampleCanvas (String title)
  {
    super (title);
  }

  /**
   * 3D drawings
   */

  public void paint (Graphics gc)
  {
    super.paint (gc);  // create context on first draw

    if (!hasContext () || !setContext (false))  // shading flag (Mesa backbuffer method)
    {
      // context could not be extablished (propably native library not loaded)
      // you may give some message or exit here
      Dimension dim = size ();
      gc.setColor (getBackground());
      gc.fillRect (0, 0, dim.width, dim.height);
      return;
    }

    // here we are ready to draw with GE3D

    if (firstdraw)
    {
      firstdraw = false;
      GE3D.initGE3D ();
    }

    // your 3D drawing goes here
    GE3D.setDrawMode (GE3D.ge3d_flat_shading);
    GE3D.setBackgroundColor (Color.gray.getRGB ());
    GE3D.clearScreen ();
    GE3D.simpleOrthoCamera (cwidth, cheight);
    GE3D.lineColorRGBi (Color.green.getRGB ());
    float x = cwidth / 2;
    float y = cheight / 2;
    GE3D.drawLine2D (-x, -y, x, y);  // LB to RT
    GE3D.lineColorRGBi (Color.cyan.getRGB ());
    GE3D.drawLine2D (-x, y, x, -y);  // LT to BR


    // finish drawing
    swapBuffers ();

  } // paint

} // SampleCanvas
