/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    Rectangle bounds;
    int resizeCursor;
    int clientCursor;
    int cursorOrientation = 0;
    boolean inEvent = false;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n) {
        super(composite, Tracker.checkStyle(n));
        this.parent = composite;
    }

    public Tracker(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n);
        this.display = display;
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    Point adjustMoveCursor() {
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y;
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pOINT);
        }
        OS.SetCursorPos(pOINT.x, pOINT.y);
        return new Point(pOINT.x, pOINT.y);
    }

    Point adjustResizeCursor() {
        int n = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n2 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pOINT);
        }
        OS.SetCursorPos(pOINT.x, pOINT.y);
        if (this.clientCursor == 0) {
            int n3 = 0;
            switch (this.cursorOrientation) {
                case 128: {
                    n3 = OS.LoadCursor(0, 32645);
                    break;
                }
                case 1024: {
                    n3 = OS.LoadCursor(0, 32645);
                    break;
                }
                case 16384: {
                    n3 = OS.LoadCursor(0, 32644);
                    break;
                }
                case 131072: {
                    n3 = OS.LoadCursor(0, 32644);
                    break;
                }
                case 16512: {
                    n3 = OS.LoadCursor(0, 32642);
                    break;
                }
                case 132096: {
                    n3 = OS.LoadCursor(0, 32642);
                    break;
                }
                case 17408: {
                    n3 = OS.LoadCursor(0, 32643);
                    break;
                }
                case 131200: {
                    n3 = OS.LoadCursor(0, 32643);
                    break;
                }
                default: {
                    n3 = OS.LoadCursor(0, 32646);
                }
            }
            OS.SetCursor(n3);
            if (this.resizeCursor != 0) {
                OS.DestroyCursor(this.resizeCursor);
            }
            this.resizeCursor = n3;
        }
        return new Point(pOINT.x, pOINT.y);
    }

    static int checkStyle(int n) {
        if ((n & 0x24480) == 0) {
            n |= 0x24480;
        }
        return n;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        int n = this.rectangles[0].x;
        int n2 = this.rectangles[0].y;
        int n3 = this.rectangles[0].x + this.rectangles[0].width;
        int n4 = this.rectangles[0].y + this.rectangles[0].height;
        int n5 = 1;
        while (n5 < this.rectangles.length) {
            int n6;
            int n7;
            if (this.rectangles[n5].x < n) {
                n = this.rectangles[n5].x;
            }
            if (this.rectangles[n5].y < n2) {
                n2 = this.rectangles[n5].y;
            }
            if ((n7 = this.rectangles[n5].x + this.rectangles[n5].width) > n3) {
                n3 = n7;
            }
            if ((n6 = this.rectangles[n5].y + this.rectangles[n5].height) > n4) {
                n4 = n6;
            }
            ++n5;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        int n = 0;
        while (n < rectangleArray.length) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (this.bounds.width != 0) {
                n2 = (rectangleArray[n].x - this.bounds.x) * 100 / this.bounds.width;
                n4 = rectangleArray[n].width * 100 / this.bounds.width;
            } else {
                n4 = 100;
            }
            if (this.bounds.height != 0) {
                n3 = (rectangleArray[n].y - this.bounds.y) * 100 / this.bounds.height;
                n5 = rectangleArray[n].height * 100 / this.bounds.height;
            } else {
                n5 = 100;
            }
            rectangleArray2[n] = new Rectangle(n2, n3, n4, n5);
            ++n;
        }
        return rectangleArray2;
    }

    void drawRectangles(Rectangle[] rectangleArray, boolean bl) {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            Shell shell = this.parent.getShell();
            shell.update(true);
        } else {
            this.display.update();
        }
        int n = 1;
        int n2 = OS.GetDesktopWindow();
        if (this.parent != null) {
            n2 = this.parent.handle;
        }
        int n3 = OS.GetDCEx(n2, 0, 2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            n = 3;
            byte[] byArray = new byte[16];
            byArray[0] = -86;
            byArray[2] = 85;
            byArray[4] = -86;
            byArray[6] = 85;
            byArray[8] = -86;
            byArray[10] = 85;
            byArray[12] = -86;
            byArray[14] = 85;
            byte[] byArray2 = byArray;
            n4 = OS.CreateBitmap(8, 8, 1, 1, byArray2);
            n5 = OS.CreatePatternBrush(n4);
            n6 = OS.SelectObject(n3, n5);
        }
        int n7 = 0;
        while (n7 < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n7];
            OS.PatBlt(n3, rectangle.x, rectangle.y, rectangle.width, n, 5898313);
            OS.PatBlt(n3, rectangle.x, rectangle.y + n, n, rectangle.height - n * 2, 5898313);
            OS.PatBlt(n3, rectangle.x + rectangle.width - n, rectangle.y + n, n, rectangle.height - n * 2, 5898313);
            OS.PatBlt(n3, rectangle.x, rectangle.y + rectangle.height - n, rectangle.width, n, 5898313);
            ++n7;
        }
        if (bl) {
            OS.SelectObject(n3, n6);
            OS.DeleteObject(n5);
            OS.DeleteObject(n4);
        }
        OS.ReleaseDC(n2, n3);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        int n = 0;
        if (this.rectangles != null) {
            n = this.rectangles.length;
        }
        Rectangle[] rectangleArray = new Rectangle[n];
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = this.rectangles[n2];
            rectangleArray[n2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n2;
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int n, int n2) {
        if (n < 0 && (this.style & 0x4000) == 0) {
            n = 0;
        }
        if (n > 0 && (this.style & 0x20000) == 0) {
            n = 0;
        }
        if (n2 < 0 && (this.style & 0x80) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x400) == 0) {
            n2 = 0;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        this.bounds.x += n;
        this.bounds.y += n2;
        int n3 = 0;
        while (n3 < this.rectangles.length) {
            this.rectangles[n3].x += n;
            this.rectangles[n3].y += n2;
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean open() {
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        var1_1 = false;
        this.tracking = true;
        var2_2 = new Event();
        var3_3 = new MSG();
        var4_4 = this.parent != null && (this.parent.style & 0x8000000) != 0;
        var5_5 = this.style & 1152;
        if (var5_5 == 128 || var5_5 == 1024) {
            this.cursorOrientation |= var5_5;
        }
        if ((var6_6 = this.style & 147456) == 16384 || var6_6 == 131072) {
            this.cursorOrientation |= var6_6;
        }
        var7_7 = 0;
        var8_8 = null;
        v0 = var9_9 = OS.GetKeyState(1) < 0;
        if (!var9_9) {
            var10_10 = OS.GetSystemMetrics(0);
            var11_12 = OS.GetSystemMetrics(1);
            var7_7 = OS.CreateWindowEx(32, this.display.windowClass, null, -1879048192, 0, 0, var10_10, var11_12, 0, 0, OS.GetModuleHandle(null), null);
            var12_15 = OS.GetWindowLong(var7_7, -4);
            var13_16 = new Object(){

                public int windowProc(int n, int n2, int n3, int n4) {
                    switch (n2) {
                        case 132: {
                            if (!Tracker.this.inEvent) break;
                            return -1;
                        }
                        case 32: {
                            if (Tracker.this.clientCursor != 0) {
                                OS.SetCursor(Tracker.this.clientCursor);
                                return 1;
                            }
                            if (Tracker.this.resizeCursor == 0) break;
                            OS.SetCursor(Tracker.this.resizeCursor);
                            return 1;
                        }
                    }
                    return OS.CallWindowProc(var12_15, n, n2, n3, n4);
                }
            };
            var8_8 = new Callback(var13_16, "windowProc", 4);
            OS.SetWindowLong(var7_7, -4, var8_8.getAddress());
        }
        this.drawRectangles(this.rectangles, this.stippled);
        if (var9_9) {
            var11_13 = new POINT();
            OS.GetCursorPos(var11_13);
            var10_11 = new Point(var11_13.x, var11_13.y);
        } else {
            var10_11 = (this.style & 16) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
        }
        var11_14 = var10_11.x;
        var12_15 = var10_11.y;
        while (this.tracking && !var1_1) {
            if (this.parent != null && this.parent.isDisposed()) break;
            OS.GetMessage(var3_3, 0, 0, 0);
            var13_17 = var3_3.message;
            switch (var13_17) {
                case 512: 
                case 514: {
                    var14_18 = OS.GetMessagePos();
                    var15_19 = var14_18 & 65535;
                    var16_20 = var14_18 >> 16;
                    if (var15_19 == var11_14 && var16_20 == var12_15) ** GOTO lbl121
                    var17_21 = this.rectangles;
                    var18_23 = (int)this.stippled;
                    var19_24 = new Rectangle[this.rectangles.length];
                    var20_26 = 0;
                    while (var20_26 < this.rectangles.length) {
                        var21_28 = this.rectangles[var20_26];
                        var19_24[var20_26] = new Rectangle(var21_28.x, var21_28.y, var21_28.width, var21_28.height);
                        ++var20_26;
                    }
                    var2_2.x = var15_19;
                    var2_2.y = var16_20;
                    if ((this.style & 16) == 0) ** GOTO lbl91
                    if (var4_4) {
                        this.resizeRectangles(var11_14 - var15_19, var16_20 - var12_15);
                    } else {
                        this.resizeRectangles(var15_19 - var11_14, var16_20 - var12_15);
                    }
                    this.inEvent = true;
                    this.sendEvent(11, var2_2);
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        var1_1 = true;
                        break;
                    }
                    var20_26 = 0;
                    if (this.rectangles == var17_21) ** GOTO lbl83
                    var21_29 = this.rectangles.length;
                    if (var21_29 == var19_24.length) ** GOTO lbl75
                    var20_26 = 1;
                    ** GOTO lbl84
lbl75:
                    // 1 sources

                    var22_32 = 0;
                    while (var22_32 < var21_29) {
                        if (this.rectangles[var22_32].equals(var19_24[var22_32])) ** GOTO lbl80
                        var20_26 = 1;
                        ** GOTO lbl84
lbl80:
                        // 1 sources

                        ++var22_32;
                    }
                    ** GOTO lbl84
lbl83:
                    // 1 sources

                    var20_26 = 1;
lbl84:
                    // 4 sources

                    if (var20_26 != 0) {
                        this.drawRectangles(var19_24, (boolean)var18_23);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    var10_11 = this.adjustResizeCursor();
                    var15_19 = var10_11.x;
                    var16_20 = var10_11.y;
                    ** GOTO lbl119
lbl91:
                    // 1 sources

                    if (var4_4) {
                        this.moveRectangles(var11_14 - var15_19, var16_20 - var12_15);
                    } else {
                        this.moveRectangles(var15_19 - var11_14, var16_20 - var12_15);
                    }
                    this.inEvent = true;
                    this.sendEvent(10, var2_2);
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        var1_1 = true;
                        break;
                    }
                    var20_26 = 0;
                    if (this.rectangles == var17_21) ** GOTO lbl115
                    var21_30 = this.rectangles.length;
                    if (var21_30 == var19_24.length) ** GOTO lbl107
                    var20_26 = 1;
                    ** GOTO lbl116
lbl107:
                    // 1 sources

                    var22_33 = 0;
                    while (var22_33 < var21_30) {
                        if (this.rectangles[var22_33].equals(var19_24[var22_33])) ** GOTO lbl112
                        var20_26 = 1;
                        ** GOTO lbl116
lbl112:
                        // 1 sources

                        ++var22_33;
                    }
                    ** GOTO lbl116
lbl115:
                    // 1 sources

                    var20_26 = 1;
lbl116:
                    // 4 sources

                    if (var20_26 != 0) {
                        this.drawRectangles(var19_24, (boolean)var18_23);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
lbl119:
                    // 4 sources

                    var11_14 = var15_19;
                    var12_15 = var16_20;
lbl121:
                    // 2 sources

                    this.tracking = var3_3.message != 514;
                    break;
                }
                case 260: {
                    var1_1 = true;
                    this.tracking = false;
                    break;
                }
                case 256: {
                    var17_22 = OS.GetKeyState(17) < 0 ? 1 : 9;
                    var18_23 = 0;
                    var19_25 = 0;
                    switch (var3_3.wParam) {
                        case 27: {
                            var1_1 = true;
                            this.tracking = false;
                            break;
                        }
                        case 13: {
                            this.tracking = false;
                            break;
                        }
                        case 37: {
                            var18_23 = var4_4 != false ? var17_22 : -var17_22;
                            break;
                        }
                        case 39: {
                            var18_23 = var4_4 != false ? -var17_22 : var17_22;
                            break;
                        }
                        case 38: {
                            var19_25 = -var17_22;
                            break;
                        }
                        case 40: {
                            var19_25 = var17_22;
                        }
                    }
                    if (var18_23 == 0 && var19_25 == 0) break;
                    var20_27 = this.rectangles;
                    var21_31 = this.stippled;
                    var22_34 = new Rectangle[this.rectangles.length];
                    var23_35 = 0;
                    while (var23_35 < this.rectangles.length) {
                        var24_36 = this.rectangles[var23_35];
                        var22_34[var23_35] = new Rectangle(var24_36.x, var24_36.y, var24_36.width, var24_36.height);
                        ++var23_35;
                    }
                    var2_2.x = var11_14 + var18_23;
                    var2_2.y = var12_15 + var19_25;
                    if ((this.style & 16) == 0) ** GOTO lbl190
                    this.resizeRectangles(var18_23, var19_25);
                    this.inEvent = true;
                    this.sendEvent(11, var2_2);
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        var1_1 = true;
                        break;
                    }
                    var23_35 = 0;
                    if (this.rectangles == var20_27) ** GOTO lbl184
                    var24_37 = this.rectangles.length;
                    if (var24_37 == var22_34.length) ** GOTO lbl176
                    var23_35 = 1;
                    ** GOTO lbl185
lbl176:
                    // 1 sources

                    var25_39 = 0;
                    while (var25_39 < var24_37) {
                        if (this.rectangles[var25_39].equals(var22_34[var25_39])) ** GOTO lbl181
                        var23_35 = 1;
                        ** GOTO lbl185
lbl181:
                        // 1 sources

                        ++var25_39;
                    }
                    ** GOTO lbl185
lbl184:
                    // 1 sources

                    var23_35 = 1;
lbl185:
                    // 4 sources

                    if (var23_35 != 0) {
                        this.drawRectangles(var22_34, var21_31);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    var10_11 = this.adjustResizeCursor();
                    ** GOTO lbl216
lbl190:
                    // 1 sources

                    this.moveRectangles(var18_23, var19_25);
                    this.inEvent = true;
                    this.sendEvent(10, var2_2);
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        var1_1 = true;
                        break;
                    }
                    var23_35 = 0;
                    if (this.rectangles == var20_27) ** GOTO lbl211
                    var24_38 = this.rectangles.length;
                    if (var24_38 == var22_34.length) ** GOTO lbl203
                    var23_35 = 1;
                    ** GOTO lbl212
lbl203:
                    // 1 sources

                    var25_39 = 0;
                    while (var25_39 < var24_38) {
                        if (this.rectangles[var25_39].equals(var22_34[var25_39])) ** GOTO lbl208
                        var23_35 = 1;
                        ** GOTO lbl212
lbl208:
                        // 1 sources

                        ++var25_39;
                    }
                    ** GOTO lbl212
lbl211:
                    // 1 sources

                    var23_35 = 1;
lbl212:
                    // 4 sources

                    if (var23_35 != 0) {
                        this.drawRectangles(var22_34, var21_31);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    var10_11 = this.adjustMoveCursor();
lbl216:
                    // 2 sources

                    var11_14 = var10_11.x;
                    var12_15 = var10_11.y;
                }
            }
            if (256 <= var13_17 && var13_17 <= 264 || 512 <= var13_17 && var13_17 <= 525) continue;
            OS.DispatchMessage(var3_3);
        }
        if (var9_9) {
            OS.ReleaseCapture();
        }
        if (!this.isDisposed()) {
            this.drawRectangles(this.rectangles, this.stippled);
        }
        if (var7_7 != 0) {
            OS.DestroyWindow(var7_7);
        }
        if (var8_8 != null) {
            var8_8.dispose();
        }
        if (this.resizeCursor != 0) {
            OS.DestroyCursor(this.resizeCursor);
        }
        this.tracking = false;
        return var1_1 == false;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    void resizeRectangles(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (n < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (n > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (n2 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (n2 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    n3 = 0;
                    while (n3 < this.proportions.length) {
                        rectangle = this.proportions[n3];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                        ++n3;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                n3 = 0;
                while (n3 < this.proportions.length) {
                    rectangle = this.proportions[n3];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                    ++n3;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n2 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n2 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    n3 = 0;
                    while (n3 < this.proportions.length) {
                        rectangle = this.proportions[n3];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                        ++n3;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n2) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n2 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                n3 = 0;
                while (n3 < this.proportions.length) {
                    rectangle = this.proportions[n3];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                    ++n3;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n;
            this.bounds.width -= n;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n2;
            this.bounds.height -= n2;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n2;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n4 = 0;
        while (n4 < this.rectangles.length) {
            Rectangle rectangle2 = this.proportions[n4];
            rectangleArray[n4] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
            ++n4;
        }
        this.rectangles = rectangleArray;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.clientCursor = 0;
        if (cursor != null) {
            this.clientCursor = cursor.handle;
            if (this.inEvent) {
                OS.SetCursor(this.clientCursor);
            }
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        int n = rectangleArray.length;
        this.rectangles = new Rectangle[n];
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = rectangleArray[n2];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[n2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n2;
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
    }
}

