/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class RowLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 3;
    public boolean wrap = true;
    public boolean pack = true;
    public boolean fill = false;
    public boolean justify = false;
    public int marginLeft = 3;
    public int marginTop = 3;
    public int marginRight = 3;
    public int marginBottom = 3;

    public RowLayout() {
    }

    public RowLayout(int n) {
        this.type = n;
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point = this.type == 256 ? this.layoutHorizontal(composite, false, n != -1 && this.wrap, n, bl) : this.layoutVertical(composite, false, n2 != -1 && this.wrap, n2, bl);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    Point computeSize(Control control, boolean bl) {
        int n = -1;
        int n2 = -1;
        RowData rowData = (RowData)control.getLayoutData();
        if (rowData != null) {
            n = rowData.width;
            n2 = rowData.height;
        }
        return control.computeSize(n, n2, bl);
    }

    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        if (this.type == 256) {
            this.layoutHorizontal(composite, true, this.wrap, rectangle.width, bl);
        } else {
            this.layoutVertical(composite, true, this.wrap, rectangle.height, bl);
        }
    }

    Point layoutHorizontal(Composite composite, boolean bl, boolean bl2, int n, boolean bl3) {
        int n2;
        Object object;
        int n3;
        Control[] controlArray = composite.getChildren();
        int n4 = controlArray.length;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!this.pack) {
            n3 = 0;
            while (n3 < n4) {
                Control control = controlArray[n3];
                object = this.computeSize(control, bl3);
                n5 = Math.max(n5, ((Point)object).x);
                n6 = Math.max(n6, ((Point)object).y);
                ++n3;
            }
            n7 = n6;
        }
        n3 = 0;
        int n8 = 0;
        if (bl) {
            object = composite.getClientArea();
            n3 = ((Rectangle)object).x;
            n8 = ((Rectangle)object).y;
        }
        object = null;
        boolean bl4 = false;
        Rectangle[] rectangleArray = null;
        if (bl && (this.justify || this.fill)) {
            rectangleArray = new Rectangle[n4];
            object = new int[n4];
        }
        int n9 = 0;
        int n10 = this.marginLeft + this.marginWidth;
        int n11 = this.marginTop + this.marginHeight;
        int n12 = 0;
        while (n12 < n4) {
            Control control = controlArray[n12];
            if (this.pack) {
                Point point = this.computeSize(control, bl3);
                n5 = point.x;
                n6 = point.y;
            }
            if (bl2 && n12 != 0 && n10 + n5 > n) {
                bl4 = true;
                if (bl && (this.justify || this.fill)) {
                    object[n12 - 1] = n7;
                }
                n10 = this.marginLeft + this.marginWidth;
                n11 += this.spacing + n7;
                if (this.pack) {
                    n7 = 0;
                }
            }
            if (this.pack || this.fill) {
                n7 = Math.max(n7, n6);
            }
            if (bl) {
                int n13 = n10 + n3;
                n2 = n11 + n8;
                if (this.justify || this.fill) {
                    rectangleArray[n12] = new Rectangle(n13, n2, n5, n6);
                } else {
                    control.setBounds(n13, n2, n5, n6);
                }
            }
            n9 = Math.max(n9, n10 += this.spacing + n5);
            ++n12;
        }
        n9 = Math.max(n3 + this.marginLeft + this.marginWidth, n9 - this.spacing);
        if (!bl4) {
            n9 += this.marginRight + this.marginWidth;
        }
        if (bl && (this.justify || this.fill)) {
            n12 = 0;
            int n14 = 0;
            if (!bl4) {
                n12 = Math.max(0, (n - n9) / (n4 + 1));
                n14 = Math.max(0, (n - n9) % (n4 + 1) / 2);
            } else if (this.fill || this.justify) {
                int n15 = 0;
                if (n4 > 0) {
                    object[n4 - 1] = n7;
                }
                n2 = 0;
                while (n2 < n4) {
                    if (object[n2] != false) {
                        int n16;
                        int n17 = n2 - n15 + 1;
                        if (this.justify) {
                            n16 = 0;
                            int n18 = n15;
                            while (n18 <= n2) {
                                n16 += rectangleArray[n18].width + this.spacing;
                                ++n18;
                            }
                            n12 = Math.max(0, (n - n16) / (n17 + 1));
                            n14 = Math.max(0, (n - n16) % (n17 + 1) / 2);
                        }
                        n16 = n15;
                        while (n16 <= n2) {
                            if (this.justify) {
                                rectangleArray[n16].x += n12 * (n16 - n15 + 1) + n14;
                            }
                            if (this.fill) {
                                rectangleArray[n16].height = (int)object[n2];
                            }
                            ++n16;
                        }
                        n15 = n2 + 1;
                    }
                    ++n2;
                }
            }
            int n19 = 0;
            while (n19 < n4) {
                if (!bl4) {
                    if (this.justify) {
                        rectangleArray[n19].x += n12 * (n19 + 1) + n14;
                    }
                    if (this.fill) {
                        rectangleArray[n19].height = n7;
                    }
                }
                controlArray[n19].setBounds(rectangleArray[n19]);
                ++n19;
            }
        }
        return new Point(n9, n11 + n7 + this.marginBottom + this.marginHeight);
    }

    Point layoutVertical(Composite composite, boolean bl, boolean bl2, int n, boolean bl3) {
        int n2;
        Object object;
        int n3;
        Control[] controlArray = composite.getChildren();
        int n4 = controlArray.length;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!this.pack) {
            n3 = 0;
            while (n3 < n4) {
                Control control = controlArray[n3];
                object = this.computeSize(control, bl3);
                n5 = Math.max(n5, ((Point)object).x);
                n6 = Math.max(n6, ((Point)object).y);
                ++n3;
            }
            n7 = n5;
        }
        n3 = 0;
        int n8 = 0;
        if (bl) {
            object = composite.getClientArea();
            n3 = ((Rectangle)object).x;
            n8 = ((Rectangle)object).y;
        }
        object = null;
        boolean bl4 = false;
        Rectangle[] rectangleArray = null;
        if (bl && (this.justify || this.fill)) {
            rectangleArray = new Rectangle[n4];
            object = new int[n4];
        }
        int n9 = 0;
        int n10 = this.marginLeft + this.marginWidth;
        int n11 = this.marginTop + this.marginHeight;
        int n12 = 0;
        while (n12 < n4) {
            Control control = controlArray[n12];
            if (this.pack) {
                Point point = this.computeSize(control, bl3);
                n5 = point.x;
                n6 = point.y;
            }
            if (bl2 && n12 != 0 && n11 + n6 > n) {
                bl4 = true;
                if (bl && (this.justify || this.fill)) {
                    object[n12 - 1] = n7;
                }
                n10 += this.spacing + n7;
                n11 = this.marginTop + this.marginHeight;
                if (this.pack) {
                    n7 = 0;
                }
            }
            if (this.pack || this.fill) {
                n7 = Math.max(n7, n5);
            }
            if (bl) {
                int n13 = n10 + n3;
                n2 = n11 + n8;
                if (this.justify || this.fill) {
                    rectangleArray[n12] = new Rectangle(n13, n2, n5, n6);
                } else {
                    control.setBounds(n13, n2, n5, n6);
                }
            }
            n9 = Math.max(n9, n11 += this.spacing + n6);
            ++n12;
        }
        n9 = Math.max(n8 + this.marginTop + this.marginHeight, n9 - this.spacing);
        if (!bl4) {
            n9 += this.marginBottom + this.marginHeight;
        }
        if (bl && (this.justify || this.fill)) {
            n12 = 0;
            int n14 = 0;
            if (!bl4) {
                n12 = Math.max(0, (n - n9) / (n4 + 1));
                n14 = Math.max(0, (n - n9) % (n4 + 1) / 2);
            } else if (this.fill || this.justify) {
                int n15 = 0;
                if (n4 > 0) {
                    object[n4 - 1] = n7;
                }
                n2 = 0;
                while (n2 < n4) {
                    if (object[n2] != false) {
                        int n16;
                        int n17 = n2 - n15 + 1;
                        if (this.justify) {
                            n16 = 0;
                            int n18 = n15;
                            while (n18 <= n2) {
                                n16 += rectangleArray[n18].height + this.spacing;
                                ++n18;
                            }
                            n12 = Math.max(0, (n - n16) / (n17 + 1));
                            n14 = Math.max(0, (n - n16) % (n17 + 1) / 2);
                        }
                        n16 = n15;
                        while (n16 <= n2) {
                            if (this.justify) {
                                rectangleArray[n16].y += n12 * (n16 - n15 + 1) + n14;
                            }
                            if (this.fill) {
                                rectangleArray[n16].width = (int)object[n2];
                            }
                            ++n16;
                        }
                        n15 = n2 + 1;
                    }
                    ++n2;
                }
            }
            int n19 = 0;
            while (n19 < n4) {
                if (!bl4) {
                    if (this.justify) {
                        rectangleArray[n19].y += n12 * (n19 + 1) + n14;
                    }
                    if (this.fill) {
                        rectangleArray[n19].width = n7;
                    }
                }
                controlArray[n19].setBounds(rectangleArray[n19]);
                ++n19;
            }
        }
        return new Point(n10 + n7 + this.marginRight + this.marginWidth, n9);
    }
}

