package test.contrib.tabledatefield;

import java.util.*;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;

import org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel;

/**
 * Copyright 2008 Computer Science Software (Pty) Ltd. South Africa. Class to
 * demonstrate hovering mouse issue. C:\profida\jre\bin\java
 * SubstanceDateRendererTest
 * 
 * @author DP
 * @since 3.02 [a8]
 * 
 * <BR>
 * 19-Feb-2008 : Created class (DP)
 */

public class SubstanceDateRendererTest extends JFrame {

	public SubstanceDateRendererTest() {
		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

		GregorianCalendar cal1 = new GregorianCalendar();
		cal1.set(Calendar.DAY_OF_MONTH, 10);
		cal1.set(Calendar.MONTH, Calendar.JULY);
		cal1.set(Calendar.YEAR, 2007);
		GregorianCalendar cal2 = new GregorianCalendar();
		cal2.set(Calendar.DAY_OF_MONTH, 10);
		cal2.set(Calendar.MONTH, Calendar.FEBRUARY);
		cal2.set(Calendar.YEAR, 2008);

		DefaultTableModel tableModel = new DefaultTableModel(new Object[][] {
				{ false, cal1.getTime(), "some text", null },
				{ true, new Date(), "notes and notes", null },
				{ true, cal2.getTime(), null, null },
				{ true, null, "not nothing", null } }, new String[] {
				"Boolean", "Date", "Notes", "Misc" });

		JTable testTable = new JTable(tableModel);
		testTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		testTable.setRowHeight(18);
		JScrollPane scrollPane = new JScrollPane(testTable);

		testTable.getColumnModel().getColumn(1).setCellRenderer(
				new DateTextFieldRenderer());
		testTable.getColumnModel().getColumn(1).setPreferredWidth(100);

		getContentPane().setLayout(
				new javax.swing.BoxLayout(getContentPane(),
						javax.swing.BoxLayout.PAGE_AXIS));
		getContentPane().add(scrollPane);
		pack();
	}

	/**
	 * Used to transform a XSL stylesheet and an XML source file into a PDF
	 * file.
	 */
	public static void main(String[] args) {
		try {
			java.awt.EventQueue.invokeLater(new Runnable() {
				public void run() {
					try {
						UIManager
								.setLookAndFeel(new SubstanceBusinessBlueSteelLookAndFeel());
						new SubstanceDateRendererTest().setVisible(true);
					} catch (Exception exc) {
						exc.printStackTrace();
					}
				}
			});
		} catch (Exception exc) {
			System.exit(-1);
		}
	}
}