package test.contrib;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

public class UndecoratedDialog extends JDialog {

	public UndecoratedDialog(Window owner, String title) {
		super((Frame) owner, true);
		setUndecorated(true);
		add(new JLabel("This should be undecorated"), BorderLayout.NORTH);
		pack();
		setLocationRelativeTo(null);
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		// UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		JDialog.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				final JFrame frame = new JFrame("Test");
				frame.setLayout(new FlowLayout());
				JButton show = new JButton("Show");
				show.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						SwingUtilities.invokeLater(new Runnable() {
							public void run() {
								UndecoratedDialog dialog = new UndecoratedDialog(
										frame, "Sample title");
								dialog.setVisible(true);
							}
						});
					}
				});
				frame.add(show);
				frame.setSize(200, 100);
				frame.setLocationRelativeTo(null);
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				frame.setVisible(true);
			}
		});
	}
}