//////////////////////////////////////////////

package test.contrib;

import java.awt.BorderLayout;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel;

/**
 * Class which shows an error with displaying the contents of a JComboBox with a
 * long list anytime the combobox has a setSelectedItem called on it that is not
 * the first element in the list.
 */
public class Bug293 {
	public Bug293() {
		JComboBox lotsOfItems = new JComboBox();
		for (int i = 0; i < 100; i++) {
			lotsOfItems.addItem("Test " + i);
		}
		// Calling either getModel.setSelectedItem or setSelectedItem
		// Gives errors when this component is displayed.

		// TODO Start of error case.
		// Calling any of these 3 lines gives the display error.
		// Without these lines there is no display error but I want to have
		// one of the values (other than the first value) selected.
		// lotsOfItems.getModel().setSelectedItem("Test 1");
		// lotsOfItems.setSelectedItem("Test 1");
		lotsOfItems.setSelectedIndex(1);
		// TODO end of error case.

		JFrame tmp = new JFrame("JComboBox Issue");
		tmp.getContentPane().setLayout(new BorderLayout());
		tmp.getContentPane().add(lotsOfItems);
		tmp.pack();
		tmp.setVisible(true);
	}

	public static void main(String[] args) {
		try {
			UIManager
					.setLookAndFeel(new SubstanceBusinessBlueSteelLookAndFeel());
		} catch (UnsupportedLookAndFeelException e) {
			e.printStackTrace();
		}
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new Bug293();
			}
		});
	}
}