package test;

import java.awt.*;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;

import javax.swing.JFrame;
import javax.swing.JPanel;

import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.painter.SimplisticGradientPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class TestMix extends JFrame {

	public TestMix() {
		this.setSize(new Dimension(200, 100));
		this.setLocationRelativeTo(null);
		this.setLayout(new BorderLayout());
		this.add(new GradPanel(), BorderLayout.CENTER);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setVisible(true);
	}

	public static final class GradPanel extends JPanel {
		@Override
		public void paint(Graphics g) {
			Graphics2D graphics = (Graphics2D) g;
			int w = getWidth();
			int h = getHeight();
			BufferedImage im1 = new BufferedImage(w, h,
					BufferedImage.TYPE_INT_ARGB);
			Graphics g1 = im1.getGraphics();
			g1.setColor(Color.red);
			g1.fillRect(0, 0, w, h);
			BufferedImage im2 = new BufferedImage(w, h,
					BufferedImage.TYPE_INT_ARGB);
			Graphics g2 = im2.getGraphics();
			g2.setColor(Color.blue);
			g2.fillRect(0, 0, w, h);

			BufferedImage mixImage = SubstanceCoreUtilities
					.blendImagesHorizontal(im1, im2, 0.0, 1.0);
			Graphics2D mixGraphics = mixImage.createGraphics();
			int width = 100;
			int height = 20;
			int radius = 10;
			ColorScheme mainScheme = new MetallicColorScheme();
			Shape shape = BaseButtonShaper.getBaseOutline(width, height,
					radius, null);
			BufferedImage opaque = new SimplisticGradientPainter()
					.getContourBackground(width, height, shape, false,
							mainScheme, mainScheme, 0, true, false);

			mixGraphics.drawImage(opaque, 0, 0, null);

			graphics.setColor(new Color(0, 255, 0, 50));
			graphics.fillRect(0, 0, w, h);

			Area area = new Area(new Rectangle(0, 0, w, h));
			area.subtract(new Area(shape));

			// graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
			// RenderingHints.VALUE_ANTIALIAS_ON);
			// Shape clip = g.getClip();
			// graphics.setClip(area);
			// graphics.drawImage(mixImage, 0, 0, null);
			//
			// graphics.setClip(clip);
			// graphics.setComposite(AlphaComposite.getInstance(
			// AlphaComposite.SRC_OVER, 0.3f));
			// graphics.drawImage(opaque, 0, 0, null);
			//			
			graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
					RenderingHints.VALUE_ANTIALIAS_ON);
			graphics.drawImage(mixImage, 0, 0, null);

			graphics.setComposite(AlphaComposite.getInstance(
					AlphaComposite.DST_OUT, 0.3f));
			graphics.drawImage(opaque, 0, 0, null);

			graphics.dispose();
		}
	}

	public static void main(String[] args) {
		new TestMix();
	}

}
