package test;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;
import org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel;

public class SwitchLafs extends JFrame {
	public SwitchLafs() {
		this.setLayout(new BorderLayout());

		JPanel mainPanel = new JPanel(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);

		JPanel buttonsPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		this.add(buttonsPanel, BorderLayout.SOUTH);

		JDesktopPane jdp = new JDesktopPane();
		mainPanel.add(jdp, BorderLayout.CENTER);

		JInternalFrame jif1 = new JInternalFrame();
		JPanel p1 = new JPanel(new FlowLayout());
		jif1.add(p1);
		p1.add(new JCheckBox("checkbox"));
		p1.add(new JRadioButton("radio"));
		p1.add(new JButton("button"));
		jdp.add(jif1);
		jif1.setVisible(true);
		jif1.setBounds(0, 0, 200, 100);

		JInternalFrame jif2 = new JInternalFrame();
		JPanel p2 = new JPanel(new FlowLayout());
		jif2.add(p2);
		p2.add(new JCheckBox("checkbox"));
		p2.add(new JRadioButton("radio"));
		p2.add(new JButton("button"));
		jdp.add(jif2);
		jif2.setVisible(true);
		jif2.setBounds(50, 50, 200, 100);

		JButton jb = new JButton("Metal");
		jb.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							UIManager.setLookAndFeel(UIManager
									.getCrossPlatformLookAndFeelClassName());
							SwingUtilities
									.updateComponentTreeUI(SwitchLafs.this);
						} catch (Exception exc) {
						}
					}
				});
			}
		});
		buttonsPanel.add(jb);

		JButton jb1 = new JButton("Windows");
		jb1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							UIManager.setLookAndFeel(UIManager
									.getSystemLookAndFeelClassName());
							SwingUtilities
									.updateComponentTreeUI(SwitchLafs.this);
						} catch (Exception exc) {
						}
					}
				});
			}
		});
		buttonsPanel.add(jb1);

		JButton jb2 = new JButton("Blue Steel");
		jb2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							UIManager
									.setLookAndFeel(new SubstanceBusinessBlueSteelLookAndFeel());
							SwingUtilities
									.updateComponentTreeUI(SwitchLafs.this);
						} catch (Exception exc) {
						}
					}
				});
			}
		});
		buttonsPanel.add(jb2);

		JButton jb3 = new JButton("Black Steel");
		jb3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							UIManager
									.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
							SwingUtilities
									.updateComponentTreeUI(SwitchLafs.this);
						} catch (Exception exc) {
						}
					}
				});
			}
		});
		buttonsPanel.add(jb3);

		this.setSize(400, 300);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new SwitchLafs().setVisible(true);
			}
		});
	}
}
