/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.plugin;

import java.util.HashSet;
import java.util.Set;

import org.jvnet.substance.border.*;

/**
 * Core plugin for border painters shapers. See
 * {@link SubstanceBorderPainterPlugin} interface. This class is <b>for internal
 * use only</b>.
 * 
 * @author Kirill Grouchnikov.
 */
public class BaseBorderPainterPlugin implements SubstanceBorderPainterPlugin {
	/**
	 * Creates info object on a single border painter.
	 * 
	 * @param borderPainter
	 *            Border painter instance.
	 * @param isDefault
	 *            Indication whether the specified border painter is default.
	 * @return Info object on the specified border painter.
	 */
	private static BorderPainterInfo create(
			SubstanceBorderPainter borderPainter, boolean isDefault) {
		BorderPainterInfo result = new BorderPainterInfo(borderPainter
				.getDisplayName(), borderPainter.getClass().getName());
		result.setDefault(isDefault);
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.plugin.SubstanceBorderPainterPlugin#getBorderPainters()
	 */
	public Set<BorderPainterInfo> getBorderPainters() {
		Set<BorderPainterInfo> result = new HashSet<BorderPainterInfo>();
		result.add(create(new GlassBorderPainter(), false));
		result.add(create(new ClassicBorderPainter(), false));
		result.add(create(new NullBorderPainter(), false));
		result.add(create(new StandardBorderPainter(), false));
		result.add(create(new FlatBorderPainter(), false));
		result.add(create(new ClassicInnerBorderPainter(), false));
		result.add(create(new GlassInnerBorderPainter(), false));
		result.add(create(new FlatInnerBorderPainter(), false));
		return result;
	}
}
