/*
 * RTLinux architecture-independent clock support
 *
 * 1999 Michael Barabanov <baraban@fsmlabs.com>
 *
 * Copyright (C) Finite State Machine Labs Inc., 1999
 */

#include <rtl_conf.h>
#include <rtl_time.h>
#include <rtl_core.h>
#include <errno.h>
#include <linux/kernel.h>

/* This is not really the right place but...*/
int *(*__errno_location)(void);

static int default_errno;
static int *default_errno_location(void)
{
	return &default_errno;
}

int rtl_setclockhandler (clockid_t h, clock_irq_handler_t fn)
{
	if (h -> handler != RTL_CLOCK_DEFAULTS.handler) {
		return -EBUSY;
	}
	h->handler = fn;
	return 0;
}

int rtl_unsetclockhandler (clockid_t h)
{
	if (h->handler == RTL_CLOCK_DEFAULTS.handler) {
		return -EINVAL;
	}
	h-> handler = RTL_CLOCK_DEFAULTS.handler;
	return 0;
}

static int definit (struct rtl_clock *c) { return 0; }
static void defuninit (struct rtl_clock *c) { return; }
static hrtime_t defgethrtime (struct rtl_clock *c)
{
	rtl_printf("defgethrtime called from %p\n", __builtin_return_address(0));
	return (hrtime_t) -1;
}

static int defsethrtime(struct rtl_clock *c, hrtime_t t)
{
	rtl_printf("defsethrtime called from %p\n", __builtin_return_address(0));
	return -EINVAL;
}
static int defsettimer(struct rtl_clock *c, hrtime_t interval)
{
	rtl_printf("defsettimer called from %p\n", __builtin_return_address(0));
	return -1;
}
static int defsettimermode (struct rtl_clock *c, int mode)
{
	rtl_printf("defsettimermode called from %p\n", __builtin_return_address(0));
	return -1;
}

static void default_handler( struct pt_regs *regs) { }


#define RTL_CLOCK_INITIALIZER { \
	definit, \
	defuninit, \
	defgethrtime, \
	defsethrtime, \
	defsettimer, \
	defsettimermode, \
	default_handler, \
	RTL_CLOCK_MODE_UNINITIALIZED, \
	0, \
	0, \
	0, \
	PTHREAD_SPINLOCK_INITIALIZER, \
	RTL_CLOCK_ARCH_INITIALIZER};


struct rtl_clock RTL_CLOCK_DEFAULTS = RTL_CLOCK_INITIALIZER;

static struct rtl_clock clock_ust = RTL_CLOCK_INITIALIZER;

hrtime_t ust_gethrtime(struct rtl_clock *c)
{
	return gethrtime();
}

#include <rtl_debug.h>
#include <rtl_core.h>

clockid_t CLOCK_UST = &clock_ust;


int rtl_init_standard_clocks(void)
{
	__errno_location = &default_errno_location;
	clock_ust.gethrtime = &ust_gethrtime;
	clock_ust.resolution = gethrtimeres();
#ifdef RTLINUX_V2
	return rtl_printf_init();
#endif
	return 0;
}

void rtl_cleanup_standard_clocks(void)
{
#ifdef RTLINUX_V2
	rtl_printf_cleanup();
#endif
}
