/*
 * Modified:  zov : 17-Apr-1998  : Saves an image as .BMP, .GIF or .XWD file
 *

   XW_STATUS Xw_save_image (awindow,aimage,filename):
   XW_EXT_WINDOW *awindow
   XW_EXT_IMAGEDATA   *aimage
   char *filename	XWD Image name
  
   Saves an image to an XWD, BMP or GIF file depending on given filename.
  
   returns  SUCCESS   if successfull;
   otherwise returns  ERROR
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <Xw_Extension.h>
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif

#ifdef XW_PROTOTYPE
/* External helper functions */
XW_STATUS Xw_save_xwd_image (void *awindow,void *aimage,char *filename);
XW_STATUS Xw_save_bmp_image (void *awindow,void *aimage,char *filename);
XW_STATUS Xw_save_gif_image (void *awindow,void *aimage,char *filename);
#else
XW_STATUS Xw_save_xwd_image ();
XW_STATUS Xw_save_bmp_image ();
XW_STATUS Xw_save_gif_image ();
#endif


/* Types of image (TOI) */
#define TOI_XWD  0
#define TOI_BMP  1
#define TOI_GIF  2

#ifdef XW_PROTOTYPE
static int Xw_get_file_format_from_name (char* pchFileName)
#else
static int Xw_get_file_format_from_name (pchFileName)
char *pchFileName;
#endif
{
  /* Parses given file name and determines which of file formats to use.
   * Returns TOI_XWD for XXX.xwd, TOI_BMP for XXX.bmp, TOI_GIF for XXX.gif;
   * otherwise reads env. var. CSF_DefaultImageFormat
   * which must be one of 'xwd', 'bmp' or 'gif'.
   */

  int  nSize = strlen (pchFileName);
  char *pchEnv;


  if (nSize > 3) {  /* Name is big enough to have .??? extension. */
    char *pchExt = pchFileName + nSize - 3;  /* Point to the end 3 chars */

    if (*(pchExt-1) == '.') {  /* Must have a point to indicate extension start */
      if (0 == strcasecmp (pchExt, "xwd"))
        return TOI_XWD;
      else if (0 == strcasecmp (pchExt, "bmp"))
        return TOI_BMP;
      else if (0 == strcasecmp (pchExt, "gif"))
        return TOI_GIF;
      else
        fprintf (stderr,
		 "\r\nWarning: Unknown file extension used in Xw_save_image: '%s'!"
		 " Using $CSF_DefaultImageFormat.\r\n", pchExt);
    }
  }

  /* otherwise use default format */
  pchEnv = getenv ("CSF_DefaultImageFormat");
  if (pchEnv == NULL)
    return TOI_XWD; /* the env. variable not specified; assume xwd by default */

  if (0 == strcasecmp (pchEnv, "bmp"))
    return TOI_BMP;
  else if (0 == strcasecmp (pchEnv, "gif"))
    return TOI_GIF;

  return TOI_XWD; /* invalid env. variable value; assume xwd by default */
}

#ifdef XW_PROTOTYPE
XW_STATUS Xw_save_image (void *awindow,void *aimage,char *filename)
#else
XW_STATUS Xw_save_image (awindow,aimage,filename)
void *awindow;
void *aimage;
char *filename ;
#endif /*XW_PROTOTYPE*/
{
  int toiFormat = Xw_get_file_format_from_name (filename);


  switch (toiFormat)
    {
    case TOI_XWD:
      return Xw_save_xwd_image (awindow, aimage, filename);
      
    case TOI_BMP:
      return Xw_save_bmp_image (awindow, aimage, filename);
      
    case TOI_GIF:
      return Xw_save_gif_image (awindow, aimage, filename);
    }
 

  /*ERROR*Bad type index*/
  Xw_set_error (18, "Xw_save_image", &toiFormat) ;
  
  return (XW_ERROR);
}
