/* File:	Triangle.hxx
 * Created:	23.06.2004
 * Author:	Michael SAZONOV
 * Copyright:    Open CASCADE 2004
*/

/* NOTE: This file is included to triangle.c, so its sintax should
 *       comply with ANSI C (no // comments; no other OCC includes)
*/

#ifndef _Triangle_HeaderFile
#define _Triangle_HeaderFile

#ifdef __cplusplus
extern "C" {
#endif

#define REAL double
#define ANSI_DECLARATORS
#include <triangle.h>
#undef REAL

  TRIANGLE_API void triangle_InitBehavior();
  TRIANGLE_API void triangle_InitMesh(int nbnodes);
  TRIANGLE_API int  triangle_AddPoint(double x, double y, int index);
  TRIANGLE_API void triangle_AddPointIni(double x, double y, int index);
  TRIANGLE_API void triangle_AddEdge(const int *nodes, int length, int orient, int first);
  TRIANGLE_API void triangle_InsertHoles(double *holes, int length);
  TRIANGLE_API void triangle_GetMeshSize(int* nbnodes, int* nbtriangles);
  TRIANGLE_API void triangle_InitPoints();
  TRIANGLE_API int  triangle_NextPoint(int iterator, double *x, double *y, int *index);
  TRIANGLE_API void triangle_InitTriangles();
  TRIANGLE_API int  triangle_NextTriangle(int *n1, int *n2, int *n3, int *m1, int *m2, int *m3);
  TRIANGLE_API int  triangle_Triangulate();
  TRIANGLE_API void triangle_FinishTriangulation();
  TRIANGLE_API void triangle_FreeTriangulation();
  /* Modified by mpv Dec 25 2006 OCC14376: increases precision of calculations (but slower) */
  TRIANGLE_API void triangle_IncreasePrecision(); 

#ifdef __cplusplus
}
#endif

#endif
