// File:	TopoDS_TShape.cxx
// Created:	Wed Mar 20 11:38:04 1991
// Author:	Remi Lequette
//		<rle@topsn2>


#include <TopoDS_TShape.ixx>
#include <TopAbs.hxx>
#include <TopoDS_Shape.hxx>
#include <TopoDS_ListIteratorOfListOfShape.hxx>

static const Standard_Integer FreeMask       = 1;
static const Standard_Integer ModifiedMask   = 2;
static const Standard_Integer CheckedMask    = 4;
static const Standard_Integer OrientableMask = 8;
static const Standard_Integer ClosedMask     = 16;
static const Standard_Integer InfiniteMask   = 32;
static const Standard_Integer ConvexMask     = 64;

//=======================================================================
//function : TopoDS_TShape
//purpose  : Constructor, Empty TShape
//=======================================================================

TopoDS_TShape::TopoDS_TShape () : myFlags(0)
{
  Free(Standard_True);
  Modified(Standard_True);
  Orientable(Standard_True);
  Checked(Standard_False);
}

//=======================================================================
//function : Free
//purpose  : 
//=======================================================================

Standard_Boolean TopoDS_TShape::Free () const
{
  return (myFlags & FreeMask);
}

//=======================================================================
//function : Free
//purpose  : 
//=======================================================================

void  TopoDS_TShape::Free(const Standard_Boolean F)
{
  if (F) myFlags |= FreeMask;
  else   myFlags &= ~FreeMask;
}

//=======================================================================
//function : Modified
//purpose  : 
//=======================================================================

Standard_Boolean  TopoDS_TShape::Modified() const 
{
  return (myFlags & ModifiedMask);
}

//=======================================================================
//function : Modified
//purpose  : 
//=======================================================================

void  TopoDS_TShape::Modified(const Standard_Boolean M)
{
  if (M) myFlags |= ModifiedMask;
  else   myFlags &= ~ModifiedMask;
  // When a TShape is modified it is also unchecked
  if (M) Checked(Standard_False);
}

//=======================================================================
//function : Checked
//purpose  : 
//=======================================================================

Standard_Boolean  TopoDS_TShape::Checked() const 
{
  return (myFlags & CheckedMask);
}

//=======================================================================
//function : Checked
//purpose  : 
//=======================================================================

void  TopoDS_TShape::Checked(const Standard_Boolean M)
{
  if (M) myFlags |= CheckedMask;
  else   myFlags &= ~CheckedMask;
}

//=======================================================================
//function : Orientable
//purpose  : 
//=======================================================================

Standard_Boolean  TopoDS_TShape::Orientable() const 
{
  return (myFlags & OrientableMask);
}

//=======================================================================
//function : Orientable
//purpose  : 
//=======================================================================

void  TopoDS_TShape::Orientable(const Standard_Boolean M)
{
  if (M) myFlags |= OrientableMask;
  else   myFlags &= ~OrientableMask;
}

//=======================================================================
//function : Closed
//purpose  : 
//=======================================================================

Standard_Boolean  TopoDS_TShape::Closed() const 
{
  return (myFlags & ClosedMask);
}

//=======================================================================
//function : Closed
//purpose  : 
//=======================================================================

void  TopoDS_TShape::Closed(const Standard_Boolean M)
{
  if (M) myFlags |= ClosedMask;
  else   myFlags &= ~ClosedMask;
}

//=======================================================================
//function : Infinite
//purpose  : 
//=======================================================================

Standard_Boolean  TopoDS_TShape::Infinite() const 
{
  return (myFlags & InfiniteMask);
}

//=======================================================================
//function : Infinite
//purpose  : 
//=======================================================================

void  TopoDS_TShape::Infinite(const Standard_Boolean M)
{
  if (M) myFlags |= InfiniteMask;
  else   myFlags &= ~InfiniteMask;
}

//=======================================================================
//function : Convex
//purpose  : 
//=======================================================================

Standard_Boolean  TopoDS_TShape::Convex() const 
{
  return (myFlags & ConvexMask);
}

//=======================================================================
//function : Convex
//purpose  : 
//=======================================================================

void  TopoDS_TShape::Convex(const Standard_Boolean M)
{
  if (M) myFlags |= ConvexMask;
  else   myFlags &= ~ConvexMask;
}
