// File:	TDataStd_Point.cxx
// Created:	Thu Mar  6 10:25:48 1997
// Author:	Denis PASCAL


#include <TDataStd_Point.ixx>

#include <TDataStd.hxx>
#include <TNaming_NamedShape.hxx>
#include <TNaming_Tool.hxx>
#include <TNaming_Builder.hxx>
#include <BRep_Tool.hxx>
#include <TopoDS.hxx>
#include <TopoDS_Vertex.hxx>
#include <TopAbs.hxx>
#include <BRepBuilderAPI_MakeVertex.hxx>

#include <Geom_CartesianPoint.hxx>

#include <BRep_Tool.hxx>

#define OCC2932

//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Point::GetID() 
{
  static Standard_GUID TDataStd_PointID("2a96b60d-ec8b-11d0-bee7-080009dc3333");
  return TDataStd_PointID;
}


//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_Point) TDataStd_Point::Set (const TDF_Label& L)
{ 
  Handle(TDataStd_Point) A; 
  if (!L.FindAttribute(TDataStd_Point::GetID(),A)) {
    A = new TDataStd_Point (); 
    L.AddAttribute(A);
  }
  return A;
}

//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_Point) TDataStd_Point::Set (const TDF_Label& L, const gp_Pnt& P)
{ 
  Handle(TDataStd_Point) A = Set (L);

#ifdef OCC2932
  Handle(TNaming_NamedShape) aNS;
  if(L.FindAttribute(TNaming_NamedShape::GetID(), aNS)) {
    if(!aNS->Get().IsNull())
       if(aNS->Get().ShapeType() == TopAbs_VERTEX) {
	 gp_Pnt anOldPnt = BRep_Tool::Pnt(TopoDS::Vertex(aNS->Get()));
	 if(anOldPnt.X() == P.X() &&
	    anOldPnt.Y() == P.Y() &&
	    anOldPnt.Z() == P.Z()
	    )
	   return A;
       }
  }
#endif

  TNaming_Builder B(L);
  B.Generated(BRepBuilderAPI_MakeVertex(P));
  return A;
}


//=======================================================================
//function : TDataStd_Point
//purpose  : 
//=======================================================================

TDataStd_Point::TDataStd_Point () {}



//=======================================================================
//function : ID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Point::ID() const { return GetID ();}


//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) TDataStd_Point::NewEmpty () const
{  
  return new TDataStd_Point(); 
}


//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================

void TDataStd_Point::Restore(const Handle(TDF_Attribute)& With) { }


//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void TDataStd_Point::Paste (const Handle(TDF_Attribute)& Into, const Handle(TDF_RelocationTable)& RT) const { }


//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TDataStd_Point::Dump (Standard_OStream& anOS) const
{  
  anOS << "Point";
  return anOS;
}
