// File:	TDataStd_ExtStringArray.cxx
// Created:	Wed Jan 16 10:10:40 2002
// Author:	Michael PONIKAROV
//		<mpv@covox>


#include <TDataStd_ExtStringArray.ixx>

//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_ExtStringArray::GetID() 
{ 
  static Standard_GUID anExtStringArrayID ("2a96b624-ec8b-11d0-bee7-080009dc3333");
  return anExtStringArrayID; 
}


//=======================================================================
//function : TDataStd_ExtStringArray::TDataStd_ExtStringArray
//purpose  : 
//=======================================================================

TDataStd_ExtStringArray::TDataStd_ExtStringArray() {}
     
//=======================================================================
//function : Init
//purpose  : 
//=======================================================================

void TDataStd_ExtStringArray::Init(const Standard_Integer lower,
				const Standard_Integer upper)
{
  Backup();
  myValue = new TColStd_HArray1OfExtendedString(lower, upper);
}

//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_ExtStringArray) TDataStd_ExtStringArray::Set (const TDF_Label& label,
							const Standard_Integer lower,
							const Standard_Integer upper) 

{
  Handle(TDataStd_ExtStringArray) A;
  if (!label.FindAttribute (TDataStd_ExtStringArray::GetID(), A)) {
    A = new TDataStd_ExtStringArray;
    A->Init (lower, upper); 
    label.AddAttribute(A);
  }
  return A;
}


//=======================================================================
//function : SetValue
//purpose  : 
//=======================================================================

void TDataStd_ExtStringArray::SetValue(const Standard_Integer index, const TCollection_ExtendedString& value) 
{
  if(myValue.IsNull()) return;
  if( myValue->Value(index) == value)
    return; 

  Backup();
  myValue->SetValue(index, value);
}


//=======================================================================
//function : GetValue
//purpose  : 
//=======================================================================

TCollection_ExtendedString TDataStd_ExtStringArray::Value (const Standard_Integer index) const 
{
  if(!myValue.IsNull())
    return myValue->Value(index); 
  else
    return 0;
}



//=======================================================================
//function : Lower
//purpose  : 
//=======================================================================
Standard_Integer TDataStd_ExtStringArray::Lower (void) const 
{ 
  if(!myValue.IsNull())
    return myValue->Lower(); 
  else
    return 0;
}


//=======================================================================
//function : Upper
//purpose  : 
//=======================================================================
Standard_Integer TDataStd_ExtStringArray::Upper (void) const 
{ 
  if(!myValue.IsNull())
    return myValue->Upper(); 
  else
    return 0;
}


//=======================================================================
//function : Length
//purpose  : 
//=======================================================================
Standard_Integer TDataStd_ExtStringArray::Length (void) const 
{
  if(!myValue.IsNull())
    return myValue->Length(); 
  else
    return 0;
}



//=======================================================================
//function : ChangeArray
//purpose  : If value of <newArray> differs from <myValue>, Backup 
//         : performed and myValue refers to new instance of HArray1OfExtendedString
//         : that holds <newArray>
//=======================================================================

void TDataStd_ExtStringArray::ChangeArray(const Handle(TColStd_HArray1OfExtendedString)& newArray) 
{
  Standard_Integer aLower    = newArray->Lower();
  Standard_Integer anUpper   = newArray->Upper();
  Standard_Boolean aDimEqual = Standard_False;
  Standard_Integer i;
  if (Lower() == aLower && Upper() == anUpper)
  {
    aDimEqual = Standard_True;
    Standard_Boolean isEqual = Standard_True;
    for(i = aLower; i <= anUpper; i++) {
      if(myValue->Value(i) != newArray->Value(i)) {
	isEqual = Standard_False;
	break;
      }
    }
    if(isEqual)
      return;
  }

  Backup();

// Handles of myValue of current and backuped attributes will be different!!!
  if(!aDimEqual) 
    myValue = new TColStd_HArray1OfExtendedString(aLower, anUpper);
  for(i = aLower; i <= anUpper; i++) 
    myValue->SetValue(i, newArray->Value(i));  
}

//=======================================================================
//function : Array
//purpose  : 
//=======================================================================

Handle(TColStd_HArray1OfExtendedString) TDataStd_ExtStringArray::Array(void) const
{
  return myValue; 
}


//=======================================================================
//function : ID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_ExtStringArray::ID () const { return GetID(); }


//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) TDataStd_ExtStringArray::NewEmpty () const
{  
  return new TDataStd_ExtStringArray(); 
}

//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================

void TDataStd_ExtStringArray::Restore(const Handle(TDF_Attribute)& With) 
{
  Standard_Integer i, lower, upper;
  Handle(TDataStd_ExtStringArray) anArray = Handle(TDataStd_ExtStringArray)::DownCast(With);
  if(!anArray->myValue.IsNull()) {
    lower = anArray->Lower();
    upper = anArray->Upper(); 
    myValue = new TColStd_HArray1OfExtendedString(lower, upper);
    for(i = lower; i<=upper; i++)
      myValue->SetValue(i, anArray->Value(i)); 
  }
  else
    myValue.Nullify();
}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void TDataStd_ExtStringArray::Paste (const Handle(TDF_Attribute)& Into,
//				   const Handle(TDF_RelocationTable)& RT) const
				   const Handle(TDF_RelocationTable)& ) const
{
  if(!myValue.IsNull()) {
    Handle(TDataStd_ExtStringArray) anArray = Handle(TDataStd_ExtStringArray)::DownCast(Into);
    if(!anArray.IsNull())
      anArray->ChangeArray( myValue );
  }
}

//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TDataStd_ExtStringArray::Dump (Standard_OStream& anOS) const
{  
  anOS << "ExtStringArray";
  return anOS;
}

