// File:	TDataStd_Constraint.cxx<2>
// Created:	Tue Jul 29 15:27:09 1997
// Author:	Denis PASCAL

#include <TDataStd_Constraint.ixx>
#include <TDataStd.hxx>
#include <TDF_ChildIterator.hxx>
#include <TDataStd_ConstraintEnum.hxx>
#include <TopoDS_Shape.hxx>
//
//
// for symmetry midpoint the third argument is the axis or the point


//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Constraint::GetID () 
{ 
  static Standard_GUID TDataStd_ConstraintID("2a96b602-ec8b-11d0-bee7-080009dc3333");
  return TDataStd_ConstraintID; 
}


//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_Constraint) TDataStd_Constraint::Set (const TDF_Label& L)
{
  Handle (TDataStd_Constraint) A;
  if (!L.FindAttribute (TDataStd_Constraint::GetID (), A)) {    
    A = new TDataStd_Constraint ();
    L.AddAttribute(A);
  }
  return A;
}


//=======================================================================
//function : TDataStd_Constraint
//purpose  : 
//=======================================================================

TDataStd_Constraint::TDataStd_Constraint()
     : myType           (TDataStd_RADIUS),
       myIsReversed     (Standard_False),
       myIsInverted     (Standard_False),
       myIsVerified     (Standard_True)
{}

 //=======================================================================
 //function : Set
 //purpose  : 
 //=======================================================================

 void TDataStd_Constraint::Set(const TDataStd_ConstraintEnum type,
 			      const Handle(TNaming_NamedShape)& G1) 
 {
   // OCC2932 correction
   if(myType == type)
   {
     Handle(TNaming_NamedShape) aShape =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[0]);
     if (aShape.IsNull() == Standard_False && G1.IsNull() == Standard_False)
       if (aShape -> Get() == G1 -> Get()) 
         return;
   }

   Backup();
   myType = type;
   myGeometries[0] = G1;
 }

// =======================================================================
 //function : Set
 //purpose  : 
 //=======================================================================

 void TDataStd_Constraint::Set(const TDataStd_ConstraintEnum type,
 			       const Handle(TNaming_NamedShape)& G1,
 			       const Handle(TNaming_NamedShape)& G2) 
 {   
   // OCC2932 correction
   if(myType == type)
   {
     Handle(TNaming_NamedShape) aShape1 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[0]);
     Handle(TNaming_NamedShape) aShape2 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[1]);
     if (aShape1.IsNull() == Standard_False && G1.IsNull() == Standard_False &&
         aShape2.IsNull() == Standard_False && G2.IsNull() == Standard_False)
       if (aShape1->Get() == G1->Get() && aShape2->Get() == G2->Get())
         return;
   }

   Backup(); 
   myType = type;
   myGeometries[0] = G1; 
   myGeometries[1] = G2;
 }

 //=======================================================================
 //function : Set
 //purpose  : 
 //=======================================================================

 void TDataStd_Constraint::Set(const TDataStd_ConstraintEnum type,
 			      const Handle(TNaming_NamedShape)& G1,
 			      const Handle(TNaming_NamedShape)& G2,
 			      const Handle(TNaming_NamedShape)& G3) 
 {   
   // OCC2932 correction
   if (myType == type)
   {
     Handle(TNaming_NamedShape) aShape1 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[0]);
     Handle(TNaming_NamedShape) aShape2 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[1]);
     Handle(TNaming_NamedShape) aShape3 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[2]);
     if (aShape1.IsNull() == Standard_False && G1.IsNull() == Standard_False &&
         aShape2.IsNull() == Standard_False && G2.IsNull() == Standard_False &&
         aShape3.IsNull() == Standard_False && G3.IsNull() == Standard_False)
       if (aShape1->Get() == G1->Get() &&
           aShape2->Get() == G2->Get() &&
           aShape3->Get() == G3->Get())
         return;
   }

   Backup(); 
   myType = type;
   myGeometries[0] = G1; 
   myGeometries[1] = G2;  
   myGeometries[2] = G3;
 }

 //=======================================================================
 //function : Set
 //purpose  : 
 //=======================================================================

 void TDataStd_Constraint::Set(const TDataStd_ConstraintEnum type,
			      const Handle(TNaming_NamedShape)& G1,
 			      const Handle(TNaming_NamedShape)& G2,
 			      const Handle(TNaming_NamedShape)& G3,
 			      const Handle(TNaming_NamedShape)& G4)
 {   
   // OCC2932 correction
   if (myType == type)
   {
     Handle(TNaming_NamedShape) aShape1 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[0]);
     Handle(TNaming_NamedShape) aShape2 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[1]);
     Handle(TNaming_NamedShape) aShape3 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[2]);
     Handle(TNaming_NamedShape) aShape4 =
       Handle(TNaming_NamedShape)::DownCast(myGeometries[3]);
     if (aShape1.IsNull() == Standard_False && G1.IsNull() == Standard_False &&
         aShape2.IsNull() == Standard_False && G2.IsNull() == Standard_False &&
         aShape3.IsNull() == Standard_False && G3.IsNull() == Standard_False &&
         aShape4.IsNull() == Standard_False && G4.IsNull() == Standard_False)
       if (aShape1->Get() == G1->Get() &&
           aShape2->Get() == G2->Get() &&
           aShape3->Get() == G3->Get() &&
           aShape3->Get() == G4->Get())
         return;
   }

   Backup(); 
   myType = type;
   myGeometries[0] = G1; 
   myGeometries[1] = G2;   
   myGeometries[2] = G3;
   myGeometries[3] = G4;  
 }

//=======================================================================
//function : SetPlane
//purpose  : 
//=======================================================================
void TDataStd_Constraint::SetPlane(const Handle(TNaming_NamedShape)& plane)
{
  // OCC2932 correction
  Handle(TNaming_NamedShape) aPlane =
    Handle(TNaming_NamedShape)::DownCast(myPlane);
  if (aPlane.IsNull() == Standard_False && plane.IsNull() == Standard_False)
    if ( aPlane -> Get() == plane->Get())
      return;

  Backup();
  myPlane = plane;
}

//=======================================================================
//function : Plane
//purpose  : 
//=======================================================================
const Handle(TNaming_NamedShape)&  TDataStd_Constraint::GetPlane() const 
{
  return (Handle(TNaming_NamedShape)&) myPlane;
}

//=======================================================================
//function : SetType 
//purpose  : 
//=======================================================================

void TDataStd_Constraint::SetType (const TDataStd_ConstraintEnum CTR) 
{  
  // OCC2932 correction
  if(myType = CTR) return;

  Backup();
  myType = CTR;
}


//=======================================================================
//function : GetType
//purpose  : 
//=======================================================================

TDataStd_ConstraintEnum TDataStd_Constraint::GetType () const
{
  return myType;
}


//=======================================================================
//function : ClearGeometries
//purpose  : 
//=======================================================================

void TDataStd_Constraint::ClearGeometries () 
{   
  // OCC2932 correction
  if(myGeometries[0].IsNull() && myGeometries[1].IsNull() && 
     myGeometries[2].IsNull() && myGeometries[3].IsNull()) 
    return;


  Backup();
  (myGeometries [0]).Nullify ();
  (myGeometries [1]).Nullify ();
  (myGeometries [2]).Nullify ();
  (myGeometries [3]).Nullify ();
}


//=======================================================================
//function : SetGeometry
//purpose  : 
//=======================================================================

void TDataStd_Constraint::SetGeometry (const Standard_Integer Index, 
				       const Handle(TNaming_NamedShape)& G) 
{  
  // OCC2932 correction
  Handle(TNaming_NamedShape) aGeom =
    Handle(TNaming_NamedShape)::DownCast(myGeometries[Index - 1]);
  if (aGeom.IsNull() == Standard_False && G.IsNull() == Standard_False) 
    if (aGeom -> Get() == G->Get())
      return;

  Backup();
  myGeometries [Index-1] = G;
}


//=======================================================================
//function : GetGeometry
//purpose  : 
//=======================================================================

Handle(TNaming_NamedShape) TDataStd_Constraint::GetGeometry
                                        (const Standard_Integer Index) const
{
  return Handle(TNaming_NamedShape)::DownCast (myGeometries [Index-1]);
}


//=======================================================================
//function : NbGeometries
//purpose  : 
//=======================================================================

Standard_Integer TDataStd_Constraint::NbGeometries () const 
{
  Standard_Integer num_geom = 0 ;
  while (num_geom < 4 && ! myGeometries[num_geom].IsNull()) {
      num_geom += 1 ;
  }
  return num_geom ;
}


//=======================================================================
//function : IsDimension
//purpose  : 
//=======================================================================
Standard_Boolean TDataStd_Constraint::IsDimension () const 
{
  return !myValue.IsNull();
}


//=======================================================================
//function : IsPlanar
//purpose  : 
//=======================================================================
Standard_Boolean TDataStd_Constraint::IsPlanar () const 
{
  return !myPlane.IsNull();
}

//=======================================================================
//function : SetValue
//purpose  : 
//=======================================================================

void TDataStd_Constraint::SetValue (const Handle(TDataStd_Real)& V) 
{
  // OCC2932 correction
  if (myValue.IsNull() == Standard_False && V.IsNull() == Standard_False)
    if(myValue->Get() == V->Get()) return;

  Backup();
  myValue = V;
}

//=======================================================================
//function : GetValue
//purpose  : 
//=======================================================================

const Handle(TDataStd_Real)& TDataStd_Constraint::GetValue () const
{
  return myValue;
}


//=======================================================================
//function : ID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Constraint::ID () const { return GetID(); }


//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) TDataStd_Constraint::NewEmpty () const
{  
  return new TDataStd_Constraint (); 
}


//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================

void TDataStd_Constraint::Restore(const Handle(TDF_Attribute)& with) 
{
  Handle(TDataStd_Constraint) CTR =Handle(TDataStd_Constraint)::DownCast(with); 
  myGeometries [0] = CTR->GetGeometry (1);
  myGeometries [1] = CTR->GetGeometry (2);
  myGeometries [2] = CTR->GetGeometry (3);
  myGeometries [3] = CTR->GetGeometry (4);
  myType = CTR->GetType ();
  myValue = CTR->GetValue ();
  myIsVerified = CTR->Verified();
  myIsInverted = CTR->Inverted();
  myIsReversed = CTR->Reversed();
  myPlane = CTR->GetPlane();
}



//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void TDataStd_Constraint::Paste (const Handle(TDF_Attribute)& into,
				 const Handle(TDF_RelocationTable)& RT) const
{  
  Handle(TDataStd_Constraint) CTR =Handle(TDataStd_Constraint)::DownCast (into);
  Handle(TNaming_NamedShape) G1, G2, G3, G4, plane;  
  RT->HasRelocation (myGeometries[0], G1);
  CTR->SetGeometry (1, G1);
  RT->HasRelocation (myGeometries[1], G2);
  CTR->SetGeometry (2, G2);
  RT->HasRelocation (myGeometries[2], G3);
  CTR->SetGeometry (3, G3);
  RT->HasRelocation (myGeometries[3], G4);
  CTR->SetGeometry (4, G4);

  RT->HasRelocation (myPlane, plane);
  CTR->SetPlane(plane);

  Handle(TDataStd_Real) Value;
  RT->HasRelocation (myValue,Value);
  CTR->SetValue (Value);

  CTR->SetType (myType);
  CTR->Verified(Verified());
  CTR->Inverted(Inverted());
  CTR->Reversed(Reversed());
}    


//=======================================================================
//function : References
//purpose  : 
//=======================================================================

void TDataStd_Constraint::References(const Handle(TDF_DataSet)& DS) const

{ 
//bidouille en attendant traitement des contraintes d assemblage en dehors de la part 
// l attribut placement devrait oriente vers les contraintes de placement en dehors
  Standard_Integer Lim;
  if (myType >= TDataStd_MATE && myType<=TDataStd_FACES_ANGLE)  Lim =1;
  else Lim =3;

  for (Standard_Integer i=0; i<=Lim; i++) {
    if (!myGeometries [i].IsNull()) DS->AddAttribute (myGeometries[i]);
  }

  if (!myValue.IsNull()) DS->AddAttribute (myValue);
  if (!myPlane.IsNull()) DS->AddAttribute (myPlane);
}

//=======================================================================
//function : Verified
//purpose  : 
//=======================================================================
void TDataStd_Constraint::Verified(const Standard_Boolean status)
{
  // OCC2932 correction
  if(myIsVerified == status) return;

  Backup();
  myIsVerified = status;
}

//=======================================================================
//function : Verified
//purpose  : 
//=======================================================================
Standard_Boolean TDataStd_Constraint::Verified() const 
{
  return myIsVerified;
}

//=======================================================================
//function : Reversed
//purpose  : 
//=======================================================================
void TDataStd_Constraint::Reversed(const Standard_Boolean status)
{
  // OCC2932 correction
  if(myIsReversed == status ) return;

  Backup();
  myIsReversed = status;
}

//=======================================================================
//function : Reversed
//purpose  : 
//=======================================================================
Standard_Boolean TDataStd_Constraint::Reversed() const 
{
  return myIsReversed;
}

//=======================================================================
//function : Inverted
//purpose  : 
//=======================================================================
void TDataStd_Constraint::Inverted(const Standard_Boolean status)
{
  // OCC2932 correction
  if(myIsInverted == status) return;

  Backup();
  myIsInverted = status;
}

//=======================================================================
//function : Inverted
//purpose  : 
//=======================================================================
Standard_Boolean TDataStd_Constraint::Inverted() const 
{
  return myIsInverted;
}


//=======================================================================
//function : CollectChildConstraints
//purpose  : 
//=======================================================================

void TDataStd_Constraint::CollectChildConstraints(const TDF_Label& aLabel,
						  TDF_LabelList& LL)  
{
  TDF_ChildIterator it(aLabel,Standard_True);
  Handle(TDataStd_Constraint) aConstraint;
  for (; it.More(); it.Next()) {
    if (it.Value().FindAttribute(TDataStd_Constraint::GetID(), aConstraint)) {
      LL.Append(it.Value());
    }
  }
  
}


//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TDataStd_Constraint::Dump (Standard_OStream& anOS) const
{  
  anOS << "Constraint ";
  TDataStd::Print(GetType(),anOS);
  return anOS;
}

