/*
C**NOTICE
C  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH.
C  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR
C  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE
C  SITE WHERE IT IS INSTALLED BY CISIGRAPH
C**NOTICE
C
C*********************************************************************
C
C     FONCTION :
C     ----------
C        Transfert une zone memoire dans une autre en gerant les 
C        recouvrements
C
C     MOTS CLES :
C     -----------
C        MANIPULATION, MEMOIRE, TRANSFERT, CARACTERE
C
C     ARGUMENTS D'ENTREE :
C     ------------------
C        nb_car    : integer*4  nombre de caracteres a transferer.
C        source    : zone memoire source.
C             
C     ARGUMENTS DE SORTIE :
C     -------------------
C        dest      : zone memeoire destination.
C
C     COMMONS UTILISES :
C     ----------------
C
C     REFERENCES APPELEES :
C     -------------------
C
C     DEMSCRIPTION/REMARQUES/LIMITATIONS :
C     -----------------------------------
C        Routine portable UNIX (SGI, ULTRIX, BULL)
C
C$    HISTORIQUE DES MODIFICATIONS :
C     ----------------------------
C     24/01/92 : DGZ ; Recuperation de la version BULL
C>
C**********************************************************************
*/

#include <string.h>

#include <Data_f2c.h>
#include <SysBase.h>
#define ABS(a)  (((a)<0)?(-(a)):(a)) 
__SysBase_API void mcrfill_(size, tin, tout)
integer *size;
char *tin, *tout;
{
/*	extern char memcpy();*/
/*	if (ABS(tout-tin) >= *size) (void)memcpy(tout, tin, *size);*/
	if (ABS(tout-tin) >= *size)
          memcpy( tout, tin, *size);
	else if (tin > tout)
	{
		register integer n = *size;
		register char *jmin=tin;
		register char *jmout=tout;
		while (n-- > 0) *jmout++ = *jmin++;
	}
	else
	{
		register integer n = *size;
		register char *jmin=tin+n;
		register char *jmout=tout+n;
		while (n-- > 0) *--jmout = *--jmin;
	}
}
