// File:	StepToGeom_MakeSurfaceOfRevolution.cxx
// Created:	Mon Jul  5 10:37:59 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakeSurfaceOfRevolution.ixx>
#include <StepGeom_SurfaceOfRevolution.hxx>
#include <Geom_SurfaceOfRevolution.hxx>
#include <Geom_Axis1Placement.hxx>
#include <StepToGeom_MakeAxis1Placement.hxx>
#include <Geom_Curve.hxx>
#include <Geom_Circle.hxx>
#include <Geom_Ellipse.hxx>
#include <Geom_TrimmedCurve.hxx>
#include <StepToGeom_MakeCurve.hxx>
#include <gp_Ax1.hxx>
#include <gp_Pnt.hxx>
#include <gp_Dir.hxx>
#include <gp_Lin.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' une SurfaceOfRevolution de Geom a partir d' une
// SurfaceOfRevolution de Step
//=============================================================================

StepToGeom_MakeSurfaceOfRevolution::StepToGeom_MakeSurfaceOfRevolution
  ( const Handle(StepGeom_SurfaceOfRevolution)& S)
{

  Handle(StepGeom_Curve)          C;
  Handle(Geom_Curve)              C1;
  Handle(StepGeom_Axis1Placement) A;
  Handle(Geom_Axis1Placement)     A1;
  gp_Ax1                          A2;

  C  = S->SweptCurve();
  StepToGeom_MakeCurve MkCurve(C);
  C1 = MkCurve.Value();
  A  = S->AxisPosition();
  StepToGeom_MakeAxis1Placement MkAxis1(A);
  A1 = MkAxis1.Value();
  A2 = A1->Ax1();
  //skl for OCC952 (one bad case revolution of circle)
  if ( C1->IsKind(STANDARD_TYPE(Geom_Circle)) || C1->IsKind(STANDARD_TYPE(Geom_Ellipse)) ) {
    Handle(Geom_Conic) conic = Handle(Geom_Conic)::DownCast(C1);
    gp_Pnt pc = conic->Location();
    gp_Lin rl (A2);
    if(rl.Distance(pc)<Precision::Confusion()) { //pc lies on A2
      gp_Dir dirline = A2.Direction();
      gp_Dir norm = conic->Axis().Direction();
      if( dirline.IsNormal(norm,Precision::Angular()) ) { //A2 lies on plane of circle
        //change parametrization for trimming
        gp_Ax2 axnew(pc,norm,dirline.Reversed());
        conic->SetPosition(axnew);
        C1 = new Geom_TrimmedCurve(conic, 0, PI);
      }
    }
  }
  theSurfaceOfRevolution = new Geom_SurfaceOfRevolution(C1, A2);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_SurfaceOfRevolution) &
      StepToGeom_MakeSurfaceOfRevolution::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theSurfaceOfRevolution;
}
