// File:	StepToGeom_MakeElementarySurface.cxx
// Created:	Fri Jul  2 17:38:21 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
//:p0 abv 19.02.99: management of 'done' flag improved

#include <StepToGeom_MakeElementarySurface.ixx>
#include <StepGeom_ElementarySurface.hxx>
#include <StepGeom_CylindricalSurface.hxx>
#include <StepGeom_ConicalSurface.hxx>
#include <StepGeom_SphericalSurface.hxx>
#include <StepGeom_ToroidalSurface.hxx>
#include <StepGeom_Plane.hxx>
#include <StepToGeom_MakeCylindricalSurface.hxx>
#include <StepToGeom_MakeConicalSurface.hxx>
#include <StepToGeom_MakeSphericalSurface.hxx>
#include <StepToGeom_MakeToroidalSurface.hxx>
#include <StepToGeom_MakePlane.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' une ElementarySurface de Geom a partir d' une 
// ElementarySurface de Step
//=============================================================================

StepToGeom_MakeElementarySurface::StepToGeom_MakeElementarySurface
  ( const Handle(StepGeom_ElementarySurface)& S)
{
  done = Standard_False;
  if (S->IsKind(STANDARD_TYPE(StepGeom_CylindricalSurface))) {
    Handle(StepGeom_CylindricalSurface) Sur = 
      Handle(StepGeom_CylindricalSurface)::DownCast(S);
    StepToGeom_MakeCylindricalSurface MkCylindrical(Sur);
    if ( MkCylindrical.IsDone() ) theElementarySurface = MkCylindrical.Value();
  }
  else if (S->IsKind(STANDARD_TYPE(StepGeom_ConicalSurface))) {
    Handle(StepGeom_ConicalSurface) Sur = 
      Handle(StepGeom_ConicalSurface)::DownCast(S);
    StepToGeom_MakeConicalSurface MkConical(Sur);
    if ( MkConical.IsDone() ) theElementarySurface = MkConical.Value();
  }
  else if (S->IsKind(STANDARD_TYPE(StepGeom_SphericalSurface))) {
    Handle(StepGeom_SphericalSurface) Sur = 
      Handle(StepGeom_SphericalSurface)::DownCast(S);
    StepToGeom_MakeSphericalSurface MkSpherical(Sur);
    if ( MkSpherical.IsDone() ) theElementarySurface = MkSpherical.Value();
  }
  else if (S->IsKind(STANDARD_TYPE(StepGeom_ToroidalSurface))) {
    Handle(StepGeom_ToroidalSurface) Sur = 
      Handle(StepGeom_ToroidalSurface)::DownCast(S);
    StepToGeom_MakeToroidalSurface MkToroidal(Sur);
    if ( MkToroidal.IsDone() ) theElementarySurface = MkToroidal.Value();
  }
  else   if (S->IsKind(STANDARD_TYPE(StepGeom_Plane))) {
    Handle(StepGeom_Plane) Sur = 
      Handle(StepGeom_Plane)::DownCast(S);
    StepToGeom_MakePlane MkPlane(Sur);
    if ( MkPlane.IsDone() ) theElementarySurface = MkPlane.Value();
  }
  done = ! theElementarySurface.IsNull();
}	 

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_ElementarySurface) &
      StepToGeom_MakeElementarySurface::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theElementarySurface;
}
