
#include <math.h>
#include <OpenGl_tgl_all.h>
#include <InterfaceGraphic_Graphic3d.hxx>
#include <OpenGl_tgl.h>
#include <OpenGl_tgl_funcs.h>
#include <OpenGl_tgl_utilgr.h>

void EXPORT
call_togl_text
(
	CALL_DEF_GROUP * agroup,
	CALL_DEF_TEXT * atext
)
{
Tint path;
Tfloat up_vect[2];
TEL_POINT text_pt;
Tint hor_align, ver_align;

	up_vect[0] = ( float )cos (atext->Angle);
	up_vect[1] = ( float )sin (atext->Angle);

	switch (atext->Path) {
		case 0: /* Graphic3d_TP_UP */
			path = CALL_PHIGS_PATH_UP;
		break;
		case 1: /* Graphic3d_TP_DOWN */
			path = CALL_PHIGS_PATH_DOWN;
		break;
		case 2: /* Graphic3d_TP_LEFT */
			path = CALL_PHIGS_PATH_LEFT;
		break;
		case 3: /* Graphic3d_TP_RIGHT */
			path = CALL_PHIGS_PATH_RIGHT;
		break;
		default:
			path = CALL_PHIGS_PATH_RIGHT;
		break;
	}

	switch (atext->HAlign) {
		case 0: /* Graphic3d_HTA_NORMAL */
			hor_align = CALL_PHIGS_HOR_NORM;
		break;
		case 1: /* Graphic3d_HTA_LEFT */
			hor_align = CALL_PHIGS_HOR_LEFT;
		break;
		case 2: /* Graphic3d_HTA_CENTER */
			hor_align = CALL_PHIGS_HOR_CTR;
		break;
		case 3: /* Graphic3d_HTA_RIGHT */
			hor_align = CALL_PHIGS_HOR_RIGHT;
		break;
		default:
			hor_align = CALL_PHIGS_HOR_NORM;
		break;
	}

	switch (atext->VAlign) {
		case 0: /* Graphic3d_VTA_NORMAL */
			ver_align = CALL_PHIGS_VERT_NORM;
		break;
		case 1: /* Graphic3d_VTA_TOP */
			ver_align = CALL_PHIGS_VERT_TOP;
		break;
		case 2: /* Graphic3d_VTA_CAP */
			ver_align = CALL_PHIGS_VERT_CAP;
		break;
		case 3: /* Graphic3d_VTA_HALF */
			ver_align = CALL_PHIGS_VERT_HALF;
		break;
		case 4: /* Graphic3d_VTA_BASE */
			ver_align = CALL_PHIGS_VERT_BASE;
		break;
		case 5: /* Graphic3d_VTA_BOTTOM */
			ver_align = CALL_PHIGS_VERT_BOTTOM;
		break;
		default:
			ver_align = CALL_PHIGS_VERT_NORM;
		break;
	}

	text_pt.xyz[0] = atext->Position.x;
	text_pt.xyz[1] = atext->Position.y;
	text_pt.xyz[2] = atext->Position.z;

	if (! agroup->IsOpen) call_togl_opengroup (agroup);
	call_func_set_anno_char_ht (atext->Height);
	call_func_set_anno_char_up_vec (up_vect);
	call_func_set_anno_path (path);
	call_func_set_anno_align (hor_align, ver_align);
	call_func_anno_text_rel3 (&text_pt, atext->string);
	if (! agroup->IsOpen) call_togl_closegroup (agroup);
	return;
}
