
#include <OpenGl_tgl_all.h>

#include <stddef.h>
#include <stdio.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include <OpenGl_cmn_varargs.h>
#include <OpenGl_cmn_memory.h>
#include <OpenGl_cmn_htbl.h>
#include <OpenGl_telem_attri.h>
#include <OpenGl_tsm.h>
#include <OpenGl_telem.h>
#include <OpenGl_telem_inquire.h>

static  TStatus  ApplicationDataAdd( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  ApplicationDataPrint( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  ApplicationDataInquire( TSM_ELEM_DATA, Tint, cmn_key* );

static  TStatus  (*MtdTbl[])( TSM_ELEM_DATA, Tint, cmn_key* ) =
{
    0,             /* PickTraverse */
    0,             /* Display */
    ApplicationDataAdd,
    0,             /* Delete */
    ApplicationDataPrint,
    ApplicationDataInquire
};


MtblPtr
TelApplicationDataInitClass( TelType *el )
{
   *el = TelApplicationData;
   return MtdTbl;
}

static  TStatus
ApplicationDataAdd( TSM_ELEM_DATA d, Tint n, cmn_key *k )
{
    ((tsm_elem_data)(d.pdata))->pdata = k[0]->data.pdata;

    return TSuccess;
}


static  TStatus
ApplicationDataPrint( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    fprintf( stdout, "TelApplicationData. Value = %lx\n",(long ) data.pdata);
    fprintf( stdout, "\n" );

    return TSuccess;
}


static TStatus
ApplicationDataInquire( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
   Tint i;

   for( i = 0; i < n; i++ )
   {
      switch( k[i]->id )
      {
	 case INQ_GET_SIZE_ID:
	 {
	    k[i]->data.ldata = sizeof( Tint );
	    break;
	 }
	 case INQ_GET_CONTENT_ID:
	 {
	    TEL_INQ_CONTENT *c;
	    Teldata         *w;

	    c = k[i]->data.pdata;
	    w = c->data;
            c->act_size = 0;
	    w->data = data.pdata;
	    break;
	 }
      }
   }

   return TSuccess;
}
