#include <Standard_Stream.hxx>

#include <Message_OutFile.ixx>


//  ATTENTION : un objet CDL qui designe un OStream ...
//  Bien sur, pas de "champ" OStream en direct : taille inconnue
//  Par consequent, on veut un CHAMP de type  OStream*  (pointeur sur OStream)
//  Fort bien. Mais en CDL cela signifie un "void*" a caster soi-meme

//  Eh bien ceci ne suffit pas, pour une raison mal elucidee :
//  Le casting inverse (void* -> OStream&) marche mal ...
//  sur  cout  c`est OK, mais sur un  ofstream cree, non ...

//  Que fait-on alors : le void* designe une cellule qui elle designe pour de
//  bon le OStream* . intellectuel non ?


struct dummy_stream { Standard_OStream* stream; };


//=======================================================================
//function : Message_OutFile
//purpose  : 
//=======================================================================

Message_OutFile::Message_OutFile () :
       // myStream (&cout) ,
       myFileMode (Standard_False), myFileOpen (Standard_True)
{
  struct dummy_stream* astr = new dummy_stream;
  astr->stream = &cout;
  myStream = astr;
}

//=======================================================================
//function : Message_OutFile
//purpose  : 
//=======================================================================

Message_OutFile::Message_OutFile (const Standard_CString filename,
					  const Standard_Boolean Aappend) :
       // myStream (new ofstream (filename, (Aappend ? ios::app : ios::out)) ) ,
       myFileMode (Standard_True), myFileOpen (Standard_True), myName (filename)
{
  struct dummy_stream* astr = new dummy_stream;
  astr->stream = new ofstream (filename, (Aappend ? ios::app : ios::out));
  if (!astr->stream) {
    astr->stream = &cout;
    myFileMode = myFileOpen = Standard_False;
    myName.Clear();
  }
  myStream = astr;
}

//=======================================================================
//function : Destroy
//purpose  : 
//=======================================================================

 void Message_OutFile::Destroy ()
{
//  if (!myFileOpen || !myFileMode) return;
  struct dummy_stream* astr = (struct dummy_stream*) myStream;
  if ( astr->stream && myFileMode ) {
    ofstream& S = *(ofstream*) astr->stream;
    //ofstream& S = *(ofstream*) myStream;
    S.close();
    delete (ofstream*) astr->stream;
  }
  delete astr;
  myStream = 0;
}

//=======================================================================
//function : Out
//purpose  : 
//=======================================================================

 Standard_OStream&  Message_OutFile::Out ()
//      {  return * (Standard_OStream*) myStream;  }
{
  //  Standard_OStream& S = * (Standard_OStream*) myStream;
  struct dummy_stream* astr = (struct dummy_stream*) myStream;
//  if (myFileMode) {
    //svv #2 ofstream& S = *(ofstream*)  astr->stream;  // (ofstream*) myStream;
    ////    S << "Appel Message_OutFile::Out"<<endl;
//  }
  return *(astr->stream);  //  * (Standard_OStream*) myStream;
}
