/* MFMCB3.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mmfmcb3_(ncofmx, ndimen, courb1, ncoeff, courb2, iercod)
integer *ncofmx, *ndimen;
doublereal *courb1;
integer *ncoeff;
doublereal *courb2;
integer *iercod;
{
    /* System generated locals */
    integer courb1_dim1, courb1_offset, courb2_dim1, courb2_offset, i__1, 
	    i__2, i__3;

    /* Local variables */
    static doublereal tbaux[61];
    static integer nd;
    static doublereal bid;
    static integer ncf, ncj;
    extern /* Subroutine */ int maermsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Creation de la courbe COURB2(v) definie sur [-1,1] */
/*     identique a la courbe COURB1(u) definie sur [0,1] */
/*     (changement du parametre d' une courbe (NCOFMX,NDIMEN) ) */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS,AB_SPECIFI::COURBE&,LIMITATION,&COURBE */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*   NCOFMX : Nbre de coefficient maxi de la courbe. */
/*   NDIMEN   : Dimension de la courbe. */
/*   COURB1 : La courbe a limiter. */
/*   NCOEFF : Nbre de coefficients de la courbe. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*   COURB2 : La courbe relimitee, definie dans [-1,1] */
/*            et egale a COURB1 definie dans [0,1]. */
/*   IERCOD : = 0, OK */
/*            =10, Nbre de coeff. <1 ou > 61. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/* ---> L' ecrasement de l' argument d' entree COURB1 par COURB2 est */
/*     possible, c' est a dire que l' appel : */
/*      CALL MMFMCB3(NCOFMX,NDIMEN,CURVE,NCOEFF,CURVE,IERCOD) */
/*     est tout a fait LEGAL. */

/* ---> On traite les courbes de degres mathematique 0 a 60, pour NDIMEN 
*/
/*     quelconque. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     18-01-1990 : RBD ; Creation d' apres MMARC41. */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */

/*   Tableau auxiliaire des coefficients de (T+1)/2 a */
/*   la puissance N=1 a NCOEFF-1. */


/* ********************************************************************** 
*/
/*                CAS OU LE TRAITEMENT NE PEUT ETRE FAIT */
/* ********************************************************************** 
*/

    /* Parameter adjustments */
    courb2_dim1 = *ncofmx;
    courb2_offset = courb2_dim1 + 1;
    courb2 -= courb2_offset;
    courb1_dim1 = *ncofmx;
    courb1_offset = courb1_dim1 + 1;
    courb1 -= courb1_offset;

    /* Function Body */
    *iercod = 0;

/* ------------ Nbre de coefficients trop petit ou trop grand ----------- 
*/

    if (*ncoeff > 61 || *ncoeff < 1) {
	*iercod = 10;
	goto L9999;
    }

/* ********************************************************************** 
*/
/*                          TRAITEMENT */
/* ********************************************************************** 
*/

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	courb2[nd * courb2_dim1 + 1] = courb1[nd * courb1_dim1 + 1];
/* L100: */
    }
    if (*ncoeff == 1) {
	goto L9999;
    }
    tbaux[0] = .5;
    tbaux[1] = .5;

/* ----------------------- Calcul des coeff. de COURB2 ------------------ 
*/

    i__1 = *ncoeff - 1;
    for (ncf = 2; ncf <= i__1; ++ncf) {

/* ------------ Prise en compte du NCF-ieme coeff. de COURB1 --------
---- */

	i__2 = *ndimen;
	for (nd = 1; nd <= i__2; ++nd) {
	    bid = courb1[ncf + nd * courb1_dim1];
	    i__3 = ncf - 1;
	    for (ncj = 1; ncj <= i__3; ++ncj) {
		courb2[ncj + nd * courb2_dim1] += bid * tbaux[ncj - 1];
/* L400: */
	    }
	    courb2[ncf + nd * courb2_dim1] = bid * tbaux[ncf - 1];
/* L300: */
	}


/* --------- Calcul des (NCF+1) coeff. de [(t + 1)/2]**(NCF) --------
---- */

	tbaux[ncf] = tbaux[ncf - 1] * .5;
	for (ncj = ncf; ncj >= 2; --ncj) {
	    tbaux[ncj - 1] = (tbaux[ncj - 1] + tbaux[ncj - 2]) * .5;
/* L500: */
	}
	tbaux[0] *= .5;

/* L200: */
    }

/* -------------- Prise en compte du dernier coeff. de COURB1 ----------- 
*/

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	bid = courb1[*ncoeff + nd * courb1_dim1];
	i__2 = *ncoeff - 1;
	for (ncj = 1; ncj <= i__2; ++ncj) {
	    courb2[ncj + nd * courb2_dim1] += tbaux[ncj - 1] * bid;
/* L700: */
	}
	courb2[*ncoeff + nd * courb2_dim1] = bid * tbaux[*ncoeff - 1];
/* L600: */
    }

/* ---------------------------- The end --------------------------------- 
*/

L9999:
    if (*iercod > 0) {
	maermsg_("MMFMCB3", iercod, 7L);
    }
    return 0;
} /* mmfmcb3_ */

