// File:	MDataStd_GeometryRetrievalDriver.cxx
// Created:	Wed Nov 19 15:59:14 1997
// Author:	Denis PASCAL
//		<dp@dingox.paris1.matra-dtv.fr>


#include <MDataStd_GeometryRetrievalDriver.ixx>
#include <TDataStd_GeometryEnum.hxx>
#include <TDataStd_Geometry.hxx>
#include <PDataStd_Geometry.hxx>
#include <MDataStd.hxx>
#include <CDM_MessageDriver.hxx>



//=======================================================================
//function : MDataStd_GeometryRetrievalDriver
//purpose  : 
//=======================================================================

MDataStd_GeometryRetrievalDriver::MDataStd_GeometryRetrievalDriver(const Handle(CDM_MessageDriver)& theMsgDriver):MDF_ARDriver(theMsgDriver)
{
}

//=======================================================================
//function : VersionNumber
//purpose  : 
//=======================================================================

Standard_Integer MDataStd_GeometryRetrievalDriver::VersionNumber() const
{ return 0; }


//=======================================================================
//function : SourceType
//purpose  : 
//=======================================================================

Handle(Standard_Type) MDataStd_GeometryRetrievalDriver::SourceType() const
{ return STANDARD_TYPE(PDataStd_Geometry);  }




//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) MDataStd_GeometryRetrievalDriver::NewEmpty() const
{ return new TDataStd_Geometry (); }



//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void MDataStd_GeometryRetrievalDriver::Paste (
  const Handle(PDF_Attribute)&        Source,
  const Handle(TDF_Attribute)&        Target,
//  const Handle(MDF_RRelocationTable)& RelocTable) const
  const Handle(MDF_RRelocationTable)& ) const
{
  Handle(PDataStd_Geometry) S = 
     Handle(PDataStd_Geometry)::DownCast (Source);
  Handle(TDataStd_Geometry) T = 
    Handle(TDataStd_Geometry)::DownCast (Target);

  T->SetType (MDataStd::IntegerToGeometryType (S->GetType ()));
}



