
#define VIRTUAL

// File		Graphic3d_GraphicDriver_3.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL
//      02.15.100 : JR : Clutter

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <Graphic3d_GraphicDriver.jxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::ClearGroup (const Graphic3d_CGroup& ) {
#else
void Graphic3d_GraphicDriver::ClearGroup (const Graphic3d_CGroup& ACGroup) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_cleargroup");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_cleargroup");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_cleargroup (&MyCGroup);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::CloseGroup (const Graphic3d_CGroup& ) {
#else
void Graphic3d_GraphicDriver::CloseGroup (const Graphic3d_CGroup& ACGroup) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_closegroup");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_closegroup");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_closegroup (&MyCGroup);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::FaceContextGroup (const Graphic3d_CGroup& , const Standard_Integer NoInsert) {
#else
void Graphic3d_GraphicDriver::FaceContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_facecontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_facecontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_facecontextgroup (&MyCGroup, int (NoInsert));

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Group (Graphic3d_CGroup& ) {
#else
void Graphic3d_GraphicDriver::Group (Graphic3d_CGroup& ACGroup) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_group");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_group");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_group (&MyCGroup);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::LineContextGroup (const Graphic3d_CGroup& , const Standard_Integer ) {
#else
void Graphic3d_GraphicDriver::LineContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_linecontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_linecontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_linecontextgroup (&MyCGroup, int (NoInsert));

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::MarkerContextGroup (const Graphic3d_CGroup& , const Standard_Integer ) {
#else
void Graphic3d_GraphicDriver::MarkerContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_markercontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_markercontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_markercontextgroup (&MyCGroup, int (NoInsert));

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::MarkerContextGroup (const Graphic3d_CGroup& , const Standard_Integer, const Standard_Integer, const Standard_Integer, const Handle(Graphic3d_HArray1OfBytes)& ) {
#else
void Graphic3d_GraphicDriver::MarkerContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert, const Standard_Integer AMarkWidth, const Standard_Integer AMarkHeight, const Handle(Graphic3d_HArray1OfBytes)& ) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_markercontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_markercontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_markercontextgroup (&MyCGroup, int (NoInsert));

#endif
}


#ifdef VIRTUAL
void Graphic3d_GraphicDriver::OpenGroup (const Graphic3d_CGroup& ) {
#else
void Graphic3d_GraphicDriver::OpenGroup (const Graphic3d_CGroup& ACGroup) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_opengroup");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_opengroup");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_opengroup (&MyCGroup);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::RemoveGroup (const Graphic3d_CGroup& ) {
#else
void Graphic3d_GraphicDriver::RemoveGroup (const Graphic3d_CGroup& ACGroup) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_removegroup");
	    //fp = (void (*)(Graphic3d_CGroup *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_removegroup");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_removegroup (&MyCGroup);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::TextContextGroup (const Graphic3d_CGroup& , const Standard_Integer ) {
#else
void Graphic3d_GraphicDriver::TextContextGroup (const Graphic3d_CGroup& ACGroup, const Standard_Integer NoInsert) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_textcontextgroup");
	    //fp = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_textcontextgroup");
		PrintCGroup (MyCGroup, 1);
		PrintInteger ("NoInsert", NoInsert);
	}
	call_togl_textcontextgroup (&MyCGroup, int (NoInsert));

#endif
}
