
#define VIRTUAL

// File		Graphic3d_GraphicDriver_2.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL
//              15/09/97 ; PCT : ajout InquireTextureAvailable() pour les textures
//              11/97 ; CAL : retrait de la dependance avec math
//      02.15.100 : JR : Clutter

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <Graphic3d_GraphicDriver.jxx>

#include <TColStd_Array2OfReal.hxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

Standard_Integer Graphic3d_GraphicDriver::InquireLightLimit () {
#ifndef VIRTUAL

//static int (*fp) () = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_inquirelight");
	    //fp = (int (*)()) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_inquirelight");
	}
	Standard_Integer Result = call_togl_inquirelight ();
	if (MyTraceLevel) {
		PrintIResult ("call_togl_inquirelight", Result);
	}
	return Result;

#else
	return Standard_False;
#endif
}

void Graphic3d_GraphicDriver::InquireMat (const Graphic3d_CView&
#ifndef VIRTUAL
                                                                 ACView
#endif
                                          , TColStd_Array2OfReal&
#ifndef VIRTUAL
                                                                  AMatO
#endif
                                          , TColStd_Array2OfReal&
#ifndef VIRTUAL
                                                                  AMatM
#endif
                                         ) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

Standard_Integer i, j;

CALL_DEF_MATRIX4X4 ori_matrix;
CALL_DEF_MATRIX4X4 map_matrix;

//static int (*fp) (Graphic3d_CView *,
	//CALL_DEF_MATRIX4X4, CALL_DEF_MATRIX4X4) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_inquiremat");
	    //fp = (int (*)(Graphic3d_CView *,
		//CALL_DEF_MATRIX4X4, CALL_DEF_MATRIX4X4)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_inquiremat");
		PrintCView (MyCView, 1);
	}
	if (call_togl_inquiremat (&MyCView, ori_matrix, map_matrix) == 0)
		for (i=0; i<=3; i++)
		   for (j=0; j<=3; j++) {
			AMatO (i, j)	= Standard_Real (ori_matrix[i][j]);
			AMatM (i, j)	= Standard_Real (map_matrix[i][j]);
		   }
	else
		for (i=0; i<=3; i++)
		   for (j=0; j<=3; j++) {
			if (i == j) {
				AMatM (i, j)	= 1.0;
				AMatO (i, j)	= 1.0;
			}
			else {
				AMatM (i, j)	= 0.0;
				AMatO (i, j)	= 0.0;
			}
		   }

	if (MyTraceLevel) {
		PrintMatrix ("Orientation", AMatO);
		PrintMatrix ("Mapping", AMatM);
	}

#endif
}

Standard_Integer Graphic3d_GraphicDriver::InquirePlaneLimit () {
#ifndef VIRTUAL

//static int (*fp) () = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_inquireplane");
	    //fp = (int (*)()) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_inquireplane");
	}
	Standard_Integer Result = call_togl_inquireplane ();
	if (MyTraceLevel) {
		PrintIResult ("call_togl_inquireplane", Result);
	}
	return Result;
#else
	return Standard_False;
#endif
}

Standard_Integer Graphic3d_GraphicDriver::InquireViewLimit () {
#ifndef VIRTUAL

//static int (*fp) () = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_inquireview");
	    //fp = (int (*)()) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

	if (MyTraceLevel) {
		PrintFunction ("call_togl_inquireview");
	}
	Standard_Integer Result = call_togl_inquireview ();
	if (MyTraceLevel) {
		PrintIResult ("call_togl_inquireview", Result);
	}
	return Result;
#else
	return Standard_False;
#endif
}



Standard_Boolean Graphic3d_GraphicDriver::InquireTextureAvailable () {
#ifndef VIRTUAL
  return Standard_False;
#else
  return Standard_False;
#endif
}

