// File:	GeomInt_IntSS.cxx
// Created:	Fri Jan 27 10:46:42 1995
// Author:	Jacques GOUSSARD
//		<jag@topsn2>


#include <GeomInt_IntSS.ixx>

//#include <GeomInt_WLApprox.hxx>
//#include <AppParCurves_MultiBSpCurve.hxx>

//#include <IntPatch_TheGLineOfIntersection.hxx>
//#include <IntPatch_TheRLineOfIntersection.hxx>
//#include <IntPatch_TheWLineOfIntersection.hxx>
//#include <IntPatch_TheALineOfIntersection.hxx>
//#include <IntPatch_TheALineToWLineOfIntersection.hxx>

#include <Adaptor3d_TopolTool.hxx>
//#include <Adaptor2d_HLine2d.hxx>
//#include <gp_Lin2d.hxx>
//#include <gp_Pln.hxx>
//#include <ElSLib.hxx>

//#include <Geom_Line.hxx>
//#include <Geom_Circle.hxx>
//#include <Geom_Ellipse.hxx>
//#include <Geom_Parabola.hxx>
//#include <Geom_Hyperbola.hxx>
//#include <Geom_TrimmedCurve.hxx>
//#include <Geom2d_TrimmedCurve.hxx>
//#include <Geom_BSplineCurve.hxx>
//#include <Geom2d_BSplineCurve.hxx>

//#include <TColgp_Array1OfPnt.hxx>
//#include <TColgp_Array1OfPnt2d.hxx>
//#include <TColStd_Array1OfReal.hxx>
//#include <TColStd_Array1OfInteger.hxx>

#include <Standard_ConstructionError.hxx>
//#include <Precision.hxx>

#include <Geom_Surface.hxx>
#include <GeomAdaptor_Surface.hxx>
#include <GeomAdaptor_HSurface.hxx>
//#include <Adaptor3d_SurfacePtr.hxx>

//#include <GeomProjLib.hxx>
//#include <GeomLib_CheckBSplineCurve.hxx>
//#include <GeomLib_Check2dBSplineCurve.hxx>

#include <IntPatch_ThePointOfIntersection.hxx>
//#include <gce_MakeCirc.hxx>
//
//#include <IntPatch_Line.hxx>

//=======================================================================
//function : GeomInt_IntSS
//purpose  : 
//=======================================================================
  GeomInt_IntSS::GeomInt_IntSS ()
{
  myHS1 = new GeomAdaptor_HSurface ();
  myHS2 = new GeomAdaptor_HSurface ();
  myTolReached2d= myTolReached3d=0.0;
  myTolCheck=0.0000001;
  myTolAngCheck=0.3;
}

//=======================================================================
//function : GeomInt_IntSS
//purpose  : 
//=======================================================================
  GeomInt_IntSS::GeomInt_IntSS (const Handle(Geom_Surface)& S1,
			      const Handle(Geom_Surface)& S2,
			      const Standard_Real Tol,
			      const Standard_Boolean Approx,
			      const Standard_Boolean ApproxS1,
			      const Standard_Boolean ApproxS2)
{
  myHS1 = new GeomAdaptor_HSurface ();
  myHS2 = new GeomAdaptor_HSurface ();
  myTolReached2d= myTolReached3d=0.0;
  myTolCheck=0.0000001;
  myTolAngCheck=0.3;
  Perform(S1,S2,Tol,Approx,ApproxS1,ApproxS2);
}

//=======================================================================
//function : Perform
//purpose  : General intersection
//=======================================================================
  void GeomInt_IntSS::Perform(const Handle(Geom_Surface)& S1,
			    const Handle(Geom_Surface)& S2,
			    const Standard_Real Tol,
			    const Standard_Boolean Approx,
			    const Standard_Boolean ApproxS1,
			    const Standard_Boolean ApproxS2)
{
  myHS1->ChangeSurface().Load(S1);
  if (S1==S2)
    myHS2 = myHS1;
  else
    myHS2->ChangeSurface().Load(S2);
  Standard_Boolean useStart = Standard_False;
  InternalPerform(Tol,Approx,ApproxS1,ApproxS2,useStart,0.,0.,0.,0.);
}

//=======================================================================
//function : Perform
//purpose  : Intersection of Adapted surfaces
//=======================================================================
  void GeomInt_IntSS::Perform(const Handle(GeomAdaptor_HSurface)& HS1,
			    const Handle(GeomAdaptor_HSurface)& HS2,
			    const Standard_Real Tol,
			    const Standard_Boolean Approx,
			    const Standard_Boolean ApproxS1,
			    const Standard_Boolean ApproxS2)
{
  myHS1 = HS1;
  myHS2 = HS2;
  Standard_Boolean useStart = Standard_False;
  InternalPerform(Tol,Approx,ApproxS1,ApproxS2,useStart,0.,0.,0.,0.);
}

//=======================================================================
//function : Perform
//purpose  : General intersection with a Starting Point 
//=======================================================================
  void GeomInt_IntSS::Perform(const Handle(Geom_Surface)& S1,
			    const Handle(Geom_Surface)& S2,
			    const Standard_Real Tol,
			    const Standard_Real U1, const Standard_Real V1,
			    const Standard_Real U2, const Standard_Real V2,
			    const Standard_Boolean Approx,
			    const Standard_Boolean ApproxS1,
			    const Standard_Boolean ApproxS2)
{
  myHS1->ChangeSurface().Load(S1);
  if (S1==S2)
    myHS2 = myHS1;
  else
    myHS2->ChangeSurface().Load(S2);
  Standard_Boolean useStart = Standard_True;
  InternalPerform(Tol,Approx,ApproxS1,ApproxS2,useStart,U1,V1,U2,V2);
}

//=======================================================================
//function : Perform
//purpose  : Intersection of Adapted surfaces with a Starting Point
//=======================================================================
  void GeomInt_IntSS::Perform(const Handle(GeomAdaptor_HSurface)& HS1,
			    const Handle(GeomAdaptor_HSurface)& HS2,
			    const Standard_Real Tol,
			    const Standard_Real U1, const Standard_Real V1,
			    const Standard_Real U2, const Standard_Real V2,
			    const Standard_Boolean Approx,
			    const Standard_Boolean ApproxS1,
			    const Standard_Boolean ApproxS2)
{
  myHS1 = HS1;
  myHS2 = HS2;
  Standard_Boolean useStart = Standard_True;
  InternalPerform(Tol,Approx,ApproxS1,ApproxS2,useStart,U1,V1,U2,V2);
}

//=======================================================================
//function : Internal Perform
//purpose  : 
//=======================================================================
  void GeomInt_IntSS::InternalPerform(const Standard_Real Tol,
                                    const Standard_Boolean Approx,
                                    const Standard_Boolean ApproxS1,
                                    const Standard_Boolean ApproxS2,
                                    const Standard_Boolean useStart,
                                    const Standard_Real U1,
                                    const Standard_Real V1,
                                    const Standard_Real U2,
                                    const Standard_Real V2)
{
  myTolReached2d = myTolReached3d = 0.0;
  myNbrestr = 0;
  sline.Clear();
  Handle(Adaptor3d_TopolTool) dom1 = new Adaptor3d_TopolTool(myHS1);
  Handle(Adaptor3d_TopolTool) dom2 = new Adaptor3d_TopolTool(myHS2);
  myLConstruct.Load(dom1,dom2,myHS1,myHS2);

  Standard_Real TolArc;//     = 0.0000001;                                         
  Standard_Real TolTang;//    = 0.0000001;                                         
  Standard_Real UVMaxStep;//  = 0.01;                                              
  Standard_Real Deflection;// = 0.01;         

  TolArc = TolTang = Tol;// 1.e-7;
  Deflection = 0.1;
  UVMaxStep = 0.001;

  myIntersector.SetTolerances(TolArc,TolTang,UVMaxStep,Deflection);

  if(myHS1 == myHS2) {
    myIntersector.Perform(myHS1,dom1,TolArc,TolTang);
  }
  else if (!useStart) {
    myIntersector.Perform(myHS1,dom1,myHS2,dom2,TolArc,TolTang);
  }
  else {
    myIntersector.Perform(myHS1,dom1,myHS2,dom2,U1,V1,U2,V2,TolArc,TolTang);
  }
  // ============================================================
  if (myIntersector.IsDone()) {
    Standard_Integer nblin = myIntersector.NbLines();
    for (Standard_Integer i=1; i<= nblin; i++) {
      MakeCurve(i,dom1,dom2,Tol,Approx,ApproxS1,ApproxS2);
    }
  }
}

//=======================================================================
//function : IsDone
//purpose  : 
//=======================================================================
  Standard_Boolean GeomInt_IntSS::IsDone () const
{
  return myIntersector.IsDone();
}

//=======================================================================
//function : TolReached2d
//purpose  : 
//=======================================================================
  Standard_Real  GeomInt_IntSS::TolReached2d() const
{
  return myTolReached2d;
}

//=======================================================================
//function : TolReached3d
//purpose  : 
//=======================================================================
  Standard_Real  GeomInt_IntSS::TolReached3d() const
{
  return myTolReached3d;
}

//=======================================================================
//function : Line
//purpose  : 
//=======================================================================
  const Handle(Geom_Curve) & GeomInt_IntSS::Line (const Standard_Integer Index) const
{
  StdFail_NotDone_Raise_if(!myIntersector.IsDone(),"GeomInt_IntSS::Line");
  return sline(Index+myNbrestr);
}

//=======================================================================
//function : Boundary
//purpose  : 
//=======================================================================
  const Handle(Geom_Curve) & GeomInt_IntSS::Boundary (const Standard_Integer Index) const
{
  StdFail_NotDone_Raise_if(!myIntersector.IsDone(),"GeomInt_IntSS::Line");
  Standard_OutOfRange_Raise_if(Index <= 0 || Index > myNbrestr,
			       "GeomInt_IntSS::Boundary");
  return sline(Index);
}

//=======================================================================
//function : Pnt2d
//purpose  : 
//=======================================================================
  gp_Pnt2d GeomInt_IntSS::Pnt2d(const Standard_Integer Index,
			      const Standard_Boolean OnFirst) const
{
  const IntPatch_ThePointOfIntersection&  thept = myIntersector.Point(Index);
  Standard_Real U,V;
  if (OnFirst)
    thept.ParametersOnS1(U,V);
  else
    thept.ParametersOnS2(U,V);

  return gp_Pnt2d(U,V);
}

//=======================================================================
//function : HasLineOnS1
//purpose  : 
//=======================================================================
  Standard_Boolean GeomInt_IntSS::HasLineOnS1(const Standard_Integer index) const 
{ 
  StdFail_NotDone_Raise_if(!myIntersector.IsDone(),"GeomInt_IntSS::HasLineOnS1");
  Standard_Boolean b = slineS1(index).IsNull();
  return(!b);
}
//=======================================================================
//function : HasLineOnS2
//purpose  : 
//=======================================================================
  Standard_Boolean GeomInt_IntSS::HasLineOnS2(const Standard_Integer index) const 
{ 
  StdFail_NotDone_Raise_if(!myIntersector.IsDone(),"GeomInt_IntSS::HasLineOnS2");
  Standard_Boolean b = slineS2(index).IsNull();
  return(!b);
}
//=======================================================================
//function : LineOnS1
//purpose  : 
//=======================================================================
  const Handle(Geom2d_Curve) & GeomInt_IntSS::LineOnS1
(const Standard_Integer Index) const
{
  StdFail_NotDone_Raise_if(!myIntersector.IsDone(),"GeomInt_IntSS::LineOnS1");
  return slineS1(Index);
}
//=======================================================================
//function : LineOnS2
//purpose  : 
//=======================================================================
  const Handle(Geom2d_Curve) & GeomInt_IntSS::LineOnS2
(const Standard_Integer Index) const
{
  StdFail_NotDone_Raise_if(!myIntersector.IsDone(),"GeomInt_IntSS::LineOnS2");
  return slineS2(Index);
}

