/* MA1CDI.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Table of constant values */

static integer c__1 = 1;

/* Subroutine */ int mma1cdi_(ndimen, nbroot, rootlg, iordre, contr1, contr2, 
	somtab, diftab, fpntab, hermit, iercod)
integer *ndimen, *nbroot;
doublereal *rootlg;
integer *iordre;
doublereal *contr1, *contr2, *somtab, *diftab, *fpntab, *hermit;
integer *iercod;
{
    /* System generated locals */
    integer contr1_dim1, contr1_offset, contr2_dim1, contr2_offset, 
	    somtab_dim1, somtab_offset, diftab_dim1, diftab_offset, 
	    fpntab_dim1, fpntab_offset, hermit_dim1, hermit_offset, i__1, 
	    i__2, i__3;

    /* Local variables */
    extern /* Subroutine */ int mmmpocur_();
    static integer nroo2, ncfhe, nd, ii, kk;
    extern /* Subroutine */ int mma1her_();
    static integer ibb, kkm, kkp;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mgenmsg_();
    static doublereal bid1, bid2, bid3;
    extern /* Subroutine */ int mgsomsg_();




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Discretisation sur les parametres des polynomes d'interpolation */
/*     des contraintes a l'ordre IORDRE. */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS, AB_SPECIFI::CONTRAINTE&, DISCRETISATION, &POINT */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*     NDIMEN: Dimension de l' espace. */
/*     NBROOT: Nbre de parametres INTERNES de discretisation. */
/*             C'est aussi le nbre de racine du polynome de Legendre ou */
/*             on discretise. */
/*     ROOTLG: Tableau des parametres de discretisation SUR (-1,1). */
/*     IORDRE: Ordre de contrainte impose aux extremites de l'iso. */
/*             = 0, on calcule les extremites de l'iso */
/*             = 1, on calcule, en plus, la derivee 1ere dans le sens */
/*                  de l'iso */
/*             = 2, on calcule, en plus, la derivee 2nde dans le sens */
/*                  de l'iso */
/*     CONTR1: Contient, si IORDRE>=0, les IORDRE+1 valeurs en TTABLE(0) 
*/
/*             (1ere extremitee) de derivees de F(Uc,Ve) ou F(Ue,Vc), */
/*             voir ci dessous. */
/*     CONTR2: Contient, si IORDRE>=0, les IORDRE+1 valeurs en */
/*             TTABLE(NBROOT+1) (2eme extremitee) de: */
/*                Si ISOFAV=1, derivee d'ordre IDERIV en U, derivee */
/*             d'ordre 0 a IORDRE en V de F(Uc,Ve) ou Uc=TCONST */
/*             (valeur de l'iso fixe) et Ve est l'extremite fixe. */
/*                Si ISOFAV=2, derivee d'ordre IDERIV en V, derivee */
/*             d'ordre 0 a IORDRE en U de F(Ue,Vc) ou Vc=TCONST */
/*             (valeur de l'iso fixe) et Ue est l'extremite fixe. */

/*     SOMTAB: Tableau des NBROOT/2 sommes des 2 points d'indices */
/*             NBROOT-II+1 et II, pour II = 1, NBROOT/2. */
/*     DIFTAB: Tableau des NBROOT/2 differences des 2 points d'indices */
/*             NBROOT-II+1 et II, pour II = 1, NBROOT/2. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*     SOMTAB: Tableau des NBROOT/2 sommes des 2 points d'indices */
/*             NBROOT-II+1 et II, pour II = 1, NBROOT/2 */
/*     DIFTAB: Tableau des NBROOT/2 differences des 2 points d'indices */
/*             NBROOT-II+1 et II, pour II = 1, NBROOT/2 */
/*     FPNTAB: Tableau auxiliaire. */
/*     HERMIT: Table des coeff. des 2*(IORDRE+1) polynomes d'Hermite */
/*             de degre 2*IORDRE+1. */
/*     IERCOD: Code d'erreur, */
/*             = 0, Tout est OK */
/*             = 1, La valeur de IORDRE est hors de (0,2) */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     Les resultats de la discretisation sont ranges dans 2 tableaux */
/*     SOMTAB et DIFTAB pour gagner du temps par la suite lors du */
/*     calcul des coefficients de la courbe d' approximation. */

/*     Si NBROOT est impair, on stocke dans SOMTAB(0,*) et DIFTAB(0,*) */
/*     les valeurs de la racine mediane de Legendre (0.D0 dans (-1,1)). */


/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     02-07-1991: RBD; Creation. */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */


    /* Parameter adjustments */
    diftab_dim1 = *nbroot / 2 + 1;
    diftab_offset = diftab_dim1;
    diftab -= diftab_offset;
    somtab_dim1 = *nbroot / 2 + 1;
    somtab_offset = somtab_dim1;
    somtab -= somtab_offset;
    --rootlg;
    hermit_dim1 = (*iordre << 1) + 2;
    hermit_offset = hermit_dim1;
    hermit -= hermit_offset;
    fpntab_dim1 = *nbroot;
    fpntab_offset = fpntab_dim1 + 1;
    fpntab -= fpntab_offset;
    contr2_dim1 = *ndimen;
    contr2_offset = contr2_dim1 + 1;
    contr2 -= contr2_offset;
    contr1_dim1 = *ndimen;
    contr1_offset = contr1_dim1 + 1;
    contr1 -= contr1_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMA1CDI", 7L);
    }
    *iercod = 0;

/* --- Recup des 2*(IORDRE+1) coeff des 2*(IORDRE+1) polyn. d'Hermite --- 
*/

    mma1her_(iordre, &hermit[hermit_offset], iercod);
    if (*iercod > 0) {
	goto L9100;
    }

/* ------------------- Discretisation des polynomes d'Hermite ----------- 
*/

    ncfhe = (*iordre + 1) << 1;
    i__1 = ncfhe;
    for (ii = 1; ii <= i__1; ++ii) {
	i__2 = *nbroot;
	for (kk = 1; kk <= i__2; ++kk) {
	    mmmpocur_(&ncfhe, &c__1, &ncfhe, &hermit[ii * hermit_dim1], &
		    rootlg[kk], &fpntab[kk + ii * fpntab_dim1]);
/* L200: */
	}
/* L100: */
    }

/* ---- On retranche les discretisations des polynomes de contrainte ---- 
*/

    nroo2 = *nbroot / 2;
    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	i__2 = *iordre + 1;
	for (ii = 1; ii <= i__2; ++ii) {
	    bid1 = contr1[nd + ii * contr1_dim1];
	    bid2 = contr2[nd + ii * contr2_dim1];
	    i__3 = nroo2;
	    for (kk = 1; kk <= i__3; ++kk) {
		kkm = nroo2 - kk + 1;
		bid3 = bid1 * fpntab[kkm + ((ii << 1) - 1) * fpntab_dim1] + 
			bid2 * fpntab[kkm + (ii << 1) * fpntab_dim1];
		somtab[kk + nd * somtab_dim1] -= bid3;
		diftab[kk + nd * diftab_dim1] += bid3;
/* L500: */
	    }
	    i__3 = nroo2;
	    for (kk = 1; kk <= i__3; ++kk) {
		kkp = (*nbroot + 1) / 2 + kk;
		bid3 = bid1 * fpntab[kkp + ((ii << 1) - 1) * fpntab_dim1] + 
			bid2 * fpntab[kkp + (ii << 1) * fpntab_dim1];
		somtab[kk + nd * somtab_dim1] -= bid3;
		diftab[kk + nd * diftab_dim1] -= bid3;
/* L600: */
	    }
/* L400: */
	}
/* L300: */
    }

/* ------------ Cas ou l' on discretise sur les racines d' un ----------- 
*/
/* ---------- polynome de Legendre de degre impair, 0 est racine -------- 
*/

    if (*nbroot % 2 == 1) {
	i__1 = *ndimen;
	for (nd = 1; nd <= i__1; ++nd) {
	    i__2 = *iordre + 1;
	    for (ii = 1; ii <= i__2; ++ii) {
		bid3 = fpntab[nroo2 + 1 + ((ii << 1) - 1) * fpntab_dim1] * 
			contr1[nd + ii * contr1_dim1] + fpntab[nroo2 + 1 + (
			ii << 1) * fpntab_dim1] * contr2[nd + ii * 
			contr2_dim1];
/* L800: */
	    }
	    somtab[nd * somtab_dim1] -= bid3;
	    diftab[nd * diftab_dim1] -= bid3;
/* L700: */
	}
    }

    goto L9999;

/* ------------------------------ The End ------------------------------- 
*/
/* --> IORDRE n'est pas dans la plage autorisee. */
L9100:
    *iercod = 1;
    goto L9999;

L9999:
    if (ibb >= 3) {
	mgsomsg_("MMA1CDI", 7L);
    }
    return 0;
} /* mma1cdi_ */

